/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.ui;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.BDdfPointDeviceExt;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddf.discover.BIDdfDiscoveryHost;
import com.tridium.ddf.discover.BIDdfDiscoveryLeaf;
import com.tridium.ddf.discover.BIDdfDiscoveryObject;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences;
import com.tridium.ddf.ui.DdfUiLexicon;
import com.tridium.ddf.ui.device.BDdfDeviceManager;
import com.tridium.ddf.ui.point.BDdfPointManager;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.workbench.mgr.BAbstractManager;

public class DdfMgrUtil
implements IDdfFacetConst {
    protected DdfMgrUtil() {
    }

    public static Type getDiscoveryLeafType(BAbstractManager mgr) {
        BDdfDiscoveryPreferences ddfDiscoveryPrefs;
        BIDdfDiscoveryHost ddfDiscoveryHost = DdfMgrUtil.findDiscoveryHost(mgr);
        if (ddfDiscoveryHost != null && (ddfDiscoveryPrefs = ddfDiscoveryHost.getDiscoveryPreferences()) != null && ddfDiscoveryPrefs instanceof BDdfAutoDiscoveryPreferences && ddfDiscoveryPrefs.getType() != BDdfAutoDiscoveryPreferences.TYPE) {
            return ((BDdfAutoDiscoveryPreferences)ddfDiscoveryPrefs).getDiscoveryLeafType();
        }
        return null;
    }

    public static BIDdfDiscoveryLeaf getDiscoveryLeafInstance(BAbstractManager mgr) {
        Type discoveryLeafType = DdfMgrUtil.getDiscoveryLeafType(mgr);
        if (discoveryLeafType != null) {
            if (discoveryLeafType.is(BIDdfDiscoveryLeaf.TYPE)) {
                return (BIDdfDiscoveryLeaf)discoveryLeafType.getInstance();
            }
            return null;
        }
        return null;
    }

    public static Type getDatabaseType(BAbstractManager mgr) {
        if (mgr instanceof BDdfPointManager) {
            Type proxyExtType = ((BIPointFolder)mgr.getCurrentValue()).getProxyExtType();
            if (proxyExtType == null) {
                throw new BajaRuntimeException(DdfUiLexicon.LEX.getText("MustSpecifyProxyExtType", new Object[]{mgr.getCurrentValue().getType().getTypeSpec()}));
            }
            return proxyExtType;
        }
        if (mgr instanceof BDdfDeviceManager) {
            Type deviceType = ((BIDeviceFolder)mgr.getCurrentValue()).getDeviceType();
            if (deviceType == null) {
                throw new BajaRuntimeException(DdfUiLexicon.LEX.getText("MustSpecifyDeviceType", new Object[]{mgr.getCurrentValue().getType().getTypeSpec()}));
            }
            return deviceType;
        }
        throw new BajaRuntimeException("Not Implemented");
    }

    public static BComponent getDatabaseInstanceDefault(BAbstractManager mgr) {
        return (BComponent)DdfMgrUtil.getDatabaseType(mgr).getInstance();
    }

    public static BIDdfDiscoveryHost findDiscoveryHost(BAbstractManager mgr) {
        BIDdfDiscoveryHost ddfDiscoveryHost = DdfMgrUtil.findDiscoveryHost((BComplex)mgr.getCurrentValue());
        return ddfDiscoveryHost;
    }

    protected static BIDdfDiscoveryHost findDiscoveryHost(BComplex obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BIDdfDiscoveryHost) {
            return (BIDdfDiscoveryHost)obj;
        }
        return DdfMgrUtil.findDiscoveryHost(obj.getParent());
    }

    public static BDdfNetwork findDdfNetwork(BAbstractManager mgr) {
        return DdfMgrUtil.findDdfNetwork((BComplex)mgr.getCurrentValue());
    }

    public static BDdfDevice findDdfDevice(BAbstractManager mgr) {
        return DdfMgrUtil.findDdfDevice((BComplex)mgr.getCurrentValue());
    }

    public static BDdfPointDeviceExt findDdfPointDeviceExt(BAbstractManager mgr) {
        return DdfMgrUtil.findDdfPointDeviceExt((BComplex)mgr.getCurrentValue());
    }

    protected static BDdfNetwork findDdfNetwork(BComplex obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BDdfNetwork) {
            return (BDdfNetwork)obj;
        }
        return DdfMgrUtil.findDdfNetwork(obj.getParent());
    }

    protected static BDdfDevice findDdfDevice(BComplex obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BDdfDevice) {
            return (BDdfDevice)obj;
        }
        return DdfMgrUtil.findDdfDevice(obj.getParent());
    }

    protected static BDdfPointDeviceExt findDdfPointDeviceExt(BComplex obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BDdfPointDeviceExt) {
            return (BDdfPointDeviceExt)obj;
        }
        return DdfMgrUtil.findDdfPointDeviceExt(obj.getParent());
    }

    public static void doLoadManager(BAbstractManager mgr) {
        Object[] discoveryObjects;
        BFolder discoveryFolder;
        BIDdfDiscoveryHost discoveryHost = DdfMgrUtil.findDiscoveryHost(mgr);
        if (discoveryHost != null && (discoveryFolder = discoveryHost.getDiscoveryFolder()) != null && (discoveryObjects = discoveryFolder.getChildren(BIDdfDiscoveryObject.class)) != null) {
            mgr.getLearn().updateRoots(discoveryObjects);
            mgr.getController().learnMode.setSelected(true);
        }
    }
}

