/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BWeekday;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

class Utils {
    static final BBrush clrBg = Theme.widget().getWindowBackground();
    static final BBrush clrFg = Theme.widget().getWindowForeground();
    static final BBrush clrSelCurBg = Theme.widget().getSelectionBackground();
    static final BBrush clrSelBg = BBrush.makeSolid((BColor)BColor.darkSeaGreen);
    static final BBrush clrSelFg = Theme.widget().getSelectionForeground();
    static final BBrush clrRoBg = BBrush.makeSolid((BColor)BColor.lightGray);
    static final BBrush clrIndexEmptyFg = BBrush.makeSolid((BColor)BColor.darkGray);
    static final BImage imgAdd = BImage.make((BIcon)BIcon.std((String)"add.png"));
    static final BImage imgCalendar = BImage.make((BIcon)BIcon.std((String)"calendar.png"));
    static final BImage imgClock = BImage.make((BIcon)BIcon.std((String)"clock.png"));
    static final BImage imgDelete = BImage.make((BIcon)BIcon.std((String)"delete.png"));
    static final BImage imgDown = BImage.make((BIcon)BIcon.std((String)"arrowDown.png"));
    static final BImage imgEdit = BImage.make((BIcon)BIcon.std((String)"edit.png"));
    static final BImage imgRename = BImage.make((BIcon)BIcon.std((String)"rename.png"));
    static final BImage imgProps = BImage.make((BIcon)BIcon.std((String)"propertySheet.png"));
    static final BImage imgSchedule = BImage.make((BIcon)BIcon.std((String)"schedule.png"));
    static final BImage imgTrash = BImage.make((BIcon)BIcon.std((String)"trashCan.png"));
    static final BImage imgUp = BImage.make((BIcon)BIcon.std((String)"arrowUp.png"));
    static final int MILLIS_MIN = 60000;
    static final int MILLIS_HOUR = 3600000;
    static final int MILLIS_DAY = 86400000;
    static Lexicon lex;

    Utils() {
    }

    public static int dayToWeek(int d) {
        while (d % 7 != 0) {
            ++d;
        }
        return d / 7;
    }

    public static void error(BWidget parent, Throwable t) {
        BDialog.error((BWidget)parent, (String)Utils.lex("ui.error"), (Object)Utils.lex("ui.error"), (Throwable)t);
    }

    public static boolean lastWeek(int y, int m, int d) {
        return d > BAbsTime.getDaysInMonth((int)y, (BMonth)BMonth.make((int)m)) - 7;
    }

    public static String lex(String key) {
        if (lex == null) {
            lex = Lexicon.make(BAbstractSchedule.class);
        }
        return lex.getText(key);
    }

    public static String[] months() {
        return new String[]{BMonth.january.getShortDisplayTag(null), BMonth.february.getShortDisplayTag(null), BMonth.march.getShortDisplayTag(null), BMonth.april.getShortDisplayTag(null), BMonth.may.getShortDisplayTag(null), BMonth.june.getShortDisplayTag(null), BMonth.july.getShortDisplayTag(null), BMonth.august.getShortDisplayTag(null), BMonth.september.getShortDisplayTag(null), BMonth.october.getShortDisplayTag(null), BMonth.november.getShortDisplayTag(null), BMonth.december.getShortDisplayTag(null)};
    }

    protected static String monthYear(int month, int year) {
        return new String(Utils.months()[month] + " " + year);
    }

    public static String[] weekdays() {
        BWeekday[] ary = BWeekSchedule.daysInOrder(null);
        return new String[]{ary[0].getShortDisplayTag(null), ary[1].getShortDisplayTag(null), ary[2].getShortDisplayTag(null), ary[3].getShortDisplayTag(null), ary[4].getShortDisplayTag(null), ary[5].getShortDisplayTag(null), ary[6].getShortDisplayTag(null)};
    }
}

