/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BDaySlider;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

public class BSliderLabels
extends BWidget {
    public static final Type TYPE = Sys.loadType(BSliderLabels.class);
    private double left = 0.0;
    private double right = 0.0;
    private BDaySlider slider;

    public Type getType() {
        return TYPE;
    }

    public BSliderLabels(BDaySlider slider, double leftInset, double rightInset) {
        this.slider = slider;
        this.left = leftInset;
        this.right = rightInset;
    }

    public void computePreferredSize() {
        int[] unitLines = this.slider.unitLines;
        double pw = 0.0;
        int i = unitLines.length;
        while (--i >= 0) {
            int unit = unitLines[i];
            String label = this.slider.getUnitLabel(unit);
            pw = Math.max(pw, BDaySlider.font.width(label) + this.left + this.right);
        }
        this.slider.computePreferredSize();
        this.setPreferredSize(pw, this.slider.getPreferredHeight());
    }

    public void paint(Graphics g) {
        int[] unitLines = this.slider.unitLines;
        g.setBrush(BDaySlider.widgetTheme.getTextBrush());
        g.setFont(BDaySlider.font);
        if (unitLines != null) {
            double h = this.getHeight();
            double w = this.getWidth();
            double diff = h - this.slider.getHeight();
            double x = this.getX() + w - this.right;
            double height = h - diff;
            double offset = BDaySlider.font.getMaxDescent() + diff / 2.0;
            int i = unitLines.length;
            while (--i >= 0) {
                int unit = unitLines[i];
                double y = this.slider.unitToY(unit);
                String label = this.slider.getUnitLabel(unit);
                g.drawString(label, x - BDaySlider.font.width(label), y + offset);
            }
        }
    }
}

