/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleView;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BDaySlider;
import com.tridium.schedule.ui.BLatticePane;
import com.tridium.schedule.ui.BSliderLabels;
import com.tridium.schedule.ui.BTimeScheduleEd;
import javax.baja.gx.BInsets;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;

public class BDayEd
extends BAbstractScheduleWidget
implements BDaySlider.Clipboard {
    public static final Action clearWeek = BDayEd.newAction((int)0, null);
    public static final Action fillWeek = BDayEd.newAction((int)0, (BValue)new BDaySchedule(), null);
    public static final Action sliderDragged = BDayEd.newAction((int)0, null);
    public static final Action sliderRemoved = BDayEd.newAction((int)0, null);
    public static final Action sliderModified = BDayEd.newAction((int)0, null);
    public static final Action sliderSelected = BDayEd.newAction((int)0, (BValue)new BDaySlider(), null);
    public static final Action tedModified = BDayEd.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BDayEd.class);
    BDaySchedule clipboard;
    BDaySlider current;
    BStatusValue defaultValue;
    BStatusValue lastEffectiveValue;
    BDaySchedule[] schedules;
    String[] scheduleLabels;
    BDaySlider[] sliders;
    BLabel[] sliderHeaders;
    BLatticePane sliderContainer = new BLatticePane();
    BTimeScheduleEd ted;

    public void clearWeek() {
        this.invoke(clearWeek, null, null);
    }

    public void fillWeek(BDaySchedule ard) {
        this.invoke(fillWeek, (BValue)ard, null);
    }

    public void sliderDragged() {
        this.invoke(sliderDragged, null, null);
    }

    public void sliderRemoved() {
        this.invoke(sliderRemoved, null, null);
    }

    public void sliderModified() {
        this.invoke(sliderModified, null, null);
    }

    public void sliderSelected(BDaySlider arg) {
        this.invoke(sliderSelected, (BValue)arg, null);
    }

    public void tedModified() {
        this.invoke(tedModified, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDayEd(boolean daily) {
        if (daily) {
            this.sliders = new BDaySlider[1];
            this.sliders[0] = new BDaySlider(this, false);
            this.addSlider(this.sliders[0], null, 0);
        } else {
            this.sliderContainer.cols = 7;
            this.sliderContainer.rows = 1;
            this.sliders = new BDaySlider[7];
            this.sliderHeaders = new BLabel[7];
            for (int i = 0; i < this.sliders.length; ++i) {
                this.sliders[i] = new BDaySlider(this, true);
                this.sliderHeaders[i] = new BLabel();
                this.addSlider(this.sliders[i], this.sliderHeaders[i], i == 0 ? 0 : 5);
            }
        }
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)this.sliderContainer);
        BEdgePane sep = new BEdgePane();
        sep.setTop((BWidget)new BLabel(" "));
        sep.setCenter((BWidget)new BSliderLabels(this.sliders[0], 10.0, 5.0));
        content.setLeft((BWidget)new BBorderPane((BWidget)sep, 0.0, 0.0, 0.0, 0.0));
        this.ted = new BTimeScheduleEd();
        BBorderPane bp = new BBorderPane((BWidget)this.ted, 10.0, 0.0, 0.0, 0.0);
        content.setBottom((BWidget)bp);
        this.linkTo((BComponent)this.ted, (Slot)BTimeScheduleEd.modified, (Slot)tedModified);
        this.setContent((BWidget)content);
    }

    public void doClearWeek() {
        int i = this.schedules.length;
        while (--i >= 0) {
            this.sliders[i].clearDay();
        }
        this.sliderContainer.repaint();
        this.fireModified(null);
    }

    public void doFillWeek(BDaySchedule sch) {
        String sat = BWeekday.saturday.getShortDisplayTag(null);
        String sun = BWeekday.sunday.getShortDisplayTag(null);
        int i = this.schedules.length;
        while (--i >= 0) {
            if (this.schedules[i] == sch || this.scheduleLabels[i].equals(sat) || this.scheduleLabels[i].equals(sun)) continue;
            this.sliders[i].clearDay();
            this.sliders[i].copy(sch);
        }
        this.sliderContainer.repaint();
        this.fireModified(null);
    }

    public void doSliderDragged() {
        this.ted.reload();
    }

    public void doSliderRemoved() {
        this.ted.setReadonly(true);
        this.fireModified(null);
    }

    public void doSliderModified() {
        this.ted.reload();
        this.fireModified(null);
    }

    public void doSliderSelected(BDaySlider slider) {
        if (this.current != null && this.current != slider) {
            this.current.deselect();
        }
        this.current = slider;
        if (this.current.getSelectedSchedule() == null) {
            this.ted.setReadonly(true);
        } else {
            this.ted.setReadonly(this.isReadonly());
            this.ted.load(this.current.getSelectedSchedule(), this.current.selectedEarliestStart(), this.current.selectedLatestFinish());
            this.ted.relayout();
        }
    }

    public void doTedModified() {
        this.current.updateSelectedSchedule();
        this.lastEffectiveValue = this.current.getSelectedSchedule().getEffectiveValue();
        this.fireModified(null);
    }

    @Override
    public BDaySchedule get() {
        return this.clipboard;
    }

    @Override
    public BStatusValue newEffectiveValue() {
        BStatus s;
        if (this.lastEffectiveValue != null) {
            return (BStatusValue)this.lastEffectiveValue.newCopy(true);
        }
        BAbstractScheduleView view = this.getView();
        BStatusValue ret = this.defaultValue;
        if ((ret = (BStatusValue)ret.newCopy(true)) instanceof BStatusBoolean) {
            BStatusBoolean b;
            b.setValue(!(b = (BStatusBoolean)ret).getValue());
        }
        if ((s = ret.getStatus()).isNull()) {
            ret.setStatus(BStatus.makeNull((BStatus)s, (boolean)false));
        }
        return ret;
    }

    @Override
    public void set(BDaySchedule sch) {
        this.clipboard = sch;
    }

    public void setDaySchedule(BAbstractSchedule absSched, BDaySchedule sch) {
        this.defaultValue = (BStatusValue)absSched.get("defaultOutput");
        this.schedules = new BDaySchedule[]{sch};
        this.scheduleLabels = new String[]{""};
        this.sliders[0].load(this.schedules[0], this.defaultValue);
        this.sliders[0].relayout();
        BAbstractSchedule root = absSched.getRootSchedule();
        BFacets facets = (BFacets)root.get("facets");
        this.ted.loadProto(this.newEffectiveValue(), facets);
        this.ted.setReadonly(true);
    }

    @Override
    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        for (int i = 0; i < this.sliders.length; ++i) {
            this.sliders[i].setReadonly(ro);
        }
    }

    public void setWeekSchedule(BAbstractSchedule absSched, BWeekSchedule ws) {
        this.defaultValue = (BStatusValue)absSched.get("defaultOutput");
        BDailySchedule[] ary = ws.schedulesInOrder(null);
        BWeekday[] ary2 = BWeekSchedule.daysInOrder(null);
        this.schedules = new BDaySchedule[7];
        this.scheduleLabels = new String[7];
        for (int i = 0; i < 7; ++i) {
            this.schedules[i] = ary[i].getDay();
            this.scheduleLabels[i] = ary2[i].getShortDisplayTag(null);
            this.sliders[i].load(this.schedules[i], this.defaultValue);
            this.sliders[i].relayout();
            this.sliderHeaders[i].setText(this.scheduleLabels[i]);
            this.sliderHeaders[i].relayout();
        }
        BAbstractSchedule root = ws.getRootSchedule();
        BFacets facets = (BFacets)root.get("facets");
        this.ted.loadProto(this.newEffectiveValue(), facets);
        this.ted.setReadonly(true);
    }

    private void addSlider(BDaySlider slider, BLabel sliderLabel, int borderWidth) {
        BBorderPane bp = new BBorderPane((BWidget)slider);
        bp.setPadding(BInsets.DEFAULT);
        bp.setBorder(BBorder.DEFAULT);
        this.sliderContainer.add(this.makeColumn(sliderLabel, (BWidget)bp, borderWidth));
        this.linkTo((BComponent)slider, (Slot)BDaySlider.clearWeek, (Slot)clearWeek);
        this.linkTo((BComponent)slider, (Slot)BDaySlider.fillWeek, (Slot)fillWeek);
        this.linkTo((BComponent)slider, (Slot)BDaySlider.modified, (Slot)sliderModified);
        this.linkTo((BComponent)slider, (Slot)BDaySlider.schDragged, (Slot)sliderDragged);
        this.linkTo((BComponent)slider, (Slot)BDaySlider.schRemoved, (Slot)sliderRemoved);
        this.linkTo((BComponent)slider, (Slot)BDaySlider.schSelected, (Slot)sliderSelected);
    }

    private BWidget makeColumn(BLabel label, BWidget body, int borderWidth) {
        BEdgePane ep = new BEdgePane();
        if (label != null) {
            ep.setTop((BWidget)label);
        }
        ep.setCenter(body);
        return new BBorderPane((BWidget)ep, 0.0, 0.0, 0.0, (double)borderWidth);
    }
}

