/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.schedule.ScheduleUtil;
import com.tridium.schedule.ui.Utils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.OrdTarget;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.space.BISpaceNode;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.view.BWbComponentView;

public abstract class BAbstractScheduleView
extends BWbComponentView {
    public static final Action enableSave = BAbstractScheduleView.newAction((int)0, null);
    public static final Action save = BAbstractScheduleView.newAction((int)0, null);
    public static final Action refresh = BAbstractScheduleView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAbstractScheduleView.class);
    protected BButton btnSave;
    protected BButton btnRefresh;
    protected Context context;
    private boolean readonly = false;
    private BAbstractSchedule base;
    protected BAbstractSchedule schedule;
    protected static Logger LOG = Logger.getLogger("schedule");

    public void enableSave() {
        this.invoke(enableSave, null, null);
    }

    public void save() {
        this.invoke(save, null, null);
    }

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BAbstractScheduleView() {
    }

    public void doEnableSave() {
        if (!this.readonly() && this.btnSave != null) {
            this.btnSave.setEnabled(true);
        }
    }

    public void doSave() {
        this.getWbShell().getSaveCommand().invoke();
    }

    public void doRefresh() {
        this.getWbShell().getRefreshCommand().invoke();
    }

    public BAbstractSchedule getBase() {
        return this.base;
    }

    public String lex(String key) {
        return Utils.lex(key);
    }

    public boolean readonly() {
        return this.readonly || this.isReadonly();
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        Property prop;
        this.base = (BAbstractSchedule)value;
        BComplex parent = this.base.getParent();
        if (Flags.isReadonly((BComplex)parent, (Slot)(prop = this.base.getPropertyInParent()))) {
            this.readonly = true;
        } else {
            OrdTarget ot = this.base.getHandleOrd().resolve((BObject)this.base, cx);
            boolean bl = this.readonly = !ot.canWrite();
        }
        if (!this.readonly && this.base.get("ext") != null) {
            this.readonly = true;
        }
        this.schedule = (BAbstractSchedule)this.base.newCopy(true);
        this.schedule.add("refBase", (BValue)this.base.getAbsoluteOrd(), 6);
        this.context = cx;
        if (this.btnSave != null) {
            this.btnSave.setEnabled(false);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        ScheduleUtil.validateSchedule((BAbstractSchedule)this.schedule, (Context)cx);
        if (this.btnSave != null) {
            this.btnSave.setEnabled(false);
        }
        BAbstractSchedule sch = (BAbstractSchedule)value;
        BValue refBase = this.schedule.get("refBase");
        this.schedule.remove("refBase");
        BBoolean success = null;
        try {
            success = FoxRpcUtil.doSilentRpc((BISpaceNode)sch, (String)"auditableCopyFrom", (Object[])new Object[]{this.schedule}).orElse(BBoolean.FALSE);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Remote audit is not available.", e);
        }
        if ((success == null || !success.getBoolean()) && sch.getPermissions(cx).hasAdminInvoke() && sch.getPermissions(cx).hasAdminWrite()) {
            try {
                Context tx = Transaction.start((BComponent)sch, (Context)cx);
                ScheduleUtil.auditableCopyFrom((BComplex)sch, (BComplex)this.schedule, (Context)tx);
                if (sch instanceof BControlSchedule) {
                    sch.invoke(BControlSchedule.execute, null, tx);
                }
                Transaction.end((BComponent)sch, (Context)tx);
                success = BBoolean.TRUE;
                LOG.fine("Remote audit is not available, workbench side audit complete.");
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Workbench audit is not available.", e);
            }
        }
        if (success == null || !success.getBoolean()) {
            sch.copyFrom(this.schedule, cx);
            LOG.warning("Schedule saved, but detailed audit is not available");
        }
        this.schedule.add("refBase", refBase);
        return sch;
    }

    protected BButton makeRefreshBtn() {
        Lexicon l = Lexicon.make(BButton.class);
        this.btnRefresh = new BButton(new Command((BWidget)this, l, "commands.refresh"));
        this.linkTo((BComponent)this.btnRefresh, (Slot)BButton.actionPerformed, (Slot)refresh);
        this.linkTo((BComponent)this, (Slot)BWbPlugin.pluginModified, (Slot)enableSave);
        return this.btnRefresh;
    }

    protected BButton makeSaveBtn() {
        Lexicon l = Lexicon.make(BButton.class);
        this.btnSave = new BButton(new Command((BWidget)this, l, "commands.save"));
        this.linkTo((BComponent)this.btnSave, (Slot)BButton.actionPerformed, (Slot)save);
        this.btnSave.setEnabled(false);
        return this.btnSave;
    }
}

