/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.schedule;

import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.schedule.BBacnetChangeTypeParm;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import com.tridium.ui.theme.Theme;
import javax.baja.bacnet.datatypes.BBacnetAny;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetTimeValue;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BChangeTypeDialog
extends BDialog {
    public static final Action typeChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action oprChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action superChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action defaultChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action weeklyChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action exceptionChanged = BChangeTypeDialog.newAction((int)0, null);
    public static final Action buttonPressed = BChangeTypeDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BChangeTypeDialog.class);
    BBacnetChangeTypeParm wrkParam;
    BBacnetChangeTypeParm origParam;
    BAbstractSchedule sch;
    int asnType;
    BBacnetScheduleExport base;
    BButton applyButton;
    BButton cancelButton;
    BButton saveButton;
    int result = 0;
    boolean hasWeekly;
    boolean hasException;
    private BListDropDown typeDrpDwn;
    private BWbFieldEditor oprEditor;
    private BWbFieldEditor defaultEditor;
    private BWbFieldEditor superEditor;
    private BWbFieldEditor weeklyEditor;
    private BWbFieldEditor exceptionEditor;
    private BLabel oprErr;
    private BLabel defErr;
    private BLabel ordErr;
    private BLabel wkSchErr;
    private BLabel exSchErr;

    public void typeChanged() {
        this.invoke(typeChanged, null, null);
    }

    public void oprChanged() {
        this.invoke(oprChanged, null, null);
    }

    public void superChanged() {
        this.invoke(superChanged, null, null);
    }

    public void defaultChanged() {
        this.invoke(defaultChanged, null, null);
    }

    public void weeklyChanged() {
        this.invoke(weeklyChanged, null, null);
    }

    public void exceptionChanged() {
        this.invoke(exceptionChanged, null, null);
    }

    public void buttonPressed(BWidgetEvent event) {
        this.invoke(buttonPressed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BChangeTypeDialog() {
    }

    public BChangeTypeDialog(BWidget parent, UiLexicon lex, BBacnetScheduleExport s, BBacnetChangeTypeParm params) {
        super(parent, lex.getText("changeType.title"), true);
        this.origParam = params;
        this.wrkParam = (BBacnetChangeTypeParm)params.newCopy(true);
        this.base = s;
        this.sch = s.getSupervisor();
        this.asnType = AsnUtil.getAsnType((String)s.getDataType());
        this.hasWeekly = params.getHasWeeklySchedule();
        this.hasException = params.getHasExceptionSchedule();
        this.typeDrpDwn = new BListDropDown();
        this.loadTypesDD();
        this.typeDrpDwn.setSelectedItem((Object)this.wrkParam.getDataType());
        this.linkTo((BComponent)this.typeDrpDwn, (Slot)BListDropDown.listActionPerformed, (Slot)typeChanged);
        this.defaultEditor = BWbFieldEditor.makeFor((BObject)this.wrkParam.getScheduleDefault());
        this.defaultEditor.loadValue((BObject)this.wrkParam.getScheduleDefault());
        this.linkTo((BComponent)this.defaultEditor, (Slot)BWbFieldEditor.setModified, (Slot)defaultChanged);
        this.superEditor = BWbFieldEditor.makeFor((BObject)BOrd.NULL);
        this.superEditor.loadValue((BObject)this.wrkParam.getSupervisorOrd());
        this.linkTo((BComponent)this.superEditor, (Slot)BWbFieldEditor.setModified, (Slot)superChanged);
        this.oprEditor = BWbFieldEditor.makeFor((BObject)this.wrkParam.getListOfObjectPropertyRefs());
        this.oprEditor.loadValue((BObject)this.wrkParam.getListOfObjectPropertyRefs());
        this.linkTo((BComponent)this.oprEditor, (Slot)BWbFieldEditor.setModified, (Slot)oprChanged);
        if (this.hasWeekly) {
            this.weeklyEditor = BWbFieldEditor.makeFor((BObject)this.wrkParam.getWeeklySchedule());
            this.weeklyEditor.loadValue((BObject)this.wrkParam.getWeeklySchedule());
            this.linkTo((BComponent)this.weeklyEditor, (Slot)BWbFieldEditor.setModified, (Slot)weeklyChanged);
        }
        if (this.hasException) {
            this.exceptionEditor = BWbFieldEditor.makeFor((BObject)this.wrkParam.getExceptionSchedule());
            this.exceptionEditor.loadValue((BObject)this.wrkParam.getExceptionSchedule());
            this.linkTo((BComponent)this.exceptionEditor, (Slot)BWbFieldEditor.setModified, (Slot)exceptionChanged);
        }
        BBrush red = BBrush.makeSolid((BColor)BColor.red);
        this.oprErr = new BLabel(lex.getText("changeType.objectPropertReferenceErr"));
        this.oprErr.setForeground(red);
        this.defErr = new BLabel(lex.getText("changeType.scheduleDefaultErr"));
        this.defErr.setForeground(red);
        this.ordErr = new BLabel(lex.getText("changeType.supervisorOrdErr"));
        this.ordErr.setForeground(red);
        if (this.hasWeekly) {
            this.wkSchErr = new BLabel(lex.getText("changeType.scheduleErr"));
            this.wkSchErr.setForeground(red);
        }
        if (this.hasException) {
            this.exSchErr = new BLabel(lex.getText("changeType.scheduleErr"));
            this.exSchErr.setForeground(red);
        }
        this.applyButton = new BButton(lex.getText("changeType.button.apply"));
        this.linkTo((BComponent)this.applyButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.cancelButton = new BButton(lex.getText("changeType.button.cancel"));
        this.linkTo((BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.saveButton = new BButton(lex.getText("changeType.button.save"));
        this.linkTo((BComponent)this.saveButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.saveButton.setEnabled(false);
        BGridPane editPane = new BGridPane(2);
        editPane.add(null, (BValue)new BLabel(lex.getText("changeType.type")));
        editPane.add(null, (BValue)this.typeDrpDwn);
        editPane.add(null, (BValue)new BLabel(lex.getText("changeType.scheduleDefault")));
        editPane.add(null, (BValue)this.defaultEditor);
        editPane.add(null, (BValue)new BLabel());
        editPane.add(null, (BValue)this.defErr);
        editPane.add(null, (BValue)new BLabel(lex.getText("changeType.supervisorOrd")));
        editPane.add(null, (BValue)this.superEditor);
        editPane.add(null, (BValue)new BLabel());
        editPane.add(null, (BValue)this.ordErr);
        editPane.add(null, (BValue)new BLabel(lex.getText("changeType.objPropRef")));
        editPane.add(null, (BValue)this.oprEditor);
        editPane.add(null, (BValue)new BLabel());
        editPane.add(null, (BValue)this.oprErr);
        if (this.hasWeekly) {
            editPane.add(null, (BValue)new BLabel(lex.getText("changeType.weeklySchedule")));
            editPane.add(null, (BValue)this.weeklyEditor);
            editPane.add(null, (BValue)new BLabel());
            editPane.add(null, (BValue)this.wkSchErr);
        }
        if (this.hasException) {
            editPane.add(null, (BValue)new BLabel(lex.getText("changeType.exceptionSchedule")));
            editPane.add(null, (BValue)this.exceptionEditor);
            editPane.add(null, (BValue)new BLabel());
            editPane.add(null, (BValue)this.exSchErr);
        }
        BFlowPane buttonPane = new BFlowPane();
        buttonPane.setAlign(BHalign.center);
        buttonPane.add("applyButton", (BValue)this.applyButton);
        buttonPane.add("cancelButton", (BValue)this.cancelButton);
        buttonPane.add("saveButton", (BValue)this.saveButton);
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)editPane, 10.0, 10.0, 10.0, 10.0));
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)scrollPane));
        pane.setBottom((BWidget)new BBorderPane((BWidget)buttonPane));
        this.setContent((BWidget)pane);
        this.setBoundsCenteredOnOwner();
        this.verifyAll();
    }

    public BBacnetChangeTypeParm getScheduleExport() {
        this.wrkParam.setTypeChanged(!this.wrkParam.getDataType().equals(this.origParam.getDataType()));
        this.wrkParam.setSuperChanged(!this.wrkParam.getSupervisorOrd().equals((Object)this.origParam.getSupervisorOrd()));
        this.wrkParam.setOprChanged(!this.wrkParam.getListOfObjectPropertyRefs().equivalent((Object)this.origParam.getListOfObjectPropertyRefs()));
        this.wrkParam.setSchedDefChanged(!this.wrkParam.getScheduleDefault().equivalent((Object)this.origParam.getScheduleDefault()));
        if (this.wrkParam.getHasWeeklySchedule()) {
            this.wrkParam.setWeeklyChanged(!this.equivalentSchedules((BComponent)this.wrkParam.getWeeklySchedule(), (BComponent)this.origParam.getWeeklySchedule()));
        }
        if (this.wrkParam.getHasExceptionSchedule()) {
            this.wrkParam.setExceptionChanged(!this.equivalentSchedules((BComponent)this.wrkParam.getExceptionSchedule(), (BComponent)this.origParam.getExceptionSchedule()));
        }
        return this.wrkParam;
    }

    boolean equivalentSchedules(BComponent c1, BComponent c2) {
        BIBacnetDataType[] ca2;
        BIBacnetDataType[] ca1 = (BIBacnetDataType[])c1.getChildren(BIBacnetDataType.class);
        if (ca1.length != (ca2 = (BIBacnetDataType[])c2.getChildren(BIBacnetDataType.class)).length) {
            return false;
        }
        for (int i = 0; i < ca1.length; ++i) {
            if (((BComplex)ca1[i]).equivalent((Object)ca2[i])) continue;
            return false;
        }
        return true;
    }

    public void doButtonPressed(BWidgetEvent event) {
        if (event.getWidget().equals((Object)this.saveButton)) {
            this.saveSchedules();
            this.saveButton.setEnabled(false);
            return;
        }
        if (event.getWidget().equals((Object)this.applyButton)) {
            this.result = 1;
        } else if (event.getWidget().equals((Object)this.cancelButton)) {
            this.result = 2;
        }
        this.close();
    }

    public void windowClosing(BWindowEvent event) {
        this.result = 2;
        this.close();
    }

    public int getResult() {
        return this.result;
    }

    public void doTypeChanged() throws Exception {
        String ty = (String)this.typeDrpDwn.getSelectedItem();
        this.wrkParam.setDataType(ty);
        this.asnType = AsnUtil.getAsnType((String)ty);
        this.verifyAll();
    }

    public void doOprChanged() throws Exception {
        this.oprEditor.saveValue();
        this.verifyOprCorrectType();
    }

    public void doSuperChanged() throws Exception {
        BOrd ord = (BOrd)this.superEditor.saveValue();
        this.wrkParam.setSupervisorOrd(ord);
        this.sch = (BAbstractSchedule)ord.resolve((BObject)this.base).get();
        this.verifySuperCorrectType();
    }

    public void doDefaultChanged() throws Exception {
        this.defaultEditor.saveValue();
        this.verifyDefaultCorrectType();
    }

    public void doWeeklyChanged() throws Exception {
        if (!this.hasWeekly) {
            return;
        }
        this.saveButton.setEnabled(true);
    }

    public void doExceptionChanged() throws Exception {
        if (!this.hasException) {
            return;
        }
        this.saveButton.setEnabled(true);
    }

    void saveSchedules() {
        if (this.hasWeekly) {
            try {
                this.weeklyEditor.saveValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.verifyWeeklyCorrectType();
        }
        if (this.hasException) {
            try {
                this.exceptionEditor.saveValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.verifyExceptionCorrectType();
        }
    }

    private void verifyAll() {
        this.verifySuperCorrectType();
        this.verifyOprCorrectType();
        this.verifyDefaultCorrectType();
        this.verifyWeeklyCorrectType();
        this.verifyExceptionCorrectType();
    }

    private void verifySuperCorrectType() {
        Type t = this.sch.getType();
        boolean match = false;
        switch (this.asnType) {
            case 1: {
                if (!t.is(BBooleanSchedule.TYPE)) break;
                match = true;
                break;
            }
            case 4: {
                if (!t.is(BNumericSchedule.TYPE)) break;
                match = true;
                break;
            }
            case 2: 
            case 9: {
                if (!t.is(BEnumSchedule.TYPE)) break;
                match = true;
                break;
            }
            case 7: {
                match = true;
            }
        }
        this.ordErr.setVisible(!match);
    }

    private void verifyOprCorrectType() {
        BBacnetListOf lopr = (BBacnetListOf)this.oprEditor.getCurrentValue();
        boolean valid = true;
        BBacnetObjectPropertyReference[] opr = (BBacnetObjectPropertyReference[])lopr.getChildren(BBacnetObjectPropertyReference.class);
        for (int i = 0; i < opr.length; ++i) {
            PropertyInfo pi = ObjectTypeList.getInstance().getPropertyInfo(opr[i].getObjectId().getObjectType(), opr[i].getPropertyId());
            if (pi != null && this.isValidType(pi.getAsnType())) continue;
            valid = false;
            break;
        }
        this.oprErr.setVisible(!valid);
    }

    private void verifyDefaultCorrectType() {
        this.defErr.setVisible(!this.isValidType(((BBacnetAny)this.defaultEditor.getCurrentValue()).getChoice()));
    }

    private boolean isValidType(int choice) {
        return choice == this.asnType;
    }

    private void verifyWeeklyCorrectType() {
        if (!this.hasWeekly) {
            return;
        }
        this.wkSchErr.setVisible(!this.isAllValid((BComponent)this.weeklyEditor.getCurrentValue()));
    }

    private void verifyExceptionCorrectType() {
        if (!this.hasException) {
            return;
        }
        this.exSchErr.setVisible(!this.isAllValid((BComponent)this.exceptionEditor.getCurrentValue()));
    }

    private boolean isAllValid(BComponent c) {
        if (c instanceof BBacnetTimeValue) {
            return this.isValidType(((BBacnetTimeValue)c).getValue().getChoice());
        }
        SlotCursor sc = c.getProperties();
        while (sc.nextComponent()) {
            BComponent cp = (BComponent)sc.get();
            if (this.isAllValid(cp)) continue;
            return false;
        }
        return true;
    }

    private void loadTypesDD() {
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName((int)4));
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName((int)9));
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName((int)1));
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName((int)2));
        this.typeDrpDwn.getList().addItem((Object)AsnUtil.getAsnTypeName((int)7));
    }
}

