/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.schedule;

import com.tridium.bacnet.schedule.BBacnetChangeTypeParm;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import com.tridium.bacnet.ui.schedule.BChangeTypeDialog;
import com.tridium.bacnet.ui.schedule.ScheduleLearn;
import com.tridium.bacnet.ui.schedule.ScheduleState;
import java.text.MessageFormat;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.driver.schedule.BScheduleExport;
import javax.baja.driver.ui.schedule.BScheduleExportManager;
import javax.baja.driver.ui.schedule.ScheduleExportController;
import javax.baja.driver.ui.schedule.ScheduleExportModel;
import javax.baja.driver.util.BDescriptor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BBacnetScheduleExportManager
extends BScheduleExportManager {
    public static final Type TYPE = Sys.loadType(BBacnetScheduleExportManager.class);
    BWbEditor dataTypeEditor = null;
    private BBacnetScheduleDeviceExt deviceExt;
    static final UiLexicon lex = UiLexicon.makeUiLexicon(BBacnetScheduleExportManager.class);
    MgrColumn objectIdCol = new MgrColumn.Prop(BBacnetScheduleExport.objectId, 1);
    MgrColumn dataTypeCol = new DataTypeCol();
    MgrColumn supervisorOrdCol = new SupervisorOrdCol();
    private static Lexicon wblex = Lexicon.make(MgrController.class);
    private static String addLabel = wblex.getText("add.label");
    private static String newLabel = wblex.getText("new.label");

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject obj, Context cx) {
        this.deviceExt = (BBacnetScheduleDeviceExt)obj;
        super.doLoadValue(obj, cx);
    }

    public void restoreState() {
        MgrState state = MgrState.getCached((String)ScheduleState.toKey(this));
        if (state != null) {
            state.restore((BAbstractManager)this);
        }
    }

    public void saveState() {
        MgrState state = this.makeState();
        if (state != null) {
            state.save((BAbstractManager)this);
            MgrState.cache((String)ScheduleState.toKey(this), (MgrState)state);
        }
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrState makeState() {
        return ScheduleState.getState();
    }

    public BBacnetScheduleDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        return (BBacnetScheduleDeviceExt)this.getCurrentValue();
    }

    public BBacnetDevice getDevice() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    CommandArtifact doChangeType() {
        BComponent[] a = this.getController().getTable().getSelectedComponents();
        BBacnetScheduleExport origSchExp = (BBacnetScheduleExport)a[0];
        origSchExp.lease(Integer.MAX_VALUE);
        BBacnetChangeTypeParm param = origSchExp.readChangeTypeParams();
        if (param == null) {
            throw new BajaRuntimeException("Unable to access target schedule object");
        }
        BChangeTypeDialog changeDialogue = new BChangeTypeDialog((BWidget)this.getController().getManager(), lex, origSchExp, param);
        changeDialogue.open();
        int retVal = changeDialogue.getResult();
        if (retVal == 2) {
            return null;
        }
        origSchExp.changeType(changeDialogue.getScheduleExport());
        return null;
    }

    public class DataTypeCol
    extends MgrColumn.Prop {
        public DataTypeCol() {
            super(BBacnetScheduleExport.dataType, 5);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BBacnetScheduleExportManager.this.dataTypeEditor = super.toEditor(rows, colIndex, currentEditor);
            return BBacnetScheduleExportManager.this.dataTypeEditor;
        }
    }

    public class SupervisorOrdCol
    extends MgrColumn.Prop {
        public SupervisorOrdCol() {
            super(BBacnetScheduleExport.supervisorOrd, 1);
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor edt) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)edt;
            BOrd ord = (BOrd)editor.saveValue();
            try {
                String typ = lex.getText("asn.characterString");
                BObject o = ord.resolve((BObject)rows[0].getTarget()).get();
                if (o == null) {
                    return;
                }
                if (o instanceof BBooleanSchedule) {
                    typ = lex.getText("asn.boolean");
                } else if (o instanceof BNumericSchedule) {
                    typ = lex.getText("asn.real");
                } else if (o instanceof BEnumSchedule) {
                    typ = lex.getText("asn.enumerated");
                }
                BString btyp = BString.make((String)typ);
                for (int i = 0; i < rows.length; ++i) {
                    rows[i].setCell(BBacnetScheduleExportManager.this.dataTypeCol, (BValue)btyp);
                }
                if (BBacnetScheduleExportManager.this.dataTypeEditor != null) {
                    BBacnetScheduleExportManager.this.dataTypeEditor.loadValue((BObject)btyp, null);
                }
            }
            catch (Exception typ) {
                // empty catch block
            }
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)ord);
            }
        }
    }

    class UseNiagaraToggle
    extends MgrController.MgrToggleCommand {
        Controller controller;

        UseNiagaraToggle(Controller c) {
            super((BWidget)c.getManager(), (Lexicon)lex, "scheduleManager.useNiagara");
            this.controller = c;
        }

        public void setSelected(boolean sel) {
            this.controller.setUseDeviceSchedule(!sel);
        }

        public void doSetSelected(boolean sel) {
            super.setSelected(sel);
        }
    }

    class UseDeviceToggle
    extends MgrController.MgrToggleCommand {
        Controller controller;

        UseDeviceToggle(Controller c) {
            super((BWidget)c.getManager(), (Lexicon)lex, "scheduleManager.useDevice");
            this.controller = c;
        }

        public void setSelected(boolean sel) {
            this.controller.setUseDeviceSchedule(sel);
        }

        public void doSetSelected(boolean sel) {
            super.setSelected(sel);
        }
    }

    class Controller
    extends ScheduleExportController {
        private boolean useDeviceSchedule;
        public final UseDeviceToggle useDeviceToggle;
        public final UseNiagaraToggle useNiagaraToggle;
        public final MgrController.MgrCommand changeType;

        public Controller(BBacnetScheduleExportManager manager) {
            super((BScheduleExportManager)manager);
            this.useDeviceSchedule = true;
            this.changeType = new ChangeTypeCommand((BWidget)this.getManager());
            this.useDeviceToggle = new UseDeviceToggle(this);
            this.useNiagaraToggle = new UseNiagaraToggle(this);
            this.changeType.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.edit, this.learnMode, this.discover, this.cancel, this.add, this.match, this.quickMatch, this.export, this.changeType};
        }

        public BWidget makeActionBar() {
            MgrController.IMgrCommand[] cmds = new MgrController.IMgrCommand[]{this.newCommand, this.edit, this.learnMode, this.discover, this.cancel, this.add, this.match, this.quickMatch, this.export};
            MgrController.IMgrCommand[] cmds2 = new MgrController.IMgrCommand[]{this.changeType};
            BEdgePane pane = new BEdgePane();
            pane.setTop(this.makeActionPane(cmds));
            pane.setCenter((BWidget)new BBorderPane(this.makeActionPane(cmds2)));
            return pane;
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
            if (command == this.add) {
                return new MgrController.IMgrCommand[]{this.useDeviceToggle, this.useNiagaraToggle};
            }
            return null;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BOrd jobOrd = BBacnetScheduleExportManager.this.getDeviceExt().submitScheduleDiscoveryJob();
            if (jobOrd != null && !jobOrd.equals((Object)BOrd.DEFAULT)) {
                BBacnetScheduleExportManager.this.getLearn().setJob(jobOrd);
            }
            return null;
        }

        public void updateCommands() {
            super.updateCommands();
            if (this.getTable() == null) {
                return;
            }
            BComponent[] a = this.getTable().getSelectedComponents();
            this.changeType.setEnabled(a.length == 1);
        }

        public MgrEdit makeEdit(String label) {
            if (label != null && (label.equals(addLabel) || label.equals(newLabel))) {
                return new MgrEdit(this.getManager(), label){

                    public CommandArtifact commit() throws Exception {
                        MgrEditRow[] rows = this.getRows();
                        for (int i = 0; i < rows.length; ++i) {
                            BOrd supervisorOrd = (BOrd)rows[i].getCell(BBacnetScheduleExportManager.this.supervisorOrdCol);
                            if (supervisorOrd != null && !supervisorOrd.isNull()) continue;
                            String msg = MessageFormat.format(lex.getText("scheduleManager.export.invalidOrd"), supervisorOrd, rows[i].getDiscovery());
                            BDialog.error((BWidget)this.getManager(), (Object)msg);
                            return null;
                        }
                        CommandArtifact ret = super.commit();
                        for (int i = 0; i < rows.length; ++i) {
                            BBacnetObjectIdentifier objectId = (BBacnetObjectIdentifier)rows[i].getCell(BBacnetScheduleExportManager.this.objectIdCol);
                            BBacnetScheduleExport exp = BBacnetScheduleExportManager.this.getDeviceExt().lookupExport(objectId);
                            if (exp == null || !Controller.this.useDeviceSchedule) continue;
                            exp.readFromDevice();
                        }
                        return ret;
                    }
                };
            }
            return super.makeEdit(label);
        }

        public void setUseDeviceSchedule(boolean selected) {
            this.useDeviceSchedule = selected;
            this.useDeviceToggle.doSetSelected(selected);
            this.useNiagaraToggle.doSetSelected(!selected);
        }

        class ChangeTypeCommand
        extends MgrController.MgrCommand {
            ChangeTypeCommand(BWidget owner) {
                super(owner, (Lexicon)lex, "export.command.changeType");
            }

            public CommandArtifact doInvoke() throws Exception {
                return BBacnetScheduleExportManager.this.doChangeType();
            }
        }
    }

    class Learn
    extends ScheduleLearn {
        public Learn(BBacnetScheduleExportManager manager) {
            super((BAbstractManager)manager);
        }

        public boolean isExisting(Object dis, BComponent db) {
            return ((BBacnetScheduleExport)db).getObjectId().equals((Object)this.disc(dis).getObjectId());
        }

        public boolean isMatchable(Object dis, BComponent db) {
            BBacnetScheduleExport xp = (BBacnetScheduleExport)db;
            if (xp.getSupervisorId().equals("")) {
                return true;
            }
            BAbstractSchedule s = xp.getExportableSchedule();
            if (s != null) {
                if (s instanceof BCalendarSchedule) {
                    return this.disc(dis).getObjectId().getObjectType() == 6;
                }
                return this.disc(dis).getObjectId().getObjectType() == 17;
            }
            return false;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return MgrTypeInfo.makeArray((Type)BBacnetScheduleExport.TYPE);
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            row.setName(SlotPath.escape((String)this.disc(dis).getObjectName()));
            row.setCell(BBacnetScheduleExportManager.this.objectIdCol, (BValue)this.disc(dis).getObjectId());
            row.setCell(BBacnetScheduleExportManager.this.dataTypeCol, (BValue)BString.make((String)this.disc(dis).getDataType()));
        }
    }

    class Model
    extends ScheduleExportModel {
        BBacnetScheduleDeviceExt deviceExt;

        public Model(BBacnetScheduleExportManager manager) {
            super((BScheduleExportManager)manager);
        }

        public void load(BComponent target) {
            this.deviceExt = (BBacnetScheduleDeviceExt)target;
            super.load(target);
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BBacnetScheduleExport.TYPE);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Type(6), BBacnetScheduleExportManager.this.objectIdCol, BBacnetScheduleExportManager.this.supervisorOrdCol, new MgrColumn.Prop(BScheduleExport.state, 4), BBacnetScheduleExportManager.this.dataTypeCol, new MgrColumn.Prop(BScheduleExport.enabled, 3), new MgrColumn.Prop(BBacnetScheduleExport.priorityForWriting, 1), new MgrColumn.PropPath(BDescriptor.executionTime.getDefaultDisplayName(null), new Property[]{BDescriptor.executionTime, BTimeTrigger.triggerMode}, 3), new MgrColumn.Prop(BScheduleExport.lastAttempt, 6), new MgrColumn.Prop(BScheduleExport.lastSuccess, 4), new MgrColumn.Prop(BScheduleExport.lastFailure, 6), new MgrColumn.Prop(BScheduleExport.faultCause, 6), new MgrColumn.Prop(BBacnetScheduleExport.skipWrites, 3), new MgrColumn.Prop(BBacnetScheduleExport.writeEnumAs, 3), new MgrColumn.Prop(BBacnetScheduleExport.outOfService, 3)};
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BBacnetScheduleExport.TYPE};
        }
    }
}

