/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.history;

import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.ui.history.BMultiRecord;
import com.tridium.bacnet.ui.history.MultiColumn;
import com.tridium.history.collection.BRecordTable;
import com.tridium.history.collection.HistoryColumns;
import com.tridium.history.collection.PropertyColumn;
import java.util.ArrayList;
import javax.baja.collection.AbstractRow;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMultiRecordTable
extends BObject
implements BIRandomAccessTable<BMultiRecord> {
    public static final Type TYPE = Sys.loadType(BMultiRecordTable.class);
    private BFacets tableFacets;
    private ColumnList columns;
    private String[] histNames;
    private ArrayList<BMultiRecord> recList;

    public Type getType() {
        return TYPE;
    }

    public BMultiRecordTable(BITable<BBacnetTrendRecord>[] recTables, String[] histNames) {
        this.histNames = histNames;
        this.columns = this.getColumns(recTables);
        this.recList = this.mergeRecTables(recTables);
    }

    private BObject[] getRecsFromTable(BITable<BBacnetTrendRecord> t) {
        ArrayList<Object> alist = new ArrayList<Object>();
        try (TableCursor c = t.cursor();){
            while (c.next()) {
                alist.add(c.get());
            }
            BObject[] bObjectArray = (BObject[])alist.toArray(new BBacnetTrendRecord[alist.size()]);
            return bObjectArray;
        }
    }

    private ArrayList<BMultiRecord> mergeRecTables(BITable<BBacnetTrendRecord>[] recTables) {
        ArrayList<BMultiRecord> al = new ArrayList<BMultiRecord>(128);
        int numTabls = recTables.length;
        int[] ndxs = new int[numTabls];
        BObject[][] recs = new BObject[numTabls][];
        for (int i = 0; i < numTabls; ++i) {
            recs[i] = this.getRecsFromTable(recTables[i]);
            ndxs[i] = 0;
        }
        boolean process = true;
        block1: while (process) {
            int i;
            BAbsTime nxtTm = BAbsTime.END_OF_TIME;
            for (int i2 = 0; i2 < numTabls; ++i2) {
                BAbsTime ts;
                BBacnetTrendRecord rec = this.getNextRecord(i2, ndxs, recs);
                if (rec == null || !(ts = rec.getTimestamp()).isBefore(nxtTm)) continue;
                nxtTm = ts;
            }
            BBacnetTrendRecord[] btrs = new BBacnetTrendRecord[numTabls];
            for (i = 0; i < numTabls; ++i) {
                BBacnetTrendRecord rec = this.getNextRecord(i, ndxs, recs);
                if (rec != null && nxtTm.equals((Object)rec.getTimestamp())) {
                    btrs[i] = rec;
                    int n = i;
                    ndxs[n] = ndxs[n] + 1;
                    continue;
                }
                btrs[i] = null;
            }
            al.add(new BMultiRecord(btrs));
            process = false;
            for (i = 0; i < numTabls; ++i) {
                if (this.getNextRecord(i, ndxs, recs) == null) continue;
                process = true;
                continue block1;
            }
        }
        return al;
    }

    private BBacnetTrendRecord getNextRecord(int tbl, int[] ndxs, BObject[][] recs) {
        int nxtNdx = ndxs[tbl];
        if (nxtNdx >= recs[tbl].length) {
            return null;
        }
        return (BBacnetTrendRecord)recs[tbl][nxtNdx];
    }

    private ColumnList getColumns(BITable<?>[] results) {
        int i;
        HistoryColumns columns = new HistoryColumns(10);
        BRecordTable rec = (BRecordTable)results[0];
        Column[] cols = rec.getColumns().list();
        for (i = 0; i < 5; ++i) {
            if (!(cols[i] instanceof PropertyColumn)) continue;
            PropertyColumn pc = (PropertyColumn)cols[i];
            columns.addColumn((Column)new MultiColumn(pc.getProperty(), pc.getDisplayName(null), pc.getFacets(), -1));
        }
        for (i = 0; i < results.length; ++i) {
            rec = (BRecordTable)results[i];
            cols = rec.getColumns().list();
            for (int n = 5; n < cols.length; ++n) {
                if (!(cols[n] instanceof PropertyColumn)) continue;
                PropertyColumn pc = (PropertyColumn)cols[n];
                String nam = this.histNames[i];
                if (cols.length > 6) {
                    nam = nam.concat(".").concat(pc.getDisplayName(null));
                }
                columns.addColumn((Column)new MultiColumn(pc.getProperty(), nam, pc.getFacets(), i));
            }
        }
        return columns;
    }

    public TableCursor<BMultiRecord> cursor() {
        return new RecordCursor(this.recList);
    }

    public ColumnList getColumns() {
        return this.columns;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public Row<BMultiRecord> get(int row) {
        return new RecordCursorRow(this.recList.get(row));
    }

    public int size() {
        return this.recList.size();
    }

    class RecordCursorRow
    extends AbstractRow<BMultiRecord> {
        private BMultiRecord multiRecord;

        RecordCursorRow(BMultiRecord mrec) {
            super((BITable)BMultiRecordTable.this, (BIObject)mrec);
            this.multiRecord = mrec;
        }

        public BIObject cell(Column column) {
            return ((MultiColumn)column).get(this.multiRecord);
        }

        public int getCellFlags(Column column) {
            return ((MultiColumn)column).getFlags(this.multiRecord);
        }

        public BFacets getCellFacets(Column column) {
            return ((MultiColumn)column).getFacets(this.multiRecord);
        }

        public Row<BMultiRecord> safeCopy() {
            return new RecordCursorRow((BMultiRecord)this.rowObject());
        }
    }

    private class RecordCursor
    implements TableCursor<BMultiRecord> {
        ArrayList<BMultiRecord> myList;
        int index = -1;

        public RecordCursor(ArrayList<BMultiRecord> recList) {
            this.myList = recList;
        }

        public BITable<BMultiRecord> getTable() {
            return BMultiRecordTable.this;
        }

        public Context getContext() {
            return null;
        }

        public boolean next() {
            int count = this.myList.size();
            if (this.index == count) {
                return false;
            }
            ++this.index;
            return this.index != count;
        }

        public BMultiRecord get() {
            return this.myList.get(this.index);
        }

        public Row<BMultiRecord> row() {
            return new RecordCursorRow(this.get());
        }

        public BIObject cell(Column column) {
            return this.row().cell(column);
        }

        public void close() {
        }
    }
}

