/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.gx.BBrush;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.units.BUnit;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BBacnetUnsignedFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BBacnetUnsignedFE.class);
    boolean useEnum = false;
    private BGridPane pane = new BGridPane(2);
    private BTextField field = new BTextField("", 10);
    private BLabel label = new BLabel("");
    private String r = "";
    private long min = 0L;
    private long max = 0xFFFFFFFFL;
    private int radix = 10;
    private BTextDropDown combo = new BTextDropDown("", 15, true);
    private BEnumRange range = BEnumRange.make((String[])new String[0]);
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;

    public Type getType() {
        return TYPE;
    }

    public BBacnetUnsignedFE() {
        this.pane.add("field", (BValue)this.field);
        this.pane.add("units", (BValue)this.label);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.combo, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.combo, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
        this.combo.getEditor().setEditable(!readonly);
        this.combo.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.min = 0L;
        this.max = 0xFFFFFFFFL;
        this.radix = 10;
        this.r = "";
        String meta = "";
        if (cx != null) {
            BEnumRange ranj = (BEnumRange)cx.getFacet("range");
            if (ranj != null) {
                this.useEnum = true;
                this.range = ranj;
            } else {
                BInteger radixFacet;
                BNumber maxFacet;
                BNumber minFacet;
                this.useEnum = false;
                BUnit u = (BUnit)cx.getFacet("units");
                if (u != null && !u.isNull()) {
                    meta = u.getSymbol();
                }
                if ((minFacet = (BNumber)cx.getFacet("min")) != null) {
                    this.min = minFacet.getInt();
                }
                if ((maxFacet = (BNumber)cx.getFacet("max")) != null) {
                    this.max = maxFacet.getInt();
                }
                if ((radixFacet = (BInteger)cx.getFacet("radix")) != null) {
                    this.radix = radixFacet.getInt();
                }
            }
        }
        if (this.useEnum) {
            this.loadValueEnum((BBacnetUnsigned)value);
        } else {
            if (this.radix != 10) {
                if (meta.length() > 0) {
                    meta = meta + ' ';
                }
                meta = meta + "Base " + this.radix;
            }
            if (this.min != 0L || this.max != 0xFFFFFFFFL) {
                this.r = "[" + Long.toString(this.min, this.radix) + " - " + Long.toString(this.max, this.radix) + "]";
                if (meta.length() > 0) {
                    meta = meta + ' ';
                }
                meta = meta + this.r;
            }
            long lval = ((BBacnetUnsigned)value).getUnsigned();
            this.field.setText(Long.toString(lval, this.radix));
            this.label.setText(meta);
            this.setContent((BWidget)this.pane);
        }
    }

    private void loadValueEnum(BBacnetUnsigned u) {
        int maxLen = 5;
        this.combo.getList().removeAllItems();
        int[] ordinals = this.range.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ordinal = ordinals[i];
            String displayTag = this.range.getDisplayTag(ordinal, null);
            this.combo.getList().addItem((Object)displayTag);
            maxLen = Math.max(maxLen, displayTag.length());
        }
        this.combo.getEditor().setVisibleColumns(maxLen);
        this.combo.setText(this.range.getDisplayTag(u.getInt(), null));
        this.doSetReadonly(this.isReadonly());
        this.setContent((BWidget)this.combo);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.useEnum) {
            long lval = this.saveEnumToLong();
            return BBacnetUnsigned.make((long)lval);
        }
        long lval = this.saveUnsignedToLong();
        BBacnetUnsigned io = BBacnetUnsigned.make((long)lval);
        if (lval < this.min) {
            throw new CannotSaveException(Long.toString(lval, this.radix) + " < " + Long.toString(this.min, this.radix) + " " + this.r);
        }
        if (lval > this.max) {
            throw new CannotSaveException(Long.toString(lval, this.radix) + " > " + Long.toString(this.max, this.radix) + " " + this.r);
        }
        return io;
    }

    private long saveUnsignedToLong() {
        String text = this.field.getText();
        if (text.startsWith("0x")) {
            return Long.parseLong(text.substring(2), 16);
        }
        return Long.parseLong(text, this.radix);
    }

    private long saveEnumToLong() {
        String tag = this.combo.getText();
        int[] ordinals = this.range.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ordinal = ordinals[i];
            String displayTag = this.range.getDisplayTag(ordinal, null);
            if (!tag.equals(displayTag)) continue;
            return ordinal;
        }
        if (tag.startsWith("0x")) {
            return Long.parseLong(tag.substring(2), 16);
        }
        return Long.parseLong(tag);
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 306: {
                this.fg = (BBrush)a;
                this.bg = (BBrush)b;
                this.repaint();
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            if (BBacnetUnsignedFE.this.bg.isNull()) {
                return super.getBackground();
            }
            return BBacnetUnsignedFE.this.bg;
        }

        public BBrush getForeground(Segment seg) {
            if (BBacnetUnsignedFE.this.fg.isNull()) {
                return super.getForeground(seg);
            }
            return BBacnetUnsignedFE.this.fg;
        }
    }
}

