/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.export;

import com.tridium.bacnet.ui.export.BWritableSlotsEditor;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BacnetWritableDescriptor;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

class BacnetWritable
extends MgrColumn {
    static Lexicon lex = UiLexicon.makeUiLexicon(BacnetWritable.class);
    static String colHdr = lex.getText("exportManager.writable");
    static String notWritable = lex.getText("server.notWritable");

    public BacnetWritable() {
        super(colHdr, 1);
    }

    public Object get(Object row) {
        if (row instanceof BBacnetPointDescriptor) {
            return ((BBacnetPointDescriptor)row).getBacnetWritable();
        }
        return "";
    }

    public BValue load(MgrEditRow row) {
        BComponent tgt = row.getTarget();
        if (tgt instanceof BBacnetPointDescriptor) {
            BBacnetPointDescriptor ptDesc = (BBacnetPointDescriptor)tgt;
            if (tgt instanceof BacnetWritableDescriptor) {
                return BString.make((String)ptDesc.getBacnetWritable());
            }
        }
        return BString.DEFAULT;
    }

    public void save(MgrEditRow row, BValue value, Context cx) {
        BComponent target = row.getTarget();
        if (target instanceof BBacnetPointDescriptor) {
            ((BBacnetPointDescriptor)target).makeWritable(value);
        }
    }

    public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
        BValue val = rows[0].getCell(colIndex);
        for (int i = 1; i < rows.length; ++i) {
            if (rows[i].getCell(colIndex).getClass() == val.getClass()) continue;
            return null;
        }
        BWbFieldEditor editor = this.makeFE(val);
        if (editor == null) {
            return null;
        }
        if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
            editor = (BWbFieldEditor)currentEditor;
        }
        editor.loadValue((BObject)val, null);
        return editor;
    }

    public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
        BValue val = (BValue)editor.saveValue();
        for (int i = 0; i < rows.length; ++i) {
            rows[i].setCell(colIndex, val);
        }
    }

    private BWbFieldEditor makeFE(BValue val) {
        if (val.equals((Object)BString.DEFAULT)) {
            return null;
        }
        if (val instanceof BString) {
            return new BWritableSlotsEditor();
        }
        return null;
    }
}

