/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.export;

import com.tridium.bacnet.datatypes.BSvoSubordinate;
import com.tridium.bacnet.stack.server.BBacnetExportFolder;
import com.tridium.bacnet.ui.fe.BBacnetObjectIdentifierFE;
import com.tridium.platform.ui.util.BIBeamPane;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BSvoSubordinateManager
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BSvoSubordinateManager.class);
    static Lexicon lex = UiLexicon.makeUiLexicon(BSvoSubordinateManager.class);
    static String LOCAL = lex.getText("svoSubMgr.cell.local");
    static String AUTO = lex.getText("svoSubMgr.cell.automatic");
    static String DEV_INST_LABEL = lex.getText("svoSubMgr.col.deviceInst");
    static String OBJ_ID_LABEL = lex.getText("svoSubMgr.col.objectId");
    static String ANNOTATION_LABEL = lex.getText("svoSubMgr.col.annotation");
    private BTable manConfigTable;
    private DefaultTableModel manConfigModel = new DefaultTableModel(colNames);
    private BTable autoTable;
    private DefaultTableModel autoModel;
    private int localInst;
    private Command newCmd;
    private Command editCmd;
    private Command deleteCmd;
    private Command editAutoCmd;
    private static String[] colNames = new String[]{DEV_INST_LABEL, OBJ_ID_LABEL, ANNOTATION_LABEL};

    public Type getType() {
        return TYPE;
    }

    public BSvoSubordinateManager() {
        this.manConfigTable = new BTable((TableModel)this.manConfigModel);
        this.manConfigTable.setSelection((TableSelection)new Selection());
        this.autoModel = new DefaultTableModel(colNames);
        this.autoTable = new BTable((TableModel)this.autoModel);
        this.autoTable.setSelection((TableSelection)new Selection());
        BIBeamPane content = new BIBeamPane();
        content.setLeft((BWidget)new BEdgePane((BWidget)this.makeTitle(lex.getText("svoSubMgr.table.manual")), (BWidget)this.makeManButtonPane(), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.manConfigTable), 5.0, 5.0, 5.0, 5.0)));
        content.setRight((BWidget)new BEdgePane((BWidget)this.makeTitle(lex.getText("svoSubMgr.table.automatic")), (BWidget)this.makeAutoButtonPane(), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.autoTable), 5.0, 5.0, 5.0, 5.0)));
        this.setContent((BWidget)content);
    }

    public BMenu[] getViewMenus() {
        return null;
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        return bar;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BBacnetExportFolder svo = (BBacnetExportFolder)value;
        BIBacnetExportObject[] exports = (BIBacnetExportObject[])svo.getChildren(BIBacnetExportObject.class);
        BComponent[] comps = new BComponent[exports.length + 2];
        for (int i = 0; i < exports.length; ++i) {
            comps[i] = (BComponent)exports[i];
        }
        comps[exports.length] = svo;
        comps[exports.length + 1] = svo.getSubordinates();
        this.registerForComponentEvents(comps, 0);
        this.updateTable((BBacnetExportFolder)value);
    }

    public void handleComponentEvent(BComponentEvent event) {
        this.updateTable(this.getSvo());
    }

    private BGridPane makeAutoButtonPane() {
        BInsets insets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
        BGridPane buttonPane = new BGridPane(1);
        this.editAutoCmd = new EditAuto((BWidget)this);
        BAbstractButton bEditAuto = BAbstractButton.make((Command)this.editAutoCmd);
        bEditAuto.setPadding(insets);
        buttonPane.add("bEditAuto", (BValue)bEditAuto);
        return buttonPane;
    }

    private BGridPane makeManButtonPane() {
        BInsets insets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
        BGridPane buttonPane = new BGridPane();
        this.newCmd = new New((BWidget)this);
        this.editCmd = new Edit((BWidget)this);
        this.deleteCmd = new Delete((BWidget)this);
        BAbstractButton bNew = BAbstractButton.make((Command)this.newCmd);
        BAbstractButton bEdit = BAbstractButton.make((Command)this.editCmd);
        BAbstractButton bDelete = BAbstractButton.make((Command)this.deleteCmd);
        bNew.setPadding(insets);
        bEdit.setPadding(insets);
        bDelete.setPadding(insets);
        buttonPane.add("bNew", (BValue)bNew);
        buttonPane.add("bEdit", (BValue)bEdit);
        buttonPane.add("bDelete", (BValue)bDelete);
        buttonPane.setColumnCount(3);
        return buttonPane;
    }

    private BLabel makeTitle(String str) {
        BLabel title = new BLabel(str);
        title.setFont(BFont.make((String)"bold 12pt arial"));
        title.setPreferredSize(300.0, 20.0);
        title.setHalign(BHalign.center);
        return title;
    }

    private void updateCommands() {
        int sel = this.manConfigTable.getSelection().getRowCount();
        this.deleteCmd.setEnabled(sel > 0);
        if (sel == 1) {
            String dev = (String)this.manConfigModel.getValueAt(this.manConfigTable.getSelection().getRow(), 0);
            this.editCmd.setEnabled(!dev.equals(AUTO));
        } else {
            this.editCmd.setEnabled(false);
        }
        this.editAutoCmd.setEnabled(this.autoTable.getSelection().getRowCount() == 1);
    }

    private BBacnetExportFolder getSvo() {
        return (BBacnetExportFolder)this.getCurrentValue();
    }

    private void updateTable(BBacnetExportFolder svo) {
        this.autoModel.removeAllRows();
        BIBacnetExportObject[] localSubs = svo.getLocalSubordinates();
        for (int i = 0; i < localSubs.length; ++i) {
            ((BComplex)localSubs[i]).loadSlots();
            this.autoModel.addRow(new Object[]{AUTO, localSubs[i].getObjectId(), ((BComplex)localSubs[i]).get("description")});
        }
        this.localInst = ((BLocalBacnetDevice)this.getSvo().getExports().getParent()).getObjectId().getInstanceNumber();
        this.manConfigModel.removeAllRows();
        BBacnetArray subs = svo.getSubordinates();
        int len = subs.getSize();
        for (int i = 1; i <= len; ++i) {
            BSvoSubordinate sub = (BSvoSubordinate)subs.getElement(i);
            if (sub == null) continue;
            BBacnetDeviceObjectReference ref = sub.getReference();
            BBacnetObjectIdentifier devId = ref.getDeviceId();
            int devInst = devId.getInstanceNumber();
            String devStr = LOCAL;
            if (devInst != this.localInst) {
                devStr = "" + devInst;
            }
            this.manConfigModel.addRow(new Object[]{devStr, ref.getObjectId(), sub.getAnnotation()});
        }
        this.manConfigTable.setModel((TableModel)this.manConfigModel);
        this.manConfigTable.relayout();
        this.updateCommands();
    }

    private BSvoSubordinate prompt(String title, String devInst, BBacnetObjectIdentifier objId, String annotation, boolean auto) throws Exception {
        int ok;
        BTextDropDown dev = new BTextDropDown();
        dev.getList().addItem((Object)LOCAL);
        dev.getList().setSelectedItem((Object)LOCAL);
        dev.setText(devInst);
        BBacnetObjectIdentifierFE obj = new BBacnetObjectIdentifierFE();
        obj.loadValue((BObject)(objId != null ? objId : BBacnetObjectIdentifier.DEFAULT), (Context)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)));
        BTextField ann = new BTextField("" + annotation, 25);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)new BLabel(DEV_INST_LABEL));
        grid.add(null, (BValue)dev);
        grid.add(null, (BValue)new BLabel(OBJ_ID_LABEL));
        grid.add(null, (BValue)obj);
        grid.add(null, (BValue)new BLabel(ANNOTATION_LABEL));
        grid.add(null, (BValue)ann);
        if (auto) {
            obj.setReadonly(true);
            dev.setEnabled(false);
        }
        if ((ok = BDialog.open((BWidget)this, (String)title, (Object)grid, (int)3)) == 2) {
            return null;
        }
        objId = (BBacnetObjectIdentifier)obj.saveValue();
        String anno = ann.getText();
        String txt = dev.getText();
        if (txt.equals(AUTO)) {
            return new BSvoSubordinate(new BBacnetDeviceObjectReference(objId), anno);
        }
        BBacnetObjectIdentifier devId = txt.equals(LOCAL) ? BBacnetObjectIdentifier.make((int)8, (int)this.localInst) : BBacnetObjectIdentifier.make((int)8, (int)Integer.parseInt(txt));
        return new BSvoSubordinate(new BBacnetDeviceObjectReference(devId, objId), anno);
    }

    public CommandArtifact doNew() throws Exception {
        BSvoSubordinate sub = this.prompt(lex.getText("svoSubMgr.new.label"), LOCAL, null, "", false);
        if (sub != null) {
            this.getSvo().addSubordinate(sub);
        }
        return null;
    }

    public CommandArtifact doEdit() throws Exception {
        int[] rows = this.manConfigTable.getSelection().getRows();
        if (rows.length != 1) {
            return null;
        }
        int row = rows[0];
        String devStr = (String)this.manConfigModel.getValueAt(row, 0);
        if (devStr.equals(AUTO)) {
            return null;
        }
        BBacnetObjectIdentifier objId = (BBacnetObjectIdentifier)this.manConfigModel.getValueAt(row, 1);
        String anno = (String)this.manConfigModel.getValueAt(row, 2);
        BSvoSubordinate sub = this.prompt(lex.getText("svoSubMgr.edit.label"), devStr, objId, anno, false);
        if (sub == null) {
            return null;
        }
        this.getSvo().modifySubordinate(row + 1, sub);
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        int[] rows = this.manConfigTable.getSelection().getRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            String devStr = (String)this.manConfigModel.getValueAt(row, 0);
            if (devStr.equals(AUTO)) continue;
            this.getSvo().removeSubordinate(row);
        }
        return null;
    }

    public CommandArtifact doEditAuto() throws Exception {
        int[] rows = this.autoTable.getSelection().getRows();
        if (rows.length != 1) {
            return null;
        }
        int row = rows[0];
        String devStr = (String)this.autoModel.getValueAt(row, 0);
        BBacnetObjectIdentifier objId = (BBacnetObjectIdentifier)this.autoModel.getValueAt(row, 1);
        String anno = ((BString)this.autoModel.getValueAt(row, 2)).getString();
        BSvoSubordinate sub = this.prompt(lex.getText("svoSubMgr.editAuto.label"), devStr, objId, anno, true);
        if (sub == null) {
            return null;
        }
        BIBacnetExportObject[] localSubs = this.getSvo().getLocalSubordinates();
        BComplex localSub = (BComplex)localSubs[row];
        Property p = localSub.getProperty("description");
        localSub.set(p, (BValue)BString.make((String)sub.getAnnotation()));
        return null;
    }

    class EditAuto
    extends Command {
        EditAuto(BWidget owner) {
            super(owner, lex, "svoSubMgr.editAuto");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BSvoSubordinateManager.this.doEditAuto();
        }
    }

    class Delete
    extends Command {
        Delete(BWidget owner) {
            super(owner, lex, "svoSubMgr.delete");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BSvoSubordinateManager.this.doDelete();
        }
    }

    class Edit
    extends Command {
        Edit(BWidget owner) {
            super(owner, lex, "svoSubMgr.edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BSvoSubordinateManager.this.doEdit();
        }
    }

    class New
    extends Command {
        New(BWidget owner) {
            super(owner, lex, "svoSubMgr.new");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BSvoSubordinateManager.this.doNew();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BSvoSubordinateManager.this.updateCommands();
        }
    }
}

