/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.export;

import com.tridium.bacnet.datatypes.BNextInstArgs;
import com.tridium.bacnet.stack.server.BIBacnetExportFolder;
import com.tridium.bacnet.ui.export.BBacnetExportManager;
import com.tridium.bacnet.ui.export.LogExportController;
import com.tridium.fox.sys.BFoxSession;
import java.util.logging.Logger;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BBacnetNiagaraHistoryDescriptor;
import javax.baja.bacnet.export.BBacnetTrendLogDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.gx.BImage;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderState;

public class BBacnetNiagaraLogExportManager
extends BBacnetExportManager {
    public static final Type TYPE = Sys.loadType(BBacnetNiagaraLogExportManager.class);
    private static final BImage historyIcon = BImage.make((BIcon)BIcon.std((String)"history.png"));
    static String lexLocalHistories = lex.getText("logExportManager.local");
    static String lexLogType = lex.getText("logExportManager.logType");
    private static final Logger logger = Logger.getLogger("bacnet.ui");
    MgrColumn mcolLogType = new BBacnetExportManager.TargetOutput(lexLogType);
    MgrColumn mcolLogOrd = new BBacnetExportManager.ExportOrd(7);
    MgrColumn hdcolId = new HistoryIdColumn(lex.getText("logExportManager.historyId"));
    MgrColumn[] hdcols = new MgrColumn[]{this.hdcolId};

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
    }

    @Override
    protected MgrModel makeModel() {
        return new Model(this);
    }

    @Override
    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    @Override
    protected MgrController makeController() {
        return new LogExportController(this);
    }

    @Override
    protected MgrState makeState() {
        return new State();
    }

    public static class HistoryIdColumn
    extends MgrColumn {
        public HistoryIdColumn(String displayName) {
            super(displayName, 1);
        }

        public Object get(Object row) {
            return ((BIHistory)row).getId();
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            logger.info("HistoryIdColumn.toEditor: " + rows.length);
            if (currentEditor == null) {
                currentEditor = BWbFieldEditor.makeFor((BObject)BHistoryId.DEFAULT);
            }
            if (rows.length > 1) {
                currentEditor.loadValue((BObject)BHistoryId.NULL);
                currentEditor.setReadonly(true);
            } else {
                currentEditor.loadValue((BObject)this.get(rows[0].getCell(colIndex)));
            }
            return currentEditor;
        }
    }

    static class State
    extends FolderState {
        Object[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BBacnetNiagaraLogExportManager mgr = (BBacnetNiagaraLogExportManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            this.lastLearn = lrn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BBacnetNiagaraLogExportManager mgr = (BBacnetNiagaraLogExportManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            if (this.lastLearn != null) {
                lrn.updateTable(this.lastLearn);
            }
        }
    }

    class Learn
    extends MgrLearn {
        Object[] lastLearn;

        public Learn(BBacnetNiagaraLogExportManager manager) {
            super((BAbstractManager)manager);
        }

        public String makeTableTitle() {
            return lexLocalHistories;
        }

        public BHistorySpace getHistorySpace() {
            BFoxSession session = (BFoxSession)BBacnetNiagaraLogExportManager.this.getExports().getSession();
            BOrd spaceOrd = BOrd.make((String)"history:");
            try {
                return (BHistorySpace)spaceOrd.resolve((BObject)session).get();
            }
            catch (UnresolvedException e) {
                return null;
            }
        }

        protected MgrColumn[] makeColumns() {
            return BBacnetNiagaraLogExportManager.this.hdcols;
        }

        public BImage getIcon(Object dis) {
            return dis instanceof BIHistory ? historyIcon : null;
        }

        public MgrTypeInfo[] toTypes(Object dis) throws Exception {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBacnetNiagaraHistoryDescriptor.TYPE)};
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            this.toRow(dis, row, row.getEdit());
        }

        public void toRow(Object dis, MgrEditRow row, MgrEdit edit) throws Exception {
            BIHistory history = (BIHistory)dis;
            String name = history.getId().toString();
            BComponent c = row.getTarget();
            BIBacnetExportObject obj = (BIBacnetExportObject)c;
            BBacnetObjectIdentifier objId = obj.getObjectId();
            int objectType = objId.getObjectType();
            int instNum = -1;
            if (edit == null) {
                BNextInstArgs args = new BNextInstArgs(objectType);
                instNum = BBacnetNiagaraLogExportManager.this.exports.getNextInst(args).getInt();
            } else {
                MgrColumn[] cols = edit.getColumns();
                int objTypeColNdx = -1;
                int instNumColNdx = -1;
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i].getDisplayName().equals(BBacnetExportManager.lexInstanceNumber)) {
                        instNumColNdx = i;
                        continue;
                    }
                    if (!cols[i].getDisplayName().equals(BBacnetExportManager.lexObjectType)) continue;
                    objTypeColNdx = i;
                }
                int[] siblingCandidates = new int[edit.getRowCount()];
                int siblingCount = 0;
                for (int i = 0; i < edit.getRowCount() - 1; ++i) {
                    String rowObjTypeStr = TextUtil.fromFriendly((String)((String)edit.getValueAt(i, objTypeColNdx)));
                    int rowObjType = BBacnetObjectType.ordinal((String)rowObjTypeStr);
                    int rowInstNum = Integer.parseInt((String)edit.getValueAt(i, instNumColNdx));
                    if (objectType != rowObjType || rowInstNum < 0) continue;
                    siblingCandidates[siblingCount++] = rowInstNum;
                }
                int[] siblings = new int[siblingCount];
                System.arraycopy(siblingCandidates, 0, siblings, 0, siblingCount);
                BNextInstArgs args = new BNextInstArgs(objectType, siblings);
                instNum = BBacnetNiagaraLogExportManager.this.exports.getNextInst(args).getInt();
            }
            row.setCell(BBacnetNiagaraLogExportManager.this.mcolInstNum, (BValue)BInteger.make((int)instNum));
            objId = BBacnetObjectIdentifier.make((int)objectType, (int)instNum);
            row.setName(objId.toString(BacnetConst.nameContext));
            row.setCell(BBacnetNiagaraLogExportManager.this.mcolLogOrd, (BValue)BOrd.make((String)("history:" + name)));
            row.setCell(BBacnetNiagaraLogExportManager.this.mcolObjName, (BValue)BString.make((String)SlotPath.unescape((String)name)));
        }

        public boolean isExisting(Object discovery, BComponent component) {
            if (!component.getType().is(BIBacnetExportObject.TYPE)) {
                return false;
            }
            BIHistory history = (BIHistory)discovery;
            BOrd h = null;
            if (component instanceof BBacnetTrendLogDescriptor) {
                h = ((BBacnetTrendLogDescriptor)component).getHistoryOrd().relativizeToSession();
            } else {
                h = ((BBacnetNiagaraHistoryDescriptor)component).getHistoryOrd();
                if (h.isNull()) {
                    return false;
                }
                h = h.relativizeToSession();
            }
            BOrd o = BOrd.make((String)("history:" + history.getId().toString())).relativizeToSession();
            boolean ret = h.equals((Object)o);
            return ret;
        }

        void updateTable(Object[] table) {
            this.lastLearn = table;
            this.updateRoots(table);
        }
    }

    class Model
    extends BBacnetExportManager.ExportModel {
        public Model(BBacnetNiagaraLogExportManager manager) {
            super(manager);
        }

        @Override
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{BBacnetNiagaraLogExportManager.this.mcolName, BBacnetNiagaraLogExportManager.this.mcolTargetName, BBacnetNiagaraLogExportManager.this.mcolObjName, BBacnetNiagaraLogExportManager.this.mcolType, BBacnetNiagaraLogExportManager.this.mcolObjType, BBacnetNiagaraLogExportManager.this.mcolInstNum, BBacnetNiagaraLogExportManager.this.mcolLogType, BBacnetNiagaraLogExportManager.this.mcolLogOrd, BBacnetNiagaraLogExportManager.this.mcolExportStatus, BBacnetNiagaraLogExportManager.this.mcolFaultCause, BBacnetNiagaraLogExportManager.this.mcolDescr};
        }

        @Override
        public Type[] getIncludeTypes() {
            return new Type[]{BBacnetNiagaraHistoryDescriptor.TYPE, BBacnetTrendLogDescriptor.TYPE, BIBacnetExportFolder.TYPE};
        }

        @Override
        public boolean accept(BComponent c) {
            Type t = c.getType();
            if (t.is(BIBacnetExportObject.TYPE)) {
                if (t.is(BBacnetTrendLogDescriptor.TYPE)) {
                    return true;
                }
                return t.is(BBacnetNiagaraHistoryDescriptor.TYPE);
            }
            return true;
        }

        @Override
        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BBacnetNiagaraHistoryDescriptor.TYPE);
        }

        @Override
        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BBacnetNiagaraHistoryDescriptor obj = (BBacnetNiagaraHistoryDescriptor)type.newInstance();
            obj.setObjectId(BBacnetObjectIdentifier.make((int)20, (int)BBacnetNiagaraLogExportManager.this.exports.getNextInstance(20)));
            return obj;
        }
    }
}

