/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.export;

import com.tridium.bacnet.stack.server.BIBacnetExportFolder;
import com.tridium.bacnet.ui.export.BBacnetExportManager;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BBacnetFileDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderState;

public class BBacnetFileExportManager
extends BBacnetExportManager {
    public static final Type TYPE = Sys.loadType(BBacnetFileExportManager.class);
    private static final BImage folderIcon = BImage.make((BIcon)BIcon.std((String)"folder.png"));
    private static final BImage fileIcon = BImage.make((BIcon)BIcon.std((String)"file.png"));
    static String lexLocalFiles = lex.getText("fileExportManager.local");
    MgrColumn mcolFileExportOrd = new FileExportOrd();

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
    }

    @Override
    protected MgrModel makeModel() {
        return new Model(this);
    }

    @Override
    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    @Override
    protected MgrController makeController() {
        return new Controller(this);
    }

    @Override
    protected MgrState makeState() {
        return new State();
    }

    public static class LastModified
    extends MgrColumn {
        public LastModified(String displayName) {
            super(displayName, 1);
        }

        public Object get(Object row) {
            return ((BIFile)row).getLastModified();
        }
    }

    public static class FileSize
    extends MgrColumn {
        public FileSize(String displayName) {
            super(displayName, 1);
        }

        public Object get(Object row) {
            return new Long(((BIFile)row).getSize());
        }
    }

    public static class FileType
    extends MgrColumn {
        public FileType(String displayName) {
            super(displayName, 1);
        }

        public Object get(Object row) {
            return ((BIFile)row).getMimeType();
        }
    }

    public static class FileName
    extends MgrColumn {
        public FileName(String displayName) {
            super(displayName, 1);
        }

        public Object get(Object row) {
            return ((BIFile)row).getFileName();
        }
    }

    public static class FileExportOrd
    extends BBacnetExportManager.ExportOrd {
        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            if (rows == null || rows.length != 1) {
                return null;
            }
            BOrd ord = (BOrd)rows[0].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)ord);
            }
            BFacets facets = BFacets.make((String)"targetType", (String)"baja:IFile");
            editor.loadValue((BObject)ord, (Context)facets);
            return editor;
        }
    }

    class Controller
    extends FolderController {
        public Controller(BBacnetFileExportManager manager) {
            super((BFolderManager)manager);
            this.cancel.setFlags(0);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            Learn learn = (Learn)this.getManager().getLearn();
            BFileSpace space = (BFileSpace)BOrd.make((String)"file:").get((BObject)BBacnetFileExportManager.this.getExports());
            BDirectory root = space.makeDir(new FilePath("^"));
            learn.updateRoots(root.listFiles());
            return null;
        }
    }

    static class State
    extends FolderState {
        Object[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BBacnetFileExportManager mgr = (BBacnetFileExportManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            this.lastLearn = lrn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BBacnetFileExportManager mgr = (BBacnetFileExportManager)m;
            Learn lrn = (Learn)mgr.getLearn();
            if (this.lastLearn != null) {
                lrn.updateTable(this.lastLearn);
            }
        }
    }

    class Learn
    extends MgrLearn {
        Object[] lastLearn;

        public Learn(BBacnetFileExportManager manager) {
            super((BAbstractManager)manager);
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public boolean isGroup(Object discovery) {
            return discovery instanceof BIDirectory;
        }

        public boolean hasChildren(Object discovery) {
            if (discovery instanceof BIDirectory) {
                BIDirectory dir = (BIDirectory)discovery;
                BIFile[] files = dir.listFiles();
                return files != null && files.length > 0;
            }
            return false;
        }

        public Object[] getChildren(Object discovery) {
            return ((BIDirectory)discovery).listFiles();
        }

        public BImage getIcon(Object discovery) {
            if (discovery instanceof BIDirectory) {
                return folderIcon;
            }
            if (discovery instanceof BIFile) {
                return fileIcon;
            }
            return null;
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new FileName(BBacnetExportManager.lex.getText("fileExportManager.name")), new FileType(BBacnetExportManager.lex.getText("fileExportManager.type")), new FileSize(BBacnetExportManager.lex.getText("fileExportManager.size")), new LastModified(BBacnetExportManager.lex.getText("fileExportManager.lastModified"))};
        }

        public String makeTableTitle() {
            return lexLocalFiles;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return MgrTypeInfo.makeArray((Type)BBacnetFileDescriptor.TYPE);
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BIFile file = (BIFile)dis;
            BComponent c = row.getTarget();
            BIBacnetExportObject obj = (BIBacnetExportObject)c;
            BBacnetObjectIdentifier objId = obj.getObjectId();
            int instNum = BBacnetFileExportManager.this.exports.getNextInstance(objId.getObjectType());
            row.setCell(BBacnetFileExportManager.this.mcolObjType, (BValue)BDynamicEnum.make((int)objId.getObjectType(), (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)));
            row.setCell(BBacnetFileExportManager.this.mcolInstNum, (BValue)BInteger.make((int)instNum));
            objId = BBacnetObjectIdentifier.make((int)objId.getObjectType(), (int)instNum);
            row.setDefaultName(objId.toString(BacnetConst.nameContext));
            row.setCell(BBacnetFileExportManager.this.mcolFileExportOrd, (BValue)BOrd.make((OrdQuery)file.getFilePath()));
            row.setCell(BBacnetFileExportManager.this.mcolObjName, (BValue)BString.make((String)file.getFileName()));
        }

        public boolean isExisting(Object discovery, BComponent component) {
            if (!component.getType().is(BIBacnetExportObject.TYPE)) {
                return false;
            }
            BIFile file = (BIFile)discovery;
            BBacnetFileDescriptor obj = (BBacnetFileDescriptor)component;
            BOrd f = BOrd.make((OrdQuery)file.getFilePath()).relativizeToSession();
            BOrd objOrd = obj.getObjectOrd().relativizeToSession();
            boolean ret = objOrd.equals((Object)f);
            return ret;
        }

        void updateTable(Object[] table) {
            this.lastLearn = table;
            this.updateRoots(table);
        }
    }

    class Model
    extends BBacnetExportManager.ExportModel {
        public Model(BBacnetFileExportManager manager) {
            super(manager);
        }

        @Override
        public Type[] getIncludeTypes() {
            return new Type[]{BBacnetFileDescriptor.TYPE, BIBacnetExportFolder.TYPE};
        }

        @Override
        public boolean accept(BComponent c) {
            Type t = c.getType();
            if (t.is(BIBacnetExportObject.TYPE)) {
                return t.is(BBacnetFileDescriptor.TYPE);
            }
            return true;
        }

        @Override
        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BBacnetFileDescriptor.TYPE);
        }

        @Override
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{BBacnetFileExportManager.this.mcolName, BBacnetFileExportManager.this.mcolTargetName, BBacnetFileExportManager.this.mcolObjName, BBacnetFileExportManager.this.mcolObjType, BBacnetFileExportManager.this.mcolInstNum, BBacnetFileExportManager.this.mcolTgtOut, BBacnetFileExportManager.this.mcolFileExportOrd, BBacnetFileExportManager.this.mcolExportStatus, BBacnetFileExportManager.this.mcolFaultCause, BBacnetFileExportManager.this.mcolDescr};
        }

        @Override
        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BBacnetFileDescriptor obj = (BBacnetFileDescriptor)type.newInstance();
            obj.setObjectId(BBacnetObjectIdentifier.make((int)10, (int)BBacnetFileExportManager.this.exports.getNextInstance(10)));
            return obj;
        }
    }
}

