/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.device;

import com.tridium.bacnet.datatypes.BChangeDeviceIdConfig;
import com.tridium.bacnet.datatypes.BDeviceDiscoveryConfig;
import com.tridium.bacnet.datatypes.BDiscoveryNetworks;
import com.tridium.bacnet.datatypes.BTimeSynchConfig;
import com.tridium.bacnet.datatypes.BWhoHasConfig;
import com.tridium.bacnet.job.BDiscoveryDevice;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;

public class BacnetDeviceController
extends DeviceController {
    private static UiLexicon lex = BBacnetDeviceManager.lexicon;
    private static Lexicon wblex = Lexicon.make(MgrController.class);
    private static String addLabel = wblex.getText("add.label");
    private static String newLabel = wblex.getText("new.label");
    private static String changeIdLabel = lex.getText("changeId.label");
    private static final Logger logger = Logger.getLogger("bacnet.ui");
    private BBacnetDeviceManager deviceManager;
    BChangeDeviceIdConfig cfg;
    public final MgrController.MgrCommand whoHas;
    public final MgrController.MgrCommand timeSynch;
    public final MgrController.MgrCommand changeId;
    BJob job;

    public BacnetDeviceController(BBacnetDeviceManager manager) {
        super((BDeviceManager)manager);
        this.deviceManager = manager;
        this.whoHas = new WhoHas((BWidget)manager);
        this.timeSynch = new TimeSynch((BWidget)manager);
        this.changeId = new ChangeId((BWidget)manager);
        this.whoHas.setFlags(3);
        this.timeSynch.setFlags(7);
        this.changeId.setFlags(7);
    }

    public BWidget makeActionBar() {
        MgrController.IMgrCommand[] cmds1 = super.makeCommands();
        MgrController.IMgrCommand[] cmds2 = this.makeBacnetCommands();
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.makeActionPane(cmds1));
        pane.setBottom((BWidget)new BBorderPane(this.makeActionPane(cmds2)));
        return pane;
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return BacnetDeviceController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])this.makeBacnetCommands());
    }

    protected MgrController.IMgrCommand[] makeBacnetCommands() {
        return new MgrController.IMgrCommand[]{this.whoHas, this.timeSynch, this.changeId};
    }

    public void updateCommands() {
        super.updateCommands();
        BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
        BBacnetStack stack = (BBacnetStack)bacnet.getBacnetComm();
        BBacnetNetworkLayer net = stack.getNetwork();
        boolean commEnabled = stack.isCommInitiationEnabled();
        boolean netEnabled = net.isEnabled();
        if (commEnabled && netEnabled) {
            this.setBacnetCommandsEnable(true);
            this.cancel.setEnabled(this.job != null && this.job.getJobState().isRunning());
            this.discover.setEnabled(this.job == null || !this.job.getJobState().isRunning());
        } else {
            this.discover.setEnabled(false);
            this.setBacnetCommandsEnable(false);
        }
    }

    protected void setBacnetCommandsEnable(boolean enable) {
        this.whoHas.setEnabled(enable);
        this.timeSynch.setEnabled(enable);
        if (enable) {
            BComponent[] devs = this.getSelectedComponentsWithoutFolders();
            boolean selection = false;
            if (devs.length > 0) {
                selection = true;
            }
            this.changeId.setEnabled(selection);
        } else {
            this.changeId.setEnabled(false);
        }
    }

    public void doAllDescendants(boolean selected) {
        super.doAllDescendants(selected);
        this.deviceManager.subscribeDevices(this.getManager().getCurrentValue().asComponent());
    }

    public MgrEdit makeEdit(String label) {
        if (label == null) {
            return super.makeEdit(label);
        }
        if (label.equals(addLabel) || label.equals(newLabel)) {
            return new MgrEdit(this.getManager(), label){

                public CommandArtifact commit() throws Exception {
                    CommandArtifact ret = super.commit();
                    MgrEditRow[] rows = this.getRows();
                    for (int i = 0; i < rows.length; ++i) {
                        BDiscoveryDevice disc = (BDiscoveryDevice)rows[i].getDiscovery();
                        BBacnetObjectIdentifier deviceId = (BBacnetObjectIdentifier)rows[i].getCell(((BacnetDeviceController)BacnetDeviceController.this).deviceManager.bacModel().colOid);
                        BBacnetDevice dev = ((BBacnetDeviceManager)this.getManager()).getNetwork().lookupDeviceById(deviceId);
                        if (dev == null) continue;
                        if (disc != null) {
                            dev.getConfig().getDeviceObject().setProtocolServicesSupported(disc.getServicesSupported());
                        }
                        dev.getConfig().getDeviceObject().lease();
                    }
                    return ret;
                }
            };
        }
        if (label.equals(changeIdLabel)) {
            return new ChangeIdEdit(this.getManager(), label);
        }
        return super.makeEdit(label);
    }

    public BJob setJob(BOrd jobOrd) throws Exception {
        try {
            ((BBacnetDeviceManager)this.getManager()).bacLearn().jobComplete = false;
            BComponent base = (BComponent)this.getManager().getCurrentValue();
            base.getComponentSpace().sync();
            this.job = (BJob)jobOrd.get((BObject)base);
            this.getManager().registerForComponentEvents((BComponent)this.job);
            ((BBacnetDeviceManager)this.getManager()).getJobBar().load(this.job);
            return this.job;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "setJob failed", e);
            return null;
        }
    }

    public CommandArtifact doCancel(Context cx) throws Exception {
        if (this.job != null) {
            this.job.cancel();
        }
        return null;
    }

    public CommandArtifact doDiscover(Context cx) throws Exception {
        super.doDiscover(cx);
        BBacnetNetwork net = ((BBacnetDeviceManager)this.getManager()).getNetwork();
        BBacnetStack stack = (BBacnetStack)net.getBacnetComm();
        int[] dnets = stack.getNetwork().getRouterTable().getDnets(-1);
        BDeviceDiscoveryConfig config = new BDeviceDiscoveryConfig();
        config.setNetworks(BDiscoveryNetworks.make((boolean)false, (int[])dnets));
        BDeviceDiscoveryConfig params = (BDeviceDiscoveryConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("deviceManager.discover.description"), (BObject)config);
        if (params != null) {
            this.discover.setEnabled(false);
            BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
        }
        return null;
    }

    public CommandArtifact doWhoHas() throws Exception {
        BBacnetNetwork net = ((BBacnetDeviceManager)this.getManager()).getNetwork();
        BBacnetStack stack = (BBacnetStack)net.getBacnetComm();
        int[] dnets = stack.getNetwork().getRouterTable().getDnets(-1);
        BWhoHasConfig config = new BWhoHasConfig();
        config.setNetworks(BDiscoveryNetworks.make((boolean)false, (int[])dnets));
        BWhoHasConfig params = (BWhoHasConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("whoHas.description"), (BObject)config);
        if (params != null) {
            BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
        }
        return null;
    }

    public CommandArtifact doTimeSynch() throws Exception {
        try {
            int ok = BDialog.confirm((BWidget)this.getManager(), (String)lex.get("timeSynch.title"), (Object)lex.get("timeSynch.confirm"));
            if (ok == 8) {
                return null;
            }
            BTimeSynchConfig params = (BTimeSynchConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("timeSynch.title"), (BObject)new BTimeSynchConfig());
            if (params == null) {
                return null;
            }
            BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in doTimeSynch poll", e);
            String msg = MessageFormat.format(lex.get("timeSynch.fail"), e);
            BDialog.message((BWidget)this.getManager(), (String)lex.get("timeSynch.title"), (Object)msg);
        }
        return null;
    }

    public CommandArtifact doChangeId() throws Exception {
        try {
            int ok = BDialog.confirm((BWidget)this.getManager(), (String)lex.get("changeId.title"), (Object)lex.getText("changeId.confirm"));
            if (ok == 8) {
                return null;
            }
            BComponent[] sel = this.getSelectedComponents();
            if (sel.length == 0) {
                return null;
            }
            MgrEdit edit = this.makeEdit(this.changeId.getLabel());
            for (int i = 0; i < sel.length; ++i) {
                edit.addRow(sel[i]);
            }
            edit.setSelectAll(true);
            if (!edit.prompt()) {
                return null;
            }
            edit.commit();
            this.cfg = (BChangeDeviceIdConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.get("changeId.title"), (BObject)this.cfg);
            if (this.cfg == null) {
                return null;
            }
            BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            this.setJob(bacnet.submitDeviceManagerJob((BValue)this.cfg));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in doChangeId poll", e);
            String msg = MessageFormat.format(lex.get("changeId.fail"), e);
            BDialog.message((BWidget)this.getManager(), (String)lex.get("changeId.title"), (Object)msg);
        }
        return null;
    }

    class ChangeIdEdit
    extends MgrEdit {
        public ChangeIdEdit(BAbstractManager mgr, String title) {
            super(mgr, title);
        }

        protected MgrColumn[] makeColumns() {
            return ((BBacnetDeviceManager)this.getManager()).bacModel().getChangeIdColumns();
        }

        public boolean prompt() throws Exception {
            if (this.getRows().length == 0) {
                return false;
            }
            BMgrEditDialog dialog = new BMgrEditDialog((MgrEdit)this, this.getSelectAll());
            dialog.setScreenSizeToPreferredSize();
            dialog.setBoundsCenteredOnOwner();
            dialog.open();
            return dialog.getResult() == 1;
        }

        public CommandArtifact commit() throws Exception {
            BacnetDeviceController.this.cfg = new BChangeDeviceIdConfig();
            MgrEditRow[] rows = this.getRows();
            for (int i = 0; i < rows.length; ++i) {
                BBacnetObjectIdentifier deviceId = (BBacnetObjectIdentifier)rows[i].getCell(((BacnetDeviceController)BacnetDeviceController.this).deviceManager.bacModel().colOid);
                BBacnetDevice dev = (BBacnetDevice)rows[i].getTarget();
                BacnetDeviceController.this.cfg.addChange(dev.getObjectId(), deviceId);
            }
            return null;
        }
    }

    class ChangeId
    extends MgrController.MgrCommand {
        ChangeId(BWidget owner) {
            super(owner, (Lexicon)lex, "changeId");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetDeviceController.this.doChangeId();
        }
    }

    class TimeSynch
    extends MgrController.MgrCommand {
        TimeSynch(BWidget owner) {
            super(owner, (Lexicon)lex, "timeSynch");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetDeviceController.this.doTimeSynch();
        }
    }

    class WhoHas
    extends MgrController.MgrCommand {
        WhoHas(BWidget owner) {
            super(owner, (Lexicon)lex, "whoHas");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetDeviceController.this.doWhoHas();
        }
    }
}

