/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.udp.comm;

import com.tridium.ddf.comm.BIDdfCommunicator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public class BDdfUdpMulticastHelper
extends BVector {
    public static final Property status = BDdfUdpMulticastHelper.newProperty((int)0, (BValue)BStatus.ok, null);
    public static final Property faultCause = BDdfUdpMulticastHelper.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    public static final Property jaceIpAddress = BDdfUdpMulticastHelper.newProperty((int)0, (String)"localHost", null);
    public static final Property jaceUdpPort = BDdfUdpMulticastHelper.newProperty((int)0, (int)-1, null);
    public static final Property udpGroupAddresses = BDdfUdpMulticastHelper.newProperty((int)0, (BValue)new BVector(), (BFacets)BFacets.make((String)"fieldEditor", (String)"alarm:StringListFE"));
    public static final Type TYPE = Sys.loadType(BDdfUdpMulticastHelper.class);
    private Vector<BString> multiCastGroups = null;
    protected MulticastSocket multicastSocket = null;
    public static final Lexicon LEX = Lexicon.make(BDdfUdpMulticastHelper.class);
    public static final String lexkeyJaceMulticastSocketOpenError = "JaceMulticastSocketOpenError";
    public static final String lexkeyJaceSocketConnectionError = "JaceSocketConnectionError";
    public static final String lexkeyJaceUnknownHostException = "JaceUnknownHostException";
    public static final String lexkeyInvalidGroup = "InvalidMulticastGroup";
    public static final String jaceMulticastSocketOpenError = LEX.getText("JaceMulticastSocketOpenError");
    public static final String jaceSocketConnectionError = LEX.getText("JaceSocketConnectionError");
    public static final String jaceUnknownHostException = LEX.getText("JaceUnknownHostException");
    public static final String invalidMulticastGroup = LEX.getText("InvalidMulticastGroup");
    public static final String formatLexicon = "lexicon(devUdpDriver:";
    public static final BFormat formatJaceMulticastSocketOpenError = BFormat.make((String)BDdfUdpMulticastHelper.formatLexicon("JaceMulticastSocketOpenError"));
    public static final BFormat formatJaceSocketConnectionError = BFormat.make((String)BDdfUdpMulticastHelper.formatLexicon("JaceSocketConnectionError"));
    public static final BFormat formatJaceUnknownHostException = BFormat.make((String)BDdfUdpMulticastHelper.formatLexicon("JaceUnknownHostException"));

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public BFormat getFaultCause() {
        return (BFormat)this.get(faultCause);
    }

    public void setFaultCause(BFormat v) {
        this.set(faultCause, (BValue)v, null);
    }

    public String getJaceIpAddress() {
        return this.getString(jaceIpAddress);
    }

    public void setJaceIpAddress(String v) {
        this.setString(jaceIpAddress, v, null);
    }

    public int getJaceUdpPort() {
        return this.getInt(jaceUdpPort);
    }

    public void setJaceUdpPort(int v) {
        this.setInt(jaceUdpPort, v, null);
    }

    public BVector getUdpGroupAddresses() {
        return (BVector)this.get(udpGroupAddresses);
    }

    public void setUdpGroupAddresses(BVector v) {
        this.set(udpGroupAddresses, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDdfCommunicator getCommunicator() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BIDdfCommunicator)) {
            parent = parent.getParent();
        }
        return (BIDdfCommunicator)parent;
    }

    public MulticastSocket getSocket() {
        try {
            if (this.multicastSocket == null) {
                this.multicastSocket = new MulticastSocket(this.getJaceUdpPort());
                this.multicastSocket.setInterface(InetAddress.getByName(this.getJaceIpAddress()));
                this.joinOrLeaveUdpGroups();
            }
            return this.multicastSocket;
        }
        catch (SocketException se) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(formatJaceSocketConnectionError);
            this.getCommunicator().getLog().error(jaceSocketConnectionError, (Throwable)se);
        }
        catch (UnknownHostException uhe) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(formatJaceUnknownHostException);
            this.getCommunicator().getLog().error(jaceUnknownHostException, (Throwable)uhe);
        }
        catch (IOException ioe) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(formatJaceMulticastSocketOpenError);
            this.getCommunicator().getLog().error(jaceMulticastSocketOpenError, (Throwable)ioe);
        }
        return null;
    }

    public void closeSocket() {
        if (this.multicastSocket != null) {
            this.multicastSocket.close();
            this.multicastSocket = null;
        }
    }

    protected void joinOrLeaveUdpGroups() {
        if (this.multicastSocket != null) {
            BString[] groups = (BString[])this.getUdpGroupAddresses().getChildren(BString.class);
            this.joinUdpGroups(groups);
            this.leaveUdpGroups(groups);
        }
    }

    protected void joinUdpGroups(BString[] groups) {
        if (this.multicastSocket != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (this.multiCastGroups.contains(groups[i])) continue;
                try {
                    this.multiCastGroups.addElement(groups[i]);
                    this.multicastSocket.joinGroup(InetAddress.getByName(groups[i].getString()));
                    continue;
                }
                catch (IOException ioe) {
                    this.setStatus(BStatus.fault);
                    this.setFaultCause(BDdfUdpMulticastHelper.formatInvalidMulticastGroup(groups[i], ioe));
                    this.getCommunicator().getLog().error(invalidMulticastGroup, (Throwable)ioe);
                }
            }
        }
    }

    protected void leaveUdpGroups(BString[] groups) {
        Iterator<BString> joinedGroups = this.multiCastGroups.iterator();
        Array newGroups = new Array((Object[])groups);
        while (joinedGroups.hasNext()) {
            BString group = joinedGroups.next();
            if (newGroups.contains((Object)group)) continue;
            try {
                this.multicastSocket.leaveGroup(InetAddress.getByName(group.getString()));
            }
            catch (IOException ioe) {
                this.setStatus(BStatus.fault);
                this.setFaultCause(BDdfUdpMulticastHelper.formatInvalidMulticastGroup(group, ioe));
                this.getCommunicator().getLog().error(invalidMulticastGroup, (Throwable)ioe);
            }
            joinedGroups.remove();
        }
    }

    public void changed(Property property, Context context) {
        if (property.equals(udpGroupAddresses)) {
            this.joinOrLeaveUdpGroups();
        } else if (property.equals(jaceIpAddress) || property.equals(jaceUdpPort)) {
            this.closeSocket();
        }
        super.changed(property, context);
    }

    public static String formatLexicon(String lexkey) {
        return formatLexicon + lexkey + ')';
    }

    public static final BFormat formatInvalidMulticastGroup(BString g, Exception e) {
        return BFormat.make((String)(g.toString() + ':' + BDdfUdpMulticastHelper.formatLexicon(lexkeyInvalidGroup) + ':' + e));
    }
}

