/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.search;

import com.tridium.nre.util.NreForkJoinWorkerThreadFactory;
import com.tridium.sys.engine.NClockTicket;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BIQueryHandler;
import javax.baja.query.BQueryScheme;
import javax.baja.registry.TypeInfo;
import javax.baja.search.BISearchProvider;
import javax.baja.search.BResultsRequest;
import javax.baja.search.BSearchParams;
import javax.baja.search.BSearchResultSet;
import javax.baja.search.BSearchScope;
import javax.baja.search.BSearchTask;
import javax.baja.security.BIProtected;
import javax.baja.space.BISpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="defaultScheme", type="String", defaultValue="neql"), @NiagaraProperty(name="defaultScopes", type="BVector", defaultValue="makeDefaultSearchScopes()"), @NiagaraProperty(name="maxConcurrentSearches", type="int", defaultValue="50", facets={@Facet(name="min", value="1")}), @NiagaraProperty(name="maxResultsPerSearch", type="int", defaultValue="500", facets={@Facet(name="min", value="1")}), @NiagaraProperty(name="searchTaskTimeToLive", type="BRelTime", defaultValue="BRelTime.makeMinutes(2)", facets={@Facet(name="min", value="BRelTime.makeSeconds(1)")}), @NiagaraProperty(name="activeSearchContainer", type="BVector", defaultValue="new BVector()", flags=262)}, actions={@NiagaraAction(name="search", parameterType="BSearchParams", returnType="BOrd", defaultValue="new BSearchParams()", flags=260), @NiagaraAction(name="retrieveResults", parameterType="BResultsRequest", returnType="BSearchResultSet", defaultValue="BResultsRequest.DEFAULT", flags=2308), @NiagaraAction(name="getSearchScopes", returnType="BVector", flags=2308), @NiagaraAction(name="updateDefaultScopeInfo", flags=16)})
public final class BSearchService
extends BAbstractService {
    private static final BOrd SYS_ORD = BOrd.make((String)"sys:");
    public static final Property defaultScheme = BSearchService.newProperty((int)0, (String)"neql", null);
    public static final Property defaultScopes = BSearchService.newProperty((int)0, (BValue)BSearchService.makeDefaultSearchScopes(), null);
    public static final Property maxConcurrentSearches = BSearchService.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Property maxResultsPerSearch = BSearchService.newProperty((int)0, (int)500, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Property searchTaskTimeToLive = BSearchService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property activeSearchContainer = BSearchService.newProperty((int)262, (BValue)new BVector(), null);
    public static final Action search = BSearchService.newAction((int)260, (BValue)new BSearchParams(), null);
    public static final Action retrieveResults = BSearchService.newAction((int)2308, (BValue)BResultsRequest.DEFAULT, null);
    public static final Action getSearchScopes = BSearchService.newAction((int)2308, null);
    public static final Action updateDefaultScopeInfo = BSearchService.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BSearchService.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/searchService.png");
    public static final Logger logger = Logger.getLogger("search");
    protected ForkJoinPool executor;
    private static boolean allowLocalSearch;
    private static boolean allowSystemSearch;

    public String getDefaultScheme() {
        return this.getString(defaultScheme);
    }

    public void setDefaultScheme(String v) {
        this.setString(defaultScheme, v, null);
    }

    public BVector getDefaultScopes() {
        return (BVector)this.get(defaultScopes);
    }

    public void setDefaultScopes(BVector v) {
        this.set(defaultScopes, (BValue)v, null);
    }

    public int getMaxConcurrentSearches() {
        return this.getInt(maxConcurrentSearches);
    }

    public void setMaxConcurrentSearches(int v) {
        this.setInt(maxConcurrentSearches, v, null);
    }

    public int getMaxResultsPerSearch() {
        return this.getInt(maxResultsPerSearch);
    }

    public void setMaxResultsPerSearch(int v) {
        this.setInt(maxResultsPerSearch, v, null);
    }

    public BRelTime getSearchTaskTimeToLive() {
        return (BRelTime)this.get(searchTaskTimeToLive);
    }

    public void setSearchTaskTimeToLive(BRelTime v) {
        this.set(searchTaskTimeToLive, (BValue)v, null);
    }

    public BVector getActiveSearchContainer() {
        return (BVector)this.get(activeSearchContainer);
    }

    public void setActiveSearchContainer(BVector v) {
        this.set(activeSearchContainer, (BValue)v, null);
    }

    public BOrd search(BSearchParams parameter) {
        return (BOrd)this.invoke(search, (BValue)parameter, null);
    }

    public BSearchResultSet retrieveResults(BResultsRequest parameter) {
        return (BSearchResultSet)this.invoke(retrieveResults, (BValue)parameter, null);
    }

    public BVector getSearchScopes() {
        return (BVector)this.invoke(getSearchScopes, null, null);
    }

    public void updateDefaultScopeInfo() {
        this.invoke(updateDefaultScopeInfo, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public final void serviceStarted() {
        if (this.isOperational()) {
            int threadsPerCPU = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("niagara.search.threadsPerCPU", String.valueOf(2))));
            int defaultThreads = Runtime.getRuntime().availableProcessors() * threadsPerCPU;
            int threads = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("niagara.search.threads", String.valueOf(defaultThreads))));
            this.executor = new ForkJoinPool(threads, NreForkJoinWorkerThreadFactory.DEFAULT_INSTANCE, new UncaughtSearchExceptionHandler(), true);
            try {
                SlotCursor c = this.getDefaultScopes().getProperties();
                Exception resolveError = null;
                while (c.next(BSearchScope.class)) {
                    BObject scopeObj;
                    BSearchScope scope = (BSearchScope)c.get();
                    if (!scope.getScopeName().isEmpty() || !scope.getScopeLexiconModule().isEmpty() && !scope.getScopeLexiconKey().isEmpty()) continue;
                    BOrd scopeOrd = scope.getScopeOrd();
                    try {
                        scopeObj = scopeOrd.resolve((BObject)this, null).get();
                    }
                    catch (Exception ex) {
                        if (resolveError != null || (ex instanceof UnresolvedException || ex instanceof UnknownSchemeException) && SYS_ORD.equals((Object)scopeOrd)) continue;
                        resolveError = ex;
                        continue;
                    }
                    if (scopeObj instanceof BISpace) {
                        BISpace space = (BISpace)scopeObj;
                        scope.setScopeName(space.getDisplayName(null));
                        scope.setScopeLexiconModule(space.getLexiconText().module.getModuleName());
                        scope.setScopeLexiconKey(space.getLexiconText().key);
                        continue;
                    }
                    if (!scopeObj.isComponent()) continue;
                    BComponent comp = (BComponent)scopeObj;
                    scope.setScopeName(comp.getDisplayName(null));
                }
                if (resolveError != null) {
                    throw resolveError;
                }
            }
            catch (Exception e) {
                String warningMsg = "Could not update missing default search scope properties. Users will need to manually update them under the SearchService";
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, warningMsg, e);
                }
                logger.log(Level.WARNING, warningMsg);
            }
        }
    }

    public final void serviceStopped() {
        if (this.executor == null) {
            return;
        }
        this.executor.shutdownNow();
    }

    protected final void enabled() {
        this.serviceStarted();
    }

    protected final void disabled() {
        this.serviceStopped();
    }

    public static BSearchService getService() {
        return (BSearchService)Sys.getService((Type)TYPE);
    }

    public final Feature getLicenseFeature() {
        Feature feature = Sys.getLicenseManager().getFeature("tridium", "search");
        allowLocalSearch = feature.getb("local", false);
        allowSystemSearch = feature.getb("system", false);
        if (!allowLocalSearch && !allowSystemSearch) {
            this.configFatal("Unlicensed for both local and system searches. No searching is allowed.");
        }
        return feature;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals(searchTaskTimeToLive)) {
                SlotCursor c = this.getActiveSearchContainer().getProperties();
                while (c.next(BSearchTask.class)) {
                    ((BSearchTask)c.get()).checkExpiration(true);
                }
            } else if (property.equals(maxConcurrentSearches)) {
                try {
                    this.checkConcurrentSearchLimit(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.changed(property, context);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == updateDefaultScopeInfo) {
            new Thread((Runnable)new Invocation((BComponent)this, action, argument, cx)).start();
        }
        return null;
    }

    public BSearchTask executeSearch(BSearchParams searchParams, Executor executor, Context cx) {
        if (!this.isOperational()) {
            throw new NotRunningException("The SearchService is not operational");
        }
        if (executor == null) {
            executor = this.getExecutor();
        }
        BSearchTask searchTask = new BSearchTask(searchParams, cx);
        executor.execute(searchTask);
        return searchTask;
    }

    public BSearchTask executeSearch(BSearchParams searchParams, Executor executor) {
        return this.executeSearch(searchParams, executor, null);
    }

    public BSearchTask executeSearch(BSearchParams searchParams) {
        return this.executeSearch(searchParams, null, null);
    }

    public BOrd doSearch(BSearchParams searchParams, Context cx) {
        if (!this.isOperational()) {
            throw new NotRunningException("The SearchService is not operational");
        }
        BSearchTask searchTask = new BSearchTask(searchParams, cx);
        BOrd slotPathOrd = this.submitSearchTask(searchTask, cx);
        return BOrd.make((BOrd)this.getSpace().getAbsoluteOrd(), (BOrd)slotPathOrd);
    }

    public BSearchResultSet doRetrieveResults(BResultsRequest request, Context cx) {
        if (!this.isOperational()) {
            throw new NotRunningException("The SearchService is not operational");
        }
        BSearchTask task = (BSearchTask)request.getTaskOrd().get(null, cx);
        if (task != null) {
            return BSearchResultSet.make(task.getResults(), request.getStartIndex(), request.getMaxResults(), cx);
        }
        throw new IllegalArgumentException("Unknown task type");
    }

    public void doUpdateDefaultScopeInfo() {
        if (!this.isOperational()) {
            throw new NotRunningException("The SearchService is not operational");
        }
        SlotCursor c = this.getDefaultScopes().getProperties();
        while (c.next(BSearchScope.class)) {
            BSearchScope scope = (BSearchScope)c.get();
            BOrd scopeOrd = scope.getScopeOrd();
            try {
                BObject scopeObj = scopeOrd.resolve((BObject)this, null).get();
                if (scopeObj instanceof BISpace) {
                    BISpace space = (BISpace)scopeObj;
                    if (scope.getScopeName().length() == 0) {
                        scope.setScopeName(space.getDisplayName(null));
                    }
                    if (scope.getScopeLexiconModule().length() == 0) {
                        scope.setScopeLexiconModule(space.getLexiconText().module.getModuleName());
                    }
                    if (scope.getScopeLexiconKey().length() != 0) continue;
                    scope.setScopeLexiconKey(space.getLexiconText().key);
                    continue;
                }
                if (!scopeObj.isComponent()) continue;
                BComponent comp = (BComponent)scopeObj;
                if (scope.getScopeName().length() != 0) continue;
                scope.setScopeName(comp.getDisplayName(null));
            }
            catch (Exception exception) {}
        }
    }

    public BVector doGetSearchScopes(Context cx) {
        if (!this.isOperational()) {
            throw new NotRunningException("The SearchService is not operational");
        }
        if (cx == null || cx.getUser() == null) {
            return new BVector();
        }
        ArrayList<BSearchScope> temp = new ArrayList<BSearchScope>();
        BVector defScopes = this.getDefaultScopes();
        SlotCursor c = defScopes.getProperties();
        while (c.next()) {
            BOrd scopeOrd;
            OrdTarget scopeTarget;
            BValue obj = c.get();
            if (obj instanceof BSearchScope) {
                OrdTarget scopeTarget2;
                BSearchScope defScope = (BSearchScope)obj;
                BOrd scopeOrd2 = defScope.getScopeOrd();
                try {
                    scopeTarget2 = scopeOrd2.resolve((BObject)this, cx);
                }
                catch (Exception ex) {
                    continue;
                }
                if (!scopeTarget2.canRead() || !BSearchService.validSchemeForScope(null, scopeTarget2)) continue;
                BObject scopeObj = scopeTarget2.get();
                if (scopeObj instanceof BISpace) {
                    BISpace scopeSpace = (BISpace)scopeObj;
                    if (defScope.getScopeName().length() == 0) {
                        defScope.setScopeName(scopeSpace.getLexiconText().getText(null));
                    }
                    if (defScope.getScopeLexiconModule().length() == 0) {
                        defScope.setScopeLexiconModule(scopeSpace.getLexiconText().module.getModuleName());
                    }
                    if (defScope.getScopeLexiconKey().length() == 0) {
                        defScope.setScopeLexiconKey(scopeSpace.getLexiconText().key);
                    }
                }
                defScope = (BSearchScope)obj.asComplex().newCopy(true);
                if (scopeObj instanceof BISpace) {
                    defScope.setScopeName(((BISpace)scopeObj.as(BISpace.class)).getLexiconText().getText(cx));
                }
                temp.add(defScope);
                continue;
            }
            if (!(obj instanceof BOrd) || !(scopeTarget = (scopeOrd = (BOrd)obj).resolve((BObject)this, cx)).canRead() || !BSearchService.validSchemeForScope(null, scopeTarget)) continue;
            BObject scopeObj = scopeTarget.get();
            String scopeName = scopeObj instanceof BComplex ? scopeObj.asComplex().getDisplayName(cx) : scopeObj.toString(cx);
            String lexModule = "";
            String lexKey = "";
            if (scopeObj instanceof BISpace) {
                BISpace space = (BISpace)scopeObj;
                lexModule = space.getLexiconText().module.getModuleName();
                lexKey = space.getLexiconText().key;
            }
            BSearchScope scope = new BSearchScope(scopeName, lexModule, lexKey, scopeOrd, true);
            temp.add(scope);
        }
        BUser user = cx.getUser();
        Iterator spaces = BLocalHost.INSTANCE.getSpaces();
        while (spaces.hasNext()) {
            BISpace space = (BISpace)spaces.next();
            if (!(space instanceof BIProtected) || !user.getPermissionsFor((BIProtected)space.as(BIProtected.class)).hasOperatorRead() || !BSearchService.validSchemeForScope(null, space.getAbsoluteOrd().resolve())) continue;
            boolean found = false;
            for (BSearchScope def : temp) {
                if (!def.getScopeOrd().equals((Object)space.getOrdInSession())) continue;
                found = true;
                break;
            }
            if (found) continue;
            BSearchScope spaceScope = new BSearchScope(space.getDisplayName(cx), space.getLexiconText().module.getModuleName(), space.getLexiconText().key, space.getOrdInSession(), false);
            temp.add(spaceScope);
        }
        BVector result = new BVector();
        Iterator i = temp.iterator();
        while (i.hasNext()) {
            result.add("scope" + result.getPropertyCount(), (BValue)i.next());
        }
        return result;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    BOrd submitSearchTask(BSearchTask task, Context cx) {
        this.checkConcurrentSearchLimit(true);
        int flags = 2;
        if (!this.getPermissions(cx).hasAdminRead()) {
            flags |= 0x100;
        }
        this.getActiveSearchContainer().add(task.getType().getTypeName() + '?', (BValue)task, flags, null);
        task.doSubmit(cx);
        return task.getSlotPathOrd();
    }

    private void checkConcurrentSearchLimit(boolean reduceByOne) {
        int maxSearches = this.getMaxConcurrentSearches();
        if (maxSearches < 1) {
            maxSearches = 1;
        }
        if (reduceByOne) {
            --maxSearches;
        }
        BSearchTask[] tasks = (BSearchTask[])this.getActiveSearchContainer().getChildren(BSearchTask.class);
        while (maxSearches < tasks.length) {
            int index = -1;
            long millisToExpiration = Long.MAX_VALUE;
            int len = tasks.length;
            for (int i = 0; i < len; ++i) {
                if (tasks[i].isSubscribed()) continue;
                if (tasks[i].expirationTicket instanceof NClockTicket) {
                    long millisLeft = ((NClockTicket)tasks[i].expirationTicket).millisLeft();
                    if (millisLeft >= millisToExpiration) continue;
                    index = i;
                    millisToExpiration = millisLeft;
                    continue;
                }
                if (index != -1) continue;
                index = i;
            }
            if (index == -1) {
                throw new LocalizableRuntimeException("search", "search.error.tooManySearches");
            }
            tasks[index].doExpire(null);
            tasks = (BSearchTask[])this.getActiveSearchContainer().getChildren(BSearchTask.class);
            if (len != tasks.length) continue;
            throw new LocalizableRuntimeException("search", "search.error.tooManySearches");
        }
    }

    static boolean validSchemeForScope(BOrdScheme ordScheme, OrdTarget scope) {
        TypeInfo[] ordSchemeTypes;
        TypeInfo[] querySchemeTypes;
        if (!allowLocalSearch && BSearchService.isLocalScope(scope)) {
            return false;
        }
        if (!allowSystemSearch && BSearchService.isSystemScope(scope)) {
            return false;
        }
        if (ordScheme instanceof BQueryScheme) {
            return BQueryScheme.findQueryHandler((OrdTarget)scope, (BQueryScheme)((BQueryScheme)ordScheme)) != null;
        }
        if (ordScheme != null) {
            return BSearchService.findSearchProvider(scope.get(), ordScheme) != null;
        }
        for (TypeInfo querySchemeType : querySchemeTypes = Sys.getRegistry().getConcreteTypes(BQueryScheme.TYPE.getTypeInfo())) {
            BIQueryHandler queryHandler = BQueryScheme.findQueryHandler((OrdTarget)scope, (BQueryScheme)((BQueryScheme)querySchemeType.getInstance()));
            if (queryHandler == null) continue;
            return true;
        }
        for (TypeInfo ordSchemeType : ordSchemeTypes = Sys.getRegistry().getConcreteTypes(BOrdScheme.TYPE.getTypeInfo())) {
            BISearchProvider provider;
            BIQueryHandler queryHandler;
            if (!(ordSchemeType.is(BQueryScheme.TYPE) ? (queryHandler = BQueryScheme.findQueryHandler((OrdTarget)scope, (BQueryScheme)((BQueryScheme)ordSchemeType.getInstance()))) != null : (provider = BSearchService.findSearchProvider(scope.get(), (BOrdScheme)ordSchemeType.getInstance())) != null)) continue;
            return true;
        }
        return false;
    }

    static BISearchProvider findSearchProvider(BObject scope, BOrdScheme ordScheme) {
        BISearchProvider handler = null;
        AgentList targetAgents = scope.getAgents().filter(AgentFilter.is((Type)BISearchProvider.TYPE));
        AgentList schemeAgents = ordScheme.getAgents().filter(AgentFilter.is((Type)BISearchProvider.TYPE));
        int taCount = targetAgents.size();
        for (int i = 0; i < taCount; ++i) {
            AgentInfo agent = targetAgents.get(i);
            if (schemeAgents.indexOf(agent) == -1) continue;
            handler = (BISearchProvider)agent.getInstance();
            break;
        }
        return handler;
    }

    static BVector makeDefaultSearchScopes() {
        BVector defaults = new BVector();
        defaults.add("scope?", (BValue)new BSearchScope("", "", "", BOrd.make((String)"station:"), true));
        defaults.add("scope?", (BValue)new BSearchScope("", "", "", SYS_ORD, true));
        return defaults;
    }

    static boolean isLocalScope(OrdTarget scope) {
        return true;
    }

    static boolean isSystemScope(OrdTarget scope) {
        return false;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("SearchService");
        out.prop((Object)"Licensed for local searches", allowLocalSearch);
        out.prop((Object)"Licensed for system searches", allowSystemSearch);
        out.endProps();
        if (this.executor != null) {
            out.w((Object)"<p>");
            out.startTable(true);
            out.trTitle((Object)"Thread Pool", 7);
            out.w((Object)"<tr>").th((Object)"Current Pool Size").th((Object)"Max Pool Size").th((Object)"Active").th((Object)"Running").th((Object)"Submitted").th((Object)"Queued").th((Object)"Steals").w((Object)"</tr>").nl();
            out.tr((Object)this.executor.getPoolSize(), (Object)this.executor.getParallelism(), (Object)this.executor.getActiveThreadCount(), (Object)this.executor.getRunningThreadCount(), (Object)this.executor.getQueuedSubmissionCount(), (Object)this.executor.getQueuedTaskCount(), (Object)this.executor.getStealCount());
            out.endTable();
        }
        BSearchTask[] tasks = (BSearchTask[])this.getActiveSearchContainer().getChildren(BSearchTask.class);
        out.startTable(true);
        out.trTitle((Object)"SearchTasks", 11);
        out.w((Object)"<tr>").th((Object)"Name").th((Object)"State").th((Object)"Progress").th((Object)"Start").th((Object)"Heartbeat").th((Object)"End").th((Object)"User").th((Object)"ResultCount").th((Object)"ResultsExceedLimit").th((Object)"ExpirationTicket").th((Object)"SearchParams").w((Object)"</tr>").nl();
        for (BSearchTask j : tasks) {
            out.w((Object)"<tr>").td((Object)j.getName()).td((Object)j.getJobState()).td((Object)String.valueOf(j.getProgress())).td((Object)j.getStartTime()).td((Object)j.getHeartbeatTime()).td((Object)j.getEndTime());
            if (j.searchContext != null) {
                out.td((Object)j.searchContext.getUser());
            } else {
                out.td((Object)"null context");
            }
            out.td((Object)j.getResultCount()).td((Object)j.getResultsExceedLimit()).td((Object)j.expirationTicket).td((Object)j.searchParams).w((Object)"</tr>");
        }
        out.endTable();
        super.spy(out);
    }

    public BIcon getIcon() {
        return icon;
    }

    static class UncaughtSearchExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        UncaughtSearchExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Uncaught exception from thread " + t + "\n" + e);
            }
        }
    }
}

