/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.search;

import java.util.Arrays;
import java.util.stream.Stream;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.search.BSearchResult;
import javax.baja.search.BSearchService;
import javax.baja.security.BIProtected;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.virtual.BVirtualComponent;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="startIndex", type="int", defaultValue="0", flags=256, facets={@Facet(name="min", value="0")}), @NiagaraProperty(name="maxResults", type="int", defaultValue="-1", flags=256, facets={@Facet(name="min", value="-1")}), @NiagaraProperty(name="resultCount", type="int", defaultValue="0", flags=257), @NiagaraProperty(name="resultsComplete", type="boolean", defaultValue="false", flags=257), @NiagaraProperty(name="resultsExceedLimit", type="boolean", defaultValue="false", flags=257), @NiagaraProperty(name="results", type="BVector", defaultValue="new BVector()", flags=257)})
public class BSearchResultSet
extends BComponent {
    public static final Property startIndex = BSearchResultSet.newProperty((int)256, (int)0, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property maxResults = BSearchResultSet.newProperty((int)256, (int)-1, (BFacets)BFacets.make((String)"min", (int)-1));
    public static final Property resultCount = BSearchResultSet.newProperty((int)257, (int)0, null);
    public static final Property resultsComplete = BSearchResultSet.newProperty((int)257, (boolean)false, null);
    public static final Property resultsExceedLimit = BSearchResultSet.newProperty((int)257, (boolean)false, null);
    public static final Property results = BSearchResultSet.newProperty((int)257, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BSearchResultSet.class);
    private Object lock = new Object();

    public int getStartIndex() {
        return this.getInt(startIndex);
    }

    public void setStartIndex(int v) {
        this.setInt(startIndex, v, null);
    }

    public int getMaxResults() {
        return this.getInt(maxResults);
    }

    public void setMaxResults(int v) {
        this.setInt(maxResults, v, null);
    }

    public int getResultCount() {
        return this.getInt(resultCount);
    }

    public void setResultCount(int v) {
        this.setInt(resultCount, v, null);
    }

    public boolean getResultsComplete() {
        return this.getBoolean(resultsComplete);
    }

    public void setResultsComplete(boolean v) {
        this.setBoolean(resultsComplete, v, null);
    }

    public boolean getResultsExceedLimit() {
        return this.getBoolean(resultsExceedLimit);
    }

    public void setResultsExceedLimit(boolean v) {
        this.setBoolean(resultsExceedLimit, v, null);
    }

    public BVector getResults() {
        return (BVector)this.get(results);
    }

    public void setResults(BVector v) {
        this.set(results, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSearchResultSet() {
    }

    protected BSearchResultSet(int startIndex, int maxResults) {
        this.setStartIndex(startIndex);
        this.setMaxResults(maxResults);
    }

    public static final BSearchResultSet make(BSearchResultSet set, int startIndex, int maxResults, Context cx) {
        BSearchResultSet results = new BSearchResultSet(startIndex, maxResults);
        int lastIndex = results.copyResults(set, cx);
        int origCount = set.getResultCount();
        results.setResultsComplete(set.getResultsComplete() && lastIndex == origCount);
        results.setResultsExceedLimit(lastIndex < origCount || lastIndex == origCount && set.getResultsExceedLimit());
        return results;
    }

    public Stream<Entity> streamResults() {
        return Arrays.stream(this.getResults().getDynamicPropertiesArray()).map(prop -> (Entity)this.get((Property)prop));
    }

    public void addResults(Stream<Entity> stream) {
        this.addResults(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResults(Stream<Entity> stream, Context cx) {
        Object object = this.lock;
        synchronized (object) {
            try {
                stream.forEach(e -> this.addResult((Entity)e, cx));
            }
            catch (IllegalStateException ise) {
                this.setResultsExceedLimit(true);
            }
            this.setResultCount(this.getResults().getPropertyCount());
        }
    }

    private BSearchResult addResult(Entity entity, Context cx) throws IllegalStateException {
        BVector items = this.getResults();
        int itemCount = items.getPropertyCount();
        int maxItems = this.getMaxResults();
        if (maxItems >= 0 && itemCount >= maxItems) {
            throw new IllegalStateException("Cannot add result to SearchResultSet: Max Size Reached");
        }
        BAbsTime epoch = BAbsTime.now();
        BSearchResult result = null;
        if (entity instanceof BSearchResult) {
            result = (BSearchResult)entity;
            if (result.getPropertyInParent() != null) {
                result = this.copyTaskResult(result);
            }
        } else {
            BOrd ord = entity.getOrdToEntity().orElse(BOrd.DEFAULT).relativizeToSession();
            if (entity instanceof BVirtualComponent) {
                BVirtualComponent virtual = (BVirtualComponent)entity;
                if (!virtual.getPermissions(cx).hasOperatorRead()) {
                    return result;
                }
                ord = virtual.getNavOrd().relativizeToSession();
            } else if (entity instanceof BISpaceNode) {
                ord = ((BISpaceNode)entity).getOrdInSession();
            }
            if (entity instanceof BIObject) {
                result = BSearchResult.make(ord, (BIObject)entity, (BSimple)epoch);
            } else {
                result = BSearchResult.make(ord, null, (BSimple)epoch);
                result.applyTags(entity, cx);
            }
        }
        if (result != null) {
            items.add("result0?", (BValue)result, 258);
        }
        return result;
    }

    private BSearchResult copyTaskResult(BSearchResult taskResult) {
        BSearchResult newObj = (BSearchResult)taskResult.newCopy();
        if (taskResult.hasObject()) {
            newObj.setObject(taskResult.getObject());
        }
        return newObj;
    }

    private int copyResults(BSearchResultSet set, Context cx) {
        int propertyCount;
        BVector myItems = this.getResults();
        BVector sourceItems = set.getResults();
        boolean checkPermissions = cx != null;
        int index = this.getStartIndex();
        int maxItems = this.getMaxResults();
        int endIndex = propertyCount = sourceItems.getPropertyCount();
        if (maxItems >= 0 && maxItems != Integer.MAX_VALUE && (endIndex = index + maxItems) > propertyCount) {
            endIndex = propertyCount;
        }
        int newIndex = 0;
        StringBuffer sb = new StringBuffer("result");
        while (index < endIndex) {
            try {
                String name = sb.append(index).toString();
                sb.setLength(6);
                String newName = sb.append(newIndex).toString();
                BSearchResult result = (BSearchResult)sourceItems.get(name);
                BIObject obj = null;
                try {
                    obj = result.getObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (obj != null) {
                    if (checkPermissions && obj instanceof BIProtected) {
                        if (((BIProtected)obj).getPermissions(cx).hasOperatorRead()) {
                            myItems.add(newName, (BValue)this.copyTaskResult(result), 258);
                            ++newIndex;
                        } else if (endIndex < propertyCount) {
                            ++endIndex;
                        }
                    } else {
                        myItems.add(newName, (BValue)this.copyTaskResult(result), 258);
                        ++newIndex;
                    }
                } else {
                    myItems.add(newName, result.newCopy(), 258);
                    ++newIndex;
                }
            }
            catch (Exception e) {
                BSearchService.logger.fine("Could not copy search result. " + e);
            }
            ++index;
            sb.setLength(6);
        }
        this.setResultCount(myItems.getPropertyCount());
        return endIndex;
    }
}

