/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.search;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpace;
import javax.baja.space.BISpaceNode;
import javax.baja.spy.BSpy;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="query", type="String", defaultValue="", flags=256), @NiagaraProperty(name="scopeVector", type="BVector", defaultValue="new BVector()", flags=256)})
public class BSearchParams
extends BComponent {
    public static final Property query = BSearchParams.newProperty((int)256, (String)"", null);
    public static final Property scopeVector = BSearchParams.newProperty((int)256, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BSearchParams.class);

    public String getQuery() {
        return this.getString(query);
    }

    public void setQuery(String v) {
        this.setString(query, v, null);
    }

    public BVector getScopeVector() {
        return (BVector)this.get(scopeVector);
    }

    public void setScopeVector(BVector v) {
        this.set(scopeVector, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSearchParams() {
    }

    public BSearchParams(BOrd query, BIObject scope) {
        this(query.encodeToString(), new BIObject[]{scope});
    }

    public BSearchParams(BOrd query, BIObject[] scopes) {
        this(query.encodeToString(), scopes);
    }

    public BSearchParams(String query, BIObject scope) {
        this(query, new BIObject[]{scope});
    }

    public BSearchParams(String query, BIObject[] scopes) {
        this.setQuery(query);
        if (scopes != null) {
            for (BIObject scope : scopes) {
                this.addScope(scope);
            }
        }
    }

    public BOrd getQueryOrd() {
        BOrd query = null;
        try {
            query = BOrd.make((String)this.getQuery());
            query.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return query;
    }

    public void addScope(BIObject scope) {
        BSearchParams.addScope(this.getScopeVector(), scope);
    }

    public void addScopes(BIObject[] scopes) {
        for (BIObject scope : scopes) {
            this.addScope(scope);
        }
    }

    public void setScope(BIObject scope) {
        BVector v = this.getScopeVector();
        v.removeAll();
        BSearchParams.addScope(v, scope);
    }

    public void setScopes(BIObject[] scopes) {
        BVector v = this.getScopeVector();
        v.removeAll();
        for (BIObject scope : scopes) {
            BSearchParams.addScope(v, scope);
        }
    }

    public BIObject[] resolveScopes() {
        return this.resolveScopes((BIObject)BLocalHost.INSTANCE);
    }

    public BIObject[] resolveScopes(BIObject base) {
        BValue[] scopeValues = this.getScopesAsValues();
        ArrayList<Object> scopeList = new ArrayList<Object>();
        for (int i = 0; i < scopeValues.length; ++i) {
            try {
                scopeList.add(BSearchParams.resolveScope(scopeValues[i], base));
                continue;
            }
            catch (Exception e) {
                BString error = BString.make((String)("Cannot resolve scope " + scopeValues[i].toString(null) + " with base " + base == null ? "null" : base.toString(null)));
                scopeList.add(error);
                Logger.getLogger("task").warning(error.getString());
            }
        }
        return scopeList.toArray(new BIObject[scopeList.size()]);
    }

    public String toString(Context context) {
        StringBuffer sb = new StringBuffer();
        BVector v = this.getScopeVector();
        Property[] props = v.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (i > 0) {
                sb.append("; ");
            }
            sb.append(v.get(props[i]).toString(context));
        }
        Lexicon lex = Lexicon.make((String)"search", (Context)context);
        return lex.getText("searchParams.toString", new Object[]{this.getQuery(), sb.toString()});
    }

    private BValue[] getScopesAsValues() {
        Property[] props;
        ArrayList<BValue> scopes = new ArrayList<BValue>();
        BVector v = this.getScopeVector();
        for (Property prop : props = v.getPropertiesArray()) {
            if (!prop.isProperty()) continue;
            BValue obj = v.get(prop);
            scopes.add(obj);
        }
        return scopes.toArray(new BValue[scopes.size()]);
    }

    private static BIObject resolveScope(BValue scope) {
        return BSearchParams.resolveScope(scope, (BIObject)BLocalHost.INSTANCE);
    }

    private static BIObject resolveScope(BValue scope, BIObject base) {
        BValue obj = scope;
        if (obj instanceof BOrd) {
            obj = ((BOrd)obj).resolve((BObject)base).get();
        }
        return obj;
    }

    private static void addScope(BVector v, BIObject scope) {
        BValue vScope = BSearchParams.convertToValue(scope);
        if (vScope != null) {
            v.add("scope?", vScope);
        } else if (scope != null) {
            throw new IllegalArgumentException("Cannot use " + scope.toString(null) + " as a scope object");
        }
    }

    private static BValue convertToValue(BIObject scope) {
        Object vScope = null;
        if (scope != null) {
            Entity eScope;
            if (scope instanceof BISpaceNode) {
                vScope = ((BISpaceNode)scope).getOrdInSession();
            } else if (scope instanceof BSpy) {
                vScope = BOrd.make((OrdQuery)((BSpy)scope).getPath());
            }
            if (vScope == null && scope instanceof Entity && (eScope = (Entity)scope).getOrdToEntity().isPresent()) {
                vScope = (BValue)eScope.getOrdToEntity().get();
            }
            if (vScope == null && scope instanceof BComplex) {
                BComplex cScope = (BComplex)scope;
                vScope = cScope.getParent() == null ? cScope : cScope.newCopy();
            }
            if (vScope == null && scope instanceof BISpace) {
                vScope = ((BISpace)scope).getOrdInSession();
            }
            if (vScope == null && scope instanceof BValue) {
                vScope = (BValue)scope;
            }
        }
        return vScope;
    }
}

