/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.webChart;

import com.tridium.history.BHistoryDeltaQuery;
import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.nre.util.Version;
import com.tridium.web.RestUtil;
import com.tridium.web.WebUtil;
import com.tridium.webChart.WebChartUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryCursor;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.schedule.BControlSchedule;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BAbsTimeRange;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebChartQueryServlet
extends HttpServlet {
    private static final Pattern dataPattern = Pattern.compile("/data/.+");
    private static final Pattern schedulePattern = Pattern.compile("/schedule/.+");
    private static final Pattern boxTablePattern = Pattern.compile("/boxTable/.+");
    private static final Logger log = Logger.getLogger("webChart");
    private static final Version version = new Version("1");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block16: {
            resp.setHeader("transfer-encoding", "chunked");
            try {
                Context cx = (Context)req.getAttribute("niagara.context");
                RestUtil util = new RestUtil(req, resp);
                if (!util.acceptJson()) {
                    resp.sendError(406);
                    return;
                }
                RestUtil.Accept accept = util.getJsonAccept();
                if (!(!accept.isCustomMediaType() || accept.getCustomProtocol().equals("webChart") && accept.getCustomVersion().equals((Object)version))) {
                    resp.sendError(406);
                    return;
                }
                if (util.matches(dataPattern) || util.matches(schedulePattern)) {
                    util.respond(accept, "text/plain").respondNoCache();
                } else {
                    util.respond(accept, "application/json").respondNoCache();
                }
                Writer writer = null;
                if (util.matches(dataPattern)) {
                    String escapedOrd = util.get(1);
                    BOrd ord = BOrd.make((String)SlotPath.unescape((String)escapedOrd)).relativizeToSession().normalize();
                    if (ord == null) {
                        resp.sendError(404);
                        return;
                    }
                    writer = this.getWriter(resp);
                    this.encodeHistoryData(writer, ord, cx);
                } else if (util.matches(schedulePattern)) {
                    String escapedOrd = util.get(1);
                    BOrd ord = BOrd.make((String)SlotPath.unescape((String)escapedOrd)).relativizeToSession().normalize();
                    ViewQuery viewQuery = ord.resolve().getViewQuery();
                    BAbsTime end = BAbsTime.now();
                    BAbsTime start = BAbsTime.make((int)end.getYear(), (BMonth)end.getMonth(), (int)end.getDay());
                    BAbsTimeRange range = WebChartUtil.getAbsTimeRangeFromViewOrd(viewQuery, start, end);
                    OrdTarget target = ord.resolve(null, cx);
                    if (!target.canRead()) {
                        resp.sendError(404);
                    }
                    BControlSchedule schedule = (BControlSchedule)target.get();
                    writer = this.getWriter(resp);
                    this.encodeSchedule(writer, schedule, range.getStartTime(), range.getEndTime(), cx);
                } else if (util.matches(boxTablePattern)) {
                    String escapedOrd = util.get(1);
                    BOrd ord = BOrd.make((String)SlotPath.unescape((String)escapedOrd)).relativizeToSession().normalize();
                    ViewQuery viewQuery = ord.resolve().getViewQuery();
                    BAbsTime end = BAbsTime.DEFAULT;
                    BAbsTime start = BAbsTime.DEFAULT;
                    BAbsTimeRange range = WebChartUtil.getAbsTimeRangeFromViewOrd(viewQuery, start, end);
                    OrdTarget target = ord.resolve(null, cx);
                    if (!target.canRead()) {
                        resp.sendError(404);
                    }
                    BITable dataTable = (BITable)target.get();
                    writer = this.getWriter(resp);
                    this.encodeTableData(writer, dataTable, range.getStartTime(), range.getEndTime(), cx);
                } else {
                    resp.sendError(404);
                }
            }
            catch (Exception e) {
                if (WebUtil.isAbortException((Throwable)e)) {
                    log.log(Level.FINE, "Connection Aborted", e);
                    return;
                }
                log.log(Level.SEVERE, "ServletException", e);
                if (e instanceof ServletException || e instanceof IOException) break block16;
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeHistoryData(Writer out, BOrd ord, Context cx) throws Exception {
        boolean needPreAndPostRecord;
        OrdTarget target = ord.resolve(null, cx);
        if (!target.canRead()) {
            throw new PermissionException();
        }
        BObject historyObject = target.get();
        Cursor<BHistoryRecord> historyCursor = this.retrieveHistoryEntries(historyObject);
        BFacets cursorFacets = null;
        Context cursorContext = historyCursor.getContext();
        boolean bl = needPreAndPostRecord = !(historyObject instanceof BHistoryDeltaQuery);
        if (cursorContext != null && needPreAndPostRecord) {
            cursorFacets = cursorContext.getFacets();
        }
        try {
            BHistoryRecord postRecord;
            JSONWriter json;
            BHistoryRecord preRecord;
            boolean isFirstLineWritten = false;
            if (cursorFacets != null && (preRecord = HistoryCursor.extractPreRecord((BFacets)cursorFacets)) != null) {
                json = QuickJSONWriter.make((Appendable)out);
                WebChartUtil.encodeMinifiedHistoryRecord(json, preRecord, cx);
                isFirstLineWritten = true;
            }
            while (historyCursor.next()) {
                if (!isFirstLineWritten) {
                    isFirstLineWritten = true;
                } else {
                    out.append('\n');
                }
                JSONWriter json2 = QuickJSONWriter.make((Appendable)out);
                WebChartUtil.encodeMinifiedHistoryRecord(json2, (BHistoryRecord)historyCursor.get(), cx);
            }
            if (cursorFacets != null && needPreAndPostRecord && (postRecord = HistoryCursor.extractPostRecord((BFacets)cursorFacets)) != null) {
                if (isFirstLineWritten) {
                    out.append('\n');
                }
                json = QuickJSONWriter.make((Appendable)out);
                WebChartUtil.encodeMinifiedHistoryRecord(json, postRecord, cx);
            }
        }
        finally {
            historyCursor.close();
        }
    }

    private Cursor<BHistoryRecord> retrieveHistoryEntries(BObject o) throws Exception {
        if (o instanceof BIHistory) {
            BLocalHistoryDatabase db = new BLocalHistoryDatabase((BHistoryService)null);
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                Cursor cursor = conn.scan((BIHistory)o);
                return cursor;
            }
        }
        if (o instanceof BHistoryTimeQuery) {
            return ((BHistoryTimeQuery)o).cursor();
        }
        if (o instanceof BHistoryDeltaQuery) {
            return ((BHistoryDeltaQuery)o).cursor();
        }
        throw new Exception("servlet not available for history of type " + o.getType());
    }

    public void encodeScheduleEntry(JSONWriter out, BAbsTime time, BValue value, Context cx) throws Exception {
        BStatusValue statusValue = (BStatusValue)value;
        WebChartUtil.encodeMinifiedEntry(out, time, statusValue.getValueValue(), null, statusValue.getStatus(), cx);
    }

    public void encodeSchedule(Writer writer, BControlSchedule schedule, BAbsTime start, BAbsTime end, Context cx) throws Exception {
        JSONWriter json = QuickJSONWriter.make((Appendable)writer);
        this.encodeScheduleEntry(json, start, (BValue)schedule.getOutput(start), cx);
        writer.append('\n');
        BAbsTime time = start;
        while (time != null && time.isBefore(end)) {
            if ((time = schedule.nextEvent(time)) == null || !time.isBefore(end)) continue;
            json = QuickJSONWriter.make((Appendable)writer);
            this.encodeScheduleEntry(json, time, (BValue)schedule.getOutput(time), cx);
            writer.append('\n');
        }
        json = QuickJSONWriter.make((Appendable)writer);
        this.encodeScheduleEntry(json, end, (BValue)schedule.getOutput(end), cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeTableData(Writer out, BITable<?> table, BAbsTime start, BAbsTime end, Context cx) throws Exception {
        Column timestamp = table.getColumns().get("timestamp");
        Column value = table.getColumns().get("value");
        try (TableCursor cursor = table.cursor();){
            boolean first = false;
            boolean skip = false;
            while (cursor.next()) {
                if (!skip) {
                    if (!first) {
                        first = true;
                    } else {
                        out.append('\n');
                    }
                }
                JSONWriter json = QuickJSONWriter.make((Appendable)out);
                Object entry = cursor.get();
                boolean used = false;
                if (entry instanceof Row) {
                    Row row = (Row)entry;
                    skip = !WebChartUtil.encodeMinifiedGenericValueRecord(json, (BAbsTime)row.cell(timestamp), (BValue)row.cell(value), null, null, start, end, cx);
                    used = true;
                } else if (entry instanceof BComponent) {
                    BComponent c = (BComponent)entry;
                    BValue t = c.get("timestamp");
                    BValue v = c.get("value");
                    if (t instanceof BAbsTime && v instanceof BValue) {
                        BAbsTime timestampValue = (BAbsTime)t;
                        skip = !WebChartUtil.encodeMinifiedGenericValueRecord(json, timestampValue, v, null, null, start, end, cx);
                        used = true;
                    }
                }
                if (used) continue;
                throw new IllegalStateException("Cursor.get() must return a javax.baja.collection.Row or javax.baja.sys.BComponent with timestamp and value properties: " + entry.getClass());
            }
        }
    }

    private Writer getWriter(HttpServletResponse resp) throws IOException {
        return resp.getWriter();
    }
}

