/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.point;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import com.tridium.aapup.messages.PupWriteAttributeMessage;
import com.tridium.aapup.messages.PupWriteTextAttributeMessage;
import com.tridium.aapup.point.BPupProxyExt;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPupStringProxyExt
extends BPupProxyExt
implements AaPupConst {
    public static final Type TYPE = Sys.loadType(BPupStringProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BStringPoint;
    }

    @Override
    public void setValue(PupResponse rsp) {
        BString value;
        if (rsp instanceof PupNumericDataResponse) {
            PupNumericDataResponse numRsp = (PupNumericDataResponse)rsp;
            value = numRsp.getString();
            this.setAttributeValue(numRsp.getString().getString());
        } else if (rsp instanceof PupTextDataResponse) {
            PupTextDataResponse txtRsp = (PupTextDataResponse)rsp;
            value = txtRsp.getString();
            this.setAttributeValue(value.getString());
        } else {
            this.readFail("message type incorrect");
            return;
        }
        BStatusString bv = (BStatusString)this.getReadValue().newCopy();
        bv.setValue(value.getString());
        this.readOk((BStatusValue)bv);
    }

    @Override
    boolean updateOutput(BStatusValue out) {
        PupResponse rsp;
        if (!this.prewriteAttribute()) {
            this.writeFail("unable to set override or manual");
            return false;
        }
        String dataOut = "";
        if (!(out instanceof BStatusString)) {
            this.writeFail("attempt to write string data to non-string point");
            return false;
        }
        dataOut = ((BStatusString)out).getValue();
        if (this.getAttributeType() == 223 || this.getAttributeType() == 256) {
            BStatusString pointValue = (BStatusString)this.getParentPoint().getOutStatusValue();
            if (dataOut.equals(pointValue.getValue())) {
                return true;
            }
            PupWriteTextAttributeMessage txtMsg = new PupWriteTextAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), dataOut);
            rsp = (PupResponse)this.pupNetwork().sendSync(txtMsg);
        } else {
            double numericData;
            try {
                numericData = this.convertStringToNumeric(dataOut);
            }
            catch (NumberFormatException e) {
                this.writeFail("cannot convert string to number");
                return false;
            }
            PupWriteAttributeMessage attMsg = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), numericData);
            rsp = (PupResponse)this.pupNetwork().sendSync(attMsg);
        }
        if (!this.isValidWriteResponse(rsp)) {
            return false;
        }
        if (rsp instanceof PupAckResponse) {
            this.getPupLog().fine("Write Succeeded on " + this);
            this.writeOk(out);
            return true;
        }
        if (rsp instanceof PupErrorResponse) {
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            this.getPupLog().fine("Received error response writing " + this);
            this.writeFail(errRsp.getError());
            return false;
        }
        this.getPupLog().fine("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }

    private double convertStringToNumeric(String dataOut) throws NumberFormatException {
        try {
            return Integer.parseInt(dataOut);
        }
        catch (NumberFormatException e) {
            try {
                return Integer.parseInt(dataOut, 16);
            }
            catch (NumberFormatException f) {
                try {
                    return Double.parseDouble(dataOut);
                }
                catch (NumberFormatException g) {
                    return Float.parseFloat(dataOut);
                }
            }
        }
    }
}

