/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.point;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.PupException;
import com.tridium.aapup.enums.BPupPrewriteAttributeEnum;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupReadAttributeMessage;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import com.tridium.aapup.messages.PupWriteAttributeMessage;
import com.tridium.aapup.point.BCvOverrideAction;
import com.tridium.aapup.point.BCvResetOverrideAction;
import com.tridium.aapup.point.BPupPointDeviceExt;
import com.tridium.aapup.point.BSetDateAction;
import com.tridium.aapup.point.BSetTimeAction;
import com.tridium.aapup.point.CvOverrideRequest;
import com.tridium.aapup.point.SetDateRequest;
import com.tridium.aapup.point.SetTimeRequest;
import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BPupProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
AaPupConst {
    public static final Property channel = BPupProxyExt.newProperty((int)0, (int)-1, (BFacets)BFacets.makeInt(null, (int)0, (int)65535, (int)16));
    public static final Property channelDescription = BPupProxyExt.newProperty((int)0, (String)"", null);
    public static final Property attribute = BPupProxyExt.newProperty((int)0, (String)"??", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property attributeType = BPupProxyExt.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property attributeValue = BPupProxyExt.newProperty((int)3, (String)"", null);
    public static final Property pollFrequency = BPupProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property prewriteAttribute = BPupProxyExt.newProperty((int)4, (BValue)BPupPrewriteAttributeEnum.none, null);
    public static final Action forceRead = BPupProxyExt.newAction((int)0, null);
    public static final Action forceWrite = BPupProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPupProxyExt.class);
    private boolean overriddenState = false;

    public int getChannel() {
        return this.getInt(channel);
    }

    public void setChannel(int v) {
        this.setInt(channel, v, null);
    }

    public String getChannelDescription() {
        return this.getString(channelDescription);
    }

    public void setChannelDescription(String v) {
        this.setString(channelDescription, v, null);
    }

    public String getAttribute() {
        return this.getString(attribute);
    }

    public void setAttribute(String v) {
        this.setString(attribute, v, null);
    }

    public int getAttributeType() {
        return this.getInt(attributeType);
    }

    public void setAttributeType(int v) {
        this.setInt(attributeType, v, null);
    }

    public String getAttributeValue() {
        return this.getString(attributeValue);
    }

    public void setAttributeValue(String v) {
        this.setString(attributeValue, v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public BPupPrewriteAttributeEnum getPrewriteAttribute() {
        return (BPupPrewriteAttributeEnum)this.get(prewriteAttribute);
    }

    public void setPrewriteAttribute(BPupPrewriteAttributeEnum v) {
        this.set(prewriteAttribute, (BValue)v, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkCvOverrideAction();
        this.checkTimeAction();
        this.checkDateAction();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(prewriteAttribute)) {
            this.checkCvOverrideAction();
        }
        if (p.equals(channel) || p.equals(attribute)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
            this.checkTimeAction();
            this.checkDateAction();
            this.checkCvOverrideAction();
            this.forceRead();
        }
    }

    public void doForceRead() {
        this.pupNetwork().postAsync(new Runnable(){

            @Override
            public void run() {
                BPupProxyExt.this.poll();
            }
        });
    }

    public void doForceWrite() {
        try {
            this.write(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Type getDeviceExtType() {
        return BPupPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void doWrite(BStatusValue out) {
        if (out == null) {
            this.updateOutput(this.getWriteValue());
        } else {
            this.updateOutput(out);
        }
        if (this.getParentPoint().isSubscribed()) {
            this.poll();
        }
    }

    abstract boolean updateOutput(BStatusValue var1);

    boolean prewriteAttribute() {
        if (!this.getPrewriteAttribute().prewriteRequired()) {
            return true;
        }
        String attribute = this.getPrewriteAttribute().getAttribute();
        double dataOut = this.getPrewriteAttribute().getMakeWritableValue();
        PupWriteAttributeMessage msg = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), attribute, 254, dataOut);
        PupResponse rsp = (PupResponse)this.pupNetwork().sendSync(msg);
        if (rsp == null) {
            return false;
        }
        if (!rsp.getIn().verifyChecksum()) {
            return false;
        }
        if (rsp.getIn().getUnitNumber() != this.pupDevice().getUnitNumber()) {
            return false;
        }
        if (rsp instanceof PupAckResponse) {
            this.getPupLog().fine("preWrite Succeeded on " + this);
            return true;
        }
        return false;
    }

    public void poll() {
        this.getPupLog().fine("poll " + this.getParent().getName() + ":" + this);
        if (!this.isValid()) {
            return;
        }
        if (this.getAttribute().equalsIgnoreCase("CV") & this.getPrewriteAttribute().prewriteRequired()) {
            try {
                this.overriddenState = this.discoverOverriddenState();
            }
            catch (PupException e) {
                this.getPupLog().fine("error discovering override state on " + this + ":" + e.getMessage());
                this.readFail("could not determine override state");
            }
        } else {
            this.overriddenState = false;
        }
        PupReadAttributeMessage msg = new PupReadAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute());
        PupResponse rsp = (PupResponse)this.pupDevice().pupNetwork().sendSync(msg);
        if (!this.isValidReadResponse(rsp)) {
            return;
        }
        if (rsp instanceof PupNumericDataResponse) {
            PupNumericDataResponse dataRsp = (PupNumericDataResponse)rsp;
            if (dataRsp.getAttributeName().equalsIgnoreCase(this.getAttribute().trim())) {
                this.getPupLog().fine("Read Succeeded!");
                this.setValue(rsp);
                this.setAttributeType(dataRsp.getDataType());
            } else {
                this.readFail("Polled for " + this.getAttribute() + " but received " + dataRsp.getAttributeName());
            }
            return;
        }
        if (rsp instanceof PupTextDataResponse) {
            PupTextDataResponse textRsp = (PupTextDataResponse)rsp;
            if (textRsp.getAttributeName().equalsIgnoreCase(this.getAttribute().trim())) {
                this.getPupLog().fine("Read Succeeded!");
                this.setValue(rsp);
                this.setAttributeType(256);
            } else {
                this.readFail("Polled for " + this.getAttribute() + " but received " + textRsp.getAttributeName());
            }
            return;
        }
        if (rsp instanceof PupErrorResponse) {
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            this.getPupLog().fine("Received error response polling " + this);
            this.readFail(errRsp.getError());
            return;
        }
        this.getPupLog().fine("Received invalid message type polling " + this);
        this.readFail("invalid message type");
    }

    boolean isValidReadResponse(PupResponse rsp) {
        if (rsp == null) {
            this.getPupLog().fine("Read Failed - no response polling " + this);
            this.readFail("No Response");
            this.pupDevice().ping();
            return false;
        }
        if (!rsp.getIn().verifyChecksum()) {
            this.getPupLog().fine("Checksum Error polling " + this);
            this.readFail("Bad Checksum");
            return false;
        }
        if (rsp.getIn().getUnitNumber() != this.pupDevice().getUnitNumber()) {
            this.getPupLog().fine("response address not same as requested address " + this);
            this.readFail("response address not same as requested address");
            return false;
        }
        return true;
    }

    boolean isValidWriteResponse(PupResponse rsp) {
        if (rsp == null) {
            this.writeFail("device time out");
            this.pupDevice().ping();
            return false;
        }
        if (!rsp.getIn().verifyChecksum()) {
            this.getPupLog().fine("Checksum Error writing " + this);
            this.writeFail("Bad Checksum");
            return false;
        }
        if (rsp.getIn().getUnitNumber() != this.pupDevice().getUnitNumber()) {
            this.getPupLog().fine("response address not same as requested address " + this);
            this.writeFail("response address not same as requested address");
            return false;
        }
        return true;
    }

    private boolean discoverOverriddenState() throws PupException {
        PupReadAttributeMessage msg = new PupReadAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getPrewriteAttribute().getAttribute());
        PupResponse rsp = (PupResponse)this.pupDevice().pupNetwork().sendSync(msg);
        if (rsp == null) {
            throw new PupException("device time out");
        }
        if (!rsp.getIn().verifyChecksum()) {
            throw new PupException("Bad Checksum reading override state");
        }
        if (rsp.getIn().getUnitNumber() != this.pupDevice().getUnitNumber()) {
            throw new PupException("response address not same as requested address");
        }
        if (rsp instanceof PupNumericDataResponse) {
            this.getPupLog().fine("Read Succeeded!");
            PupNumericDataResponse dataRsp = (PupNumericDataResponse)rsp;
            return this.getPrewriteAttribute().isOverridden(dataRsp.getBoolean().getBoolean());
        }
        if (rsp instanceof PupErrorResponse) {
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            throw new PupException("Error response reading override:" + errRsp.getError());
        }
        throw new PupException("invalid message type reading override");
    }

    public abstract void setValue(PupResponse var1);

    public BPupNetwork pupNetwork() {
        return (BPupNetwork)this.getNetwork();
    }

    public BPupDevice pupDevice() {
        return (BPupDevice)this.getDevice();
    }

    public final void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"PupProxyExt", 2);
        out.prop((Object)"isValid", this.isValid());
        this.pupspy(out);
        out.endProps();
    }

    public void pupspy(SpyWriter out) throws Exception {
    }

    boolean isValid() {
        return this.getChannel() != -1 && this.getAttribute() != "??";
    }

    Logger getPupLog() {
        try {
            return this.pupNetwork().getPupLog();
        }
        catch (Exception e) {
            return Logger.getLogger("pup.x");
        }
    }

    private void checkTimeAction() {
        BSetTimeAction[] a = (BSetTimeAction[])this.getParentPoint().getChildren(BSetTimeAction.class);
        switch (this.getAttributeType()) {
            case 230: 
            case 231: {
                if (a.length == 0) {
                    BSetTimeAction setpt = new BSetTimeAction();
                    this.getParentPoint().add("AdjustTime", (BValue)setpt, 2);
                }
                return;
            }
        }
        for (int i = 0; i < a.length; ++i) {
            this.getParentPoint().remove((BComplex)a[i]);
        }
    }

    public void setTimeAttribute(BValue arg, Context cx) {
        if (arg instanceof BTime) {
            this.getPupLog().fine("Set Time Attribute on " + this + ":value=" + arg);
            switch (this.getAttributeType()) {
                case 230: 
                case 231: {
                    this.pupNetwork().postWrite(new SetTimeRequest(this, (BTime)arg));
                    return;
                }
            }
            return;
        }
    }

    public boolean setTimeAttribute(BTime outTime) {
        System.out.println("setTimeAttribute:" + outTime + " " + outTime.getHour() + ":" + outTime.getMinute() + ":" + outTime.getSecond());
        this.getPupLog().fine("setTimeAttribute:" + outTime + " " + outTime.getHour() + ":" + outTime.getMinute() + ":" + outTime.getSecond());
        int seconds = outTime.getHour() * 3600 + outTime.getMinute() * 60 + outTime.getSecond();
        PupWriteAttributeMessage msg = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), seconds);
        PupResponse rsp = (PupResponse)this.pupNetwork().sendSync(msg);
        if (!this.isValidWriteResponse(rsp)) {
            return false;
        }
        if (rsp instanceof PupAckResponse) {
            this.getPupLog().fine("Write Succeeded on " + this);
            this.writeOk((BStatusValue)new BStatusString(outTime.toString(null)));
            return true;
        }
        if (rsp instanceof PupErrorResponse) {
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            this.getPupLog().fine("Received error response writing " + this);
            this.writeFail(errRsp.getError());
            return false;
        }
        this.getPupLog().fine("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }

    private void checkDateAction() {
        BSetDateAction[] a = (BSetDateAction[])this.getParentPoint().getChildren(BSetDateAction.class);
        switch (this.getAttributeType()) {
            case 227: 
            case 228: {
                if (a.length == 0) {
                    BSetDateAction setpt = new BSetDateAction();
                    this.getParentPoint().add("AdjustDate", (BValue)setpt, 2);
                }
                return;
            }
        }
        for (int i = 0; i < a.length; ++i) {
            this.getParentPoint().remove((BComplex)a[i]);
        }
    }

    public void setDateAttribute(BValue arg, Context cx) {
        if (arg instanceof BAbsTime) {
            this.getPupLog().fine("Set Date Attribute on " + this + ":value=" + (BAbsTime)arg);
            switch (this.getAttributeType()) {
                case 227: 
                case 228: {
                    this.pupNetwork().postWrite(new SetDateRequest(this, (BAbsTime)arg));
                    return;
                }
            }
            return;
        }
    }

    public boolean setDateAttribute(BAbsTime outTime) {
        PupWriteAttributeMessage msg = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), outTime);
        PupResponse rsp = (PupResponse)this.pupNetwork().sendSync(msg);
        if (!this.isValidWriteResponse(rsp)) {
            return false;
        }
        if (rsp instanceof PupAckResponse) {
            this.getPupLog().fine("Write Succeeded on " + this);
            this.writeOk((BStatusValue)new BStatusString(outTime.toString(null)));
            return true;
        }
        if (rsp instanceof PupErrorResponse) {
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            this.getPupLog().fine("Received error response writing " + this);
            this.writeFail(errRsp.getError());
            return false;
        }
        this.getPupLog().fine("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }

    private void checkCvOverrideAction() {
        if (this.getAttribute().equals("CV") && !this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)prewriteAttribute, this.getFlags((Slot)prewriteAttribute) & 0xFFFFFFFB);
        }
        BCvOverrideAction[] a = (BCvOverrideAction[])this.getParentPoint().getChildren(BCvOverrideAction.class);
        BCvResetOverrideAction[] b = (BCvResetOverrideAction[])this.getParentPoint().getChildren(BCvResetOverrideAction.class);
        for (int i = 0; i < a.length; ++i) {
            this.getParentPoint().remove((BComplex)a[i]);
        }
        for (int j = 0; j < b.length; ++j) {
            this.getParentPoint().remove((BComplex)b[j]);
        }
        if (!this.getParentPoint().isWritablePoint() && this.getAttribute().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            if (a.length == 0) {
                BCvOverrideAction setpt = new BCvOverrideAction();
                setpt.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
                if (this.getPrewriteAttribute().getAttribute().equals("OI")) {
                    this.getParentPoint().add("Override", (BValue)setpt, 2);
                } else {
                    this.getParentPoint().add("Manual", (BValue)setpt, 2);
                }
            }
            if (b.length == 0) {
                BCvResetOverrideAction resetpt = new BCvResetOverrideAction();
                if (this.getPrewriteAttribute().getAttribute().equals("OI")) {
                    this.getParentPoint().add("CancelOverride", (BValue)resetpt, 2);
                } else {
                    this.getParentPoint().add("Auto", (BValue)resetpt, 2);
                }
            }
        }
    }

    public void setCvOverride(BValue arg, Context cx) {
        this.getPupLog().fine("Set CV override on " + this + ":value=" + arg);
        if (!this.getParentPoint().isWritablePoint() && this.getAttribute().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            this.pupNetwork().postWrite(new CvOverrideRequest(this, arg));
        }
    }

    public void resetCvOverride(BValue arg, Context cx) {
        this.getPupLog().fine("Reset CV override on " + this);
        if (!this.getParentPoint().isWritablePoint() && this.getAttribute().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            this.pupNetwork().postAsync(new Runnable(){

                @Override
                public void run() {
                    PupWriteAttributeMessage msg = new PupWriteAttributeMessage(BPupProxyExt.this.pupDevice().getUnitNumber(), BPupProxyExt.this.getChannel(), BPupProxyExt.this.getPrewriteAttribute().getAttribute(), 254, BPupProxyExt.this.getPrewriteAttribute().getMakeUnwritableValue());
                    PupResponse rsp = (PupResponse)BPupProxyExt.this.pupNetwork().sendSync(msg);
                    if (!BPupProxyExt.this.isValidWriteResponse(rsp)) {
                        return;
                    }
                    if (rsp instanceof PupAckResponse) {
                        return;
                    }
                    if (rsp instanceof PupErrorResponse) {
                        PupErrorResponse errRsp = (PupErrorResponse)rsp;
                        BPupProxyExt.this.getPupLog().fine("Received error response while clearing override on " + this);
                        BPupProxyExt.this.writeFail("error response while clearing override:" + errRsp.getError());
                        return;
                    }
                    BPupProxyExt.this.getPupLog().fine("Received invalid message type while clearing " + this);
                    BPupProxyExt.this.writeFail("invalid response while clearing override");
                }
            });
        }
    }

    public boolean getOverriddenState() {
        return this.overriddenState;
    }
}

