/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.point;

import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import com.tridium.aapup.messages.PupWriteAttributeMessage;
import com.tridium.aapup.point.BPupProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPupNumericProxyExt
extends BPupProxyExt {
    public static final Type TYPE = Sys.loadType(BPupNumericProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNumericPoint;
    }

    @Override
    public void setValue(PupResponse rsp) {
        BDouble value;
        if (rsp instanceof PupNumericDataResponse) {
            PupNumericDataResponse numRsp = (PupNumericDataResponse)rsp;
            value = numRsp.getDouble();
            this.setAttributeValue(numRsp.getString().getString());
        } else if (rsp instanceof PupTextDataResponse) {
            PupTextDataResponse txtRsp = (PupTextDataResponse)rsp;
            value = txtRsp.getDouble();
            this.setAttributeValue(txtRsp.getString().getString());
        } else {
            this.readFail("message type incorrect");
            return;
        }
        BStatusNumeric nv = new BStatusNumeric(value.getDouble(), BStatus.makeOverridden((BStatus)this.getReadValue().getStatus(), (boolean)this.getOverriddenState()));
        this.readOk((BStatusValue)nv);
    }

    @Override
    boolean updateOutput(BStatusValue out) {
        if (!this.prewriteAttribute()) {
            this.writeFail("unable to set override or manual");
            return false;
        }
        double dataOut = Double.NaN;
        if (!(out instanceof BStatusNumeric)) {
            this.writeFail("attempt to write non-numeric data to numeric point");
            return false;
        }
        dataOut = ((BStatusNumeric)out).getValue();
        PupWriteAttributeMessage msg = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), dataOut);
        PupResponse rsp = (PupResponse)this.pupNetwork().sendSync(msg);
        if (!this.isValidWriteResponse(rsp)) {
            return false;
        }
        if (rsp instanceof PupAckResponse) {
            this.getPupLog().fine("Write Succeeded on " + this);
            this.writeOk(out);
            return true;
        }
        if (rsp instanceof PupErrorResponse) {
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            this.getPupLog().fine("Received error response writing " + this);
            this.writeFail(errRsp.getError());
            return false;
        }
        this.getPupLog().fine("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }
}

