/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.sys.BAbsTime;

public class PupWriteAttributeMessage
extends PupMessage
implements AaPupConst {
    private int channel;
    private String attribute;
    private int attributeType;
    private double data;
    private int[] outData = new int[]{0, 0, 0, 0};
    private BAbsTime timedata;

    public PupWriteAttributeMessage(int targetUnitNumber, int channel, String attribute, int attributeType, double data) {
        super(targetUnitNumber);
        this.channel = channel;
        this.attribute = attribute;
        this.attributeType = attributeType;
        this.data = data;
    }

    public PupWriteAttributeMessage(int targetUnitNumber, int channel, String attribute, int attributeType, BAbsTime timedata) {
        super(targetUnitNumber);
        this.channel = channel;
        this.attribute = attribute;
        this.attributeType = attributeType;
        this.timedata = timedata;
    }

    public PupWriteAttributeMessage(int targetUnitNumber, int channel, String attribute, int attributeType, boolean bdata) {
        super(targetUnitNumber);
        this.channel = channel;
        this.attribute = attribute;
        this.attributeType = attributeType;
        this.data = bdata ? 1.0 : 0.0;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute.substring(0, 2);
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(13);
        out.write(2);
        out.writeInt(this.channel);
        out.writeAttribute(this.attribute, false, false);
        this.convertData();
        for (int i = 0; i < 4; ++i) {
            out.write(this.outData[i]);
        }
    }

    public void convertData() {
        switch (this.attributeType) {
            case 255: {
                this.convert(this.data);
                return;
            }
            case 254: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data);
                return;
            }
            case 253: {
                this.convert(this.data * 10.0);
                return;
            }
            case 252: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 10.0);
                return;
            }
            case 251: {
                this.convert(this.data * 100.0);
                return;
            }
            case 250: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 100.0);
                return;
            }
            case 249: {
                this.convert(this.data * 1000.0);
                return;
            }
            case 248: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1000.0);
                return;
            }
            case 247: {
                this.convert(this.data * 10000.0);
                return;
            }
            case 246: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 10000.0);
                return;
            }
            case 245: {
                this.convert(this.data * 100000.0);
                return;
            }
            case 244: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 100000.0);
                return;
            }
            case 243: {
                this.convert(this.data * 1000000.0);
                return;
            }
            case 242: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1000000.0);
                return;
            }
            case 241: {
                this.convert(this.data * 1.0E7);
                return;
            }
            case 240: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1.0E7);
                return;
            }
            case 239: {
                this.convert(this.data * 1.0E8);
                return;
            }
            case 238: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1.0E8);
                return;
            }
            case 237: {
                this.convert(this.data * 1.0E9);
                return;
            }
            case 236: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1.0E9);
                return;
            }
            case 235: {
                this.convert(this.data * 1.0E10);
                return;
            }
            case 234: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1.0E10);
                return;
            }
            case 232: 
            case 233: {
                this.convert(this.data);
                return;
            }
            case 231: {
                long hmsData = (long)this.data;
                this.outData[0] = (int)(hmsData / 3600L) / 10 << 4 | (int)(hmsData / 3600L) % 10;
                this.outData[1] = (int)(hmsData % 3600L / 60L) / 10 << 4 | (int)(hmsData % 3600L / 60L) % 10;
                this.outData[2] = (int)(hmsData % 3600L % 60L) / 10 << 4 | (int)(hmsData % 3600L % 60L) % 10;
                this.outData[3] = 0;
                return;
            }
            case 230: {
                long hmData = (long)this.data;
                this.outData[0] = (int)(hmData / 3600L) / 10 << 4 | (int)(hmData / 3600L) % 10;
                this.outData[1] = (int)(hmData % 3600L / 60L) / 10 << 4 | (int)(hmData % 3600L / 60L) % 10;
                this.outData[2] = 0;
                this.outData[3] = 0;
                return;
            }
            case 229: {
                long pTmp = (long)this.data;
                this.outData[0] = (int)(pTmp % 10L) | (int)(pTmp / 10L % 10L << 4);
                this.outData[1] = (int)(pTmp / 100L % 10L) | (int)(pTmp / 1000L % 10L << 4);
                this.outData[2] = (int)(pTmp / 10000L % 10L) | (int)(pTmp / 100000L % 10L << 4);
                this.outData[3] = (int)(pTmp / 1000000L % 10L) | (int)(pTmp / 10000000L % 10L << 4);
                return;
            }
            case 228: {
                if (this.timedata == null) {
                    this.outData[3] = 0;
                    this.outData[2] = 0;
                    this.outData[1] = 0;
                    this.outData[0] = 0;
                }
                int year = this.timedata.getYear();
                int month = this.timedata.getMonth().getOrdinal() + 1;
                int day = this.timedata.getDay();
                this.outData[0] = day % 10 | day / 10 << 4;
                this.outData[1] = month % 10 | month / 10 << 4;
                this.outData[2] = year % 10 | year / 10 % 10 << 4;
                this.outData[3] = year / 100 % 10 | year / 1000 << 4;
                return;
            }
            case 227: {
                if (this.timedata == null) {
                    this.outData[3] = 0;
                    this.outData[2] = 0;
                    this.outData[1] = 0;
                    this.outData[0] = 0;
                }
                int byear = this.timedata.getYear();
                int bmonth = this.timedata.getMonth().getOrdinal() + 1;
                int bday = this.timedata.getDay();
                this.outData[0] = bday & 0xFF;
                this.outData[1] = bmonth & 0xFF;
                this.outData[2] = byear & 0xFF;
                this.outData[3] = (byear & 0xFF00) >>> 8;
                return;
            }
            case 224: {
                int intBits = Float.floatToIntBits((float)this.data);
                this.outData[0] = intBits & 0xFF;
                this.outData[1] = intBits >>> 8 & 0xFF;
                this.outData[2] = intBits >>> 16 & 0xFF;
                this.outData[3] = intBits >>> 24 & 0xFF;
                return;
            }
            case 223: {
                this.outData[0] = 32;
                this.outData[1] = 32;
                this.outData[2] = 32;
                this.outData[3] = 32;
                return;
            }
        }
    }

    private void convert(double ddata) {
        long longbase = (long)ddata;
        this.outData[0] = (int)(longbase & 0xFFL);
        this.outData[1] = (int)(longbase >>> 8) & 0xFF;
        this.outData[2] = (int)(longbase >>> 16) & 0xFF;
        this.outData[3] = (int)(longbase >>> 24) & 0xFF;
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -127) {
            return new PupAckResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupWriteAttributeMessage::unit:" + this.unitNumber + " [" + this.channel + ":" + this.attribute + "]";
    }
}

