/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.InvalidEnumException;
import javax.baja.util.Lexicon;

public class PupTextDataResponse
extends PupResponse
implements AaPupConst {
    String attributeName = this.getIn().readAttributeName();
    String text = this.getIn().readText();
    private static Lexicon lex = Lexicon.make((String)"aapup");

    public PupTextDataResponse(PupReceivedMessage msg) {
        super(msg);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getText() {
        return this.text;
    }

    public boolean isFirst() {
        return this.getIn().isFirst();
    }

    public boolean isLast() {
        return this.getIn().isLast();
    }

    public boolean onlyAttribute() {
        return this.getIn().isFirst() & this.getIn().isLast();
    }

    public BDouble getDouble() {
        try {
            Long aLong = Long.valueOf(this.text);
            return BDouble.make((double)aLong.doubleValue());
        }
        catch (NumberFormatException e) {
            try {
                double aDouble = Double.parseDouble(this.text);
                return BDouble.make((double)aDouble);
            }
            catch (NumberFormatException numberFormatException) {
                return BDouble.make((double)Double.NaN);
            }
        }
    }

    public BBoolean getBoolean(BFacets facets) {
        if (facets != null) {
            BString trueText = (BString)facets.get("trueText");
            BString falseText = (BString)facets.get("falseText");
            if (trueText != null && falseText != null) {
                if (this.text.equalsIgnoreCase(trueText.getString())) {
                    return BBoolean.TRUE;
                }
                if (this.text.equalsIgnoreCase(falseText.getString())) {
                    return BBoolean.FALSE;
                }
            }
        }
        if (lex.getText("point.boolean.define." + this.text) == "1") {
            return BBoolean.TRUE;
        }
        if (lex.getText("point.boolean.define." + this.text) == "0") {
            return BBoolean.FALSE;
        }
        if (this.text.equalsIgnoreCase("true")) {
            return BBoolean.TRUE;
        }
        if (this.text.equalsIgnoreCase("one")) {
            return BBoolean.TRUE;
        }
        if (this.text.equalsIgnoreCase("1")) {
            return BBoolean.TRUE;
        }
        if (this.text.equalsIgnoreCase("positive")) {
            return BBoolean.TRUE;
        }
        if (this.text.equalsIgnoreCase("on")) {
            return BBoolean.TRUE;
        }
        return BBoolean.FALSE;
    }

    public BEnum getEnum(BFacets facets) {
        if (facets != null) {
            BEnum myEnum;
            BEnumRange range = (BEnumRange)facets.get("range");
            try {
                myEnum = range.get(this.text);
            }
            catch (InvalidEnumException e) {
                BDouble textAsDouble = this.getDouble();
                if (textAsDouble.getDouble() == Double.NaN) {
                    return null;
                }
                return range.get((int)textAsDouble.getDouble());
            }
            return myEnum;
        }
        return null;
    }

    public BString getString() {
        return BString.make((String)this.text);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PupAckResponse:() from " + this.getIn().getUnitNumber() + "\n").append("  attributeName:" + this.attributeName + "\n").append("     is first attribute:" + this.isFirst()).append("     is last attribute :" + this.isLast()).append("  text         :" + this.text);
        return sb.toString();
    }
}

