/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupInputStream;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.nre.util.ByteArrayUtil;

public abstract class PupMessage
extends Message
implements AaPupConst {
    protected int unitNumber;
    protected PupOutputStream pupout;
    private byte[] byteMsg;
    private boolean alterAddress;

    public PupMessage(int unitNumber) {
        this.setAddress(unitNumber);
        if (unitNumber == 65535) {
            this.setResponseExpected(false);
        }
    }

    public PupMessage(int unitNumber, boolean alterAddress) {
        this.alterAddress = alterAddress;
        this.setAddress(unitNumber);
        if (unitNumber == 65535) {
            this.setResponseExpected(false);
        }
    }

    public int getUnitNumber() {
        return this.unitNumber;
    }

    public void setAddress(int address) {
        this.unitNumber = address;
        if (this.unitNumber == 65535) {
            this.setResponseExpected(false);
        }
    }

    public void write(OutputStream stream) {
        try {
            stream.write(this.toBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final Message toResponse(ReceivedMessage resp) {
        return this.getResponse((PupReceivedMessage)resp);
    }

    abstract PupResponse getResponse(PupReceivedMessage var1);

    void readBytes(PupInputStream in) {
    }

    byte[] toBytes() {
        if (this.byteMsg == null) {
            this.pupout = PupOutputStream.make();
            if (this.alterAddress) {
                this.pupout.writeInt(this.unitNumber | 0x8000);
            } else {
                this.pupout.writeInt(this.unitNumber);
            }
            this.writeBytes(this.pupout);
            this.pupout.writeChecksum();
            this.byteMsg = this.pupout.toByteArray();
        }
        return this.byteMsg;
    }

    abstract void writeBytes(PupOutputStream var1);

    public String toDebugString() {
        StringBuffer sb = new StringBuffer("PUP Tx:");
        sb.append(ByteArrayUtil.toHexString((byte[])this.toBytes()));
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PupMessage:\n");
        return sb.toString();
    }
}

