/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import java.io.ByteArrayInputStream;

public class PupInputStream
extends ByteArrayInputStream {
    int newchecksum = 0;
    private int encodedLength;
    private int unitNumber;
    private int command;
    private boolean checksumOK = this.verifyChecksum();
    private boolean first = true;
    private boolean last = true;

    public PupInputStream(byte[] data) {
        super(data);
        this.read();
        this.unitNumber = this.readInt();
        this.encodedLength = this.read();
        this.command = this.read();
        if (this.encodedLength == 0) {
            this.encodedLength = this.readInt();
        }
    }

    public synchronized boolean verifyChecksum() {
        this.newchecksum = 0;
        this.reset();
        for (int i = 0; i < this.count - 1; ++i) {
            int b = super.read();
            this.newchecksum ^= b;
            ++this.newchecksum;
            this.newchecksum &= 0xFF;
        }
        boolean ok = this.newchecksum == this.read();
        this.reset();
        return ok;
    }

    public int getCalculatedChecksum() {
        return this.newchecksum;
    }

    public int readInt() {
        return this.read() | this.read() << 8;
    }

    public String readText() {
        String newString = "";
        int availableBytes = this.count - 1 - this.pos;
        if (availableBytes > 0) {
            newString = new String(this.buf, this.pos, availableBytes);
            this.pos += availableBytes;
        }
        return newString;
    }

    public String readAttributeName() {
        int char1 = this.read();
        int char2 = this.read();
        this.first = (char1 & 0x80) == 128;
        this.last = (char2 & 0x80) == 128;
        byte[] bytes = new byte[]{(byte)(char1 & 0x7F), (byte)(char2 & 0x7F)};
        return new String(bytes);
    }

    public double readNumeric(int encoding) {
        return 0.0;
    }

    public byte[] readBytes() {
        int availableBytes = this.count - 1 - this.pos;
        byte[] bytes = new byte[availableBytes];
        if (availableBytes > 0) {
            System.arraycopy(this.buf, this.pos, bytes, 0, availableBytes);
            this.pos += availableBytes;
        }
        return bytes;
    }

    public int getEncodedLength() {
        return this.encodedLength;
    }

    public int getUnitNumber() {
        return this.unitNumber;
    }

    public int getCommand() {
        return this.command;
    }

    public boolean isChecksumOK() {
        return this.checksumOK;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }
}

