/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup;

import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.datatypes.BPupPeerListRecord;
import com.tridium.aapup.enums.BPupPeerTypeEnum;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

public class BPupPeerListFolder
extends BFolder {
    public static final Topic tableUpdated = BPupPeerListFolder.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BPupPeerListFolder.class);
    private int last = -1;
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"folder.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private Object syncLock = new Object();

    public void fireTableUpdated(BValue event) {
        this.fire(tableUpdated, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPupNetwork getNetwork() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof BPupNetwork)) continue;
            return (BPupNetwork)p;
        }
        throw new IllegalStateException();
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BPupPeerListRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRecord(int unitNumber, BPupPeerTypeEnum type) {
        if (!this.getNetwork().getTokenPassConfig().getTokenPassingEnabled()) {
            return false;
        }
        Object object = this.syncLock;
        synchronized (object) {
            if (type == BPupPeerTypeEnum.irresponsiblePeer || type == BPupPeerTypeEnum.fullAdminRoundRobin || type == BPupPeerTypeEnum.fullAdminPrioritized) {
                BPupPeerListRecord[] records = (BPupPeerListRecord[])this.getChildren(BPupPeerListRecord.class);
                for (int i = 0; i < records.length; ++i) {
                    if (records[i].getUnitNumber() != unitNumber) continue;
                    return true;
                }
                this.add("unit" + unitNumber, (BValue)new BPupPeerListRecord(unitNumber, type));
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRecord(int unitNumber) {
        Object object = this.syncLock;
        synchronized (object) {
            BPupPeerListRecord[] records = (BPupPeerListRecord[])this.getChildren(BPupPeerListRecord.class);
            for (int i = 0; i < records.length; ++i) {
                if (records[i].getUnitNumber() != unitNumber) continue;
                this.remove((BComplex)records[i]);
                return true;
            }
            return false;
        }
    }

    public int getOldest(boolean passTokenToDownDevices) {
        BPupPeerListRecord[] records = (BPupPeerListRecord[])this.getChildren(BPupPeerListRecord.class);
        BPupDevice[] devices = (BPupDevice[])this.getNetwork().getChildren(BPupDevice.class);
        BPupPeerListRecord oldest = new BPupPeerListRecord();
        for (int i = 0; i < records.length; ++i) {
            if (!records[i].getLastTokenTime().isBefore(oldest.getLastTokenTime())) continue;
            if (passTokenToDownDevices) {
                oldest = records[i];
                continue;
            }
            for (int j = 0; j < devices.length; ++j) {
                if (devices[j].getUnitNumber() != records[i].getUnitNumber() || devices[j].isDown()) continue;
                oldest = records[i];
            }
        }
        this.last = oldest.getUnitNumber();
        return oldest.getUnitNumber();
    }

    public void setLastTokenTime(int fromWho) {
        BPupPeerListRecord[] records = (BPupPeerListRecord[])this.getChildren(BPupPeerListRecord.class);
        for (int i = 0; i < records.length; ++i) {
            if (records[i].getUnitNumber() != fromWho) continue;
            records[i].setLastTokenTime(BAbsTime.now());
            return;
        }
    }

    public void lastTokenFailed() {
        this.setLastTokenTime(this.last);
    }

    public BIcon getIcon() {
        return icon;
    }
}

