/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup;

import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupDeviceFolder;
import com.tridium.aapup.BPupPeerListFolder;
import com.tridium.aapup.comm.BPupUnsolicitedReceive;
import com.tridium.aapup.comm.PupCommReceiver;
import com.tridium.aapup.datatypes.BPupDeviceDiscoveryConfig;
import com.tridium.aapup.datatypes.BPupTokenPassConfig;
import com.tridium.aapup.job.BPupDiscoverDevicesJob;
import com.tridium.aapup.messages.PupPassTokenMessage;
import com.tridium.aapup.messages.PupTimeSyncMessage;
import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.serial.SerialComm;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BPupNetwork
extends BSerialNetwork {
    public static final Property unitNumber = BPupNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)1, (int)65535));
    public static final Property tokenPassConfig = BPupNetwork.newProperty((int)0, (BValue)new BPupTokenPassConfig(), null);
    public static final Property peerList = BPupNetwork.newProperty((int)2, (BValue)new BPupPeerListFolder(), null);
    public static final Property unsolicitedReceiveHandler = BPupNetwork.newProperty((int)4, (BValue)new BPupUnsolicitedReceive(), null);
    public static final Property allowTimeSyncBroadcast = BPupNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property timeSyncFrequency = BPupNetwork.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), null);
    public static final Property holiday = BPupNetwork.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property deviceTypesFile = BPupNetwork.newProperty((int)0, (BValue)BOrd.make((String)"module://aapup/com/tridium/aapup/deviceTypes.xml"), null);
    public static final Action submitDeviceDiscoveryJob = BPupNetwork.newAction((int)4, (BValue)new BPupDeviceDiscoveryConfig(), null);
    public static final Action syncTime = BPupNetwork.newAction((int)0, null);
    public static final Action expireToken = BPupNetwork.newAction((int)4, null);
    public static final Action recoverToken = BPupNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BPupNetwork.class);
    private PupToken token;
    private Object tokenMonitor = new Object();
    Object responseMonitor = new Object();
    private Clock.Ticket timeSyncTicket;
    private Clock.Ticket tokenTimerTicket;
    private Clock.Ticket tokenRecoveryTicket;
    private IntHashMap controllerMap = new IntHashMap();

    public int getUnitNumber() {
        return this.getInt(unitNumber);
    }

    public void setUnitNumber(int v) {
        this.setInt(unitNumber, v, null);
    }

    public BPupTokenPassConfig getTokenPassConfig() {
        return (BPupTokenPassConfig)this.get(tokenPassConfig);
    }

    public void setTokenPassConfig(BPupTokenPassConfig v) {
        this.set(tokenPassConfig, (BValue)v, null);
    }

    public BPupPeerListFolder getPeerList() {
        return (BPupPeerListFolder)this.get(peerList);
    }

    public void setPeerList(BPupPeerListFolder v) {
        this.set(peerList, (BValue)v, null);
    }

    public BPupUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BPupUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    public void setUnsolicitedReceiveHandler(BPupUnsolicitedReceive v) {
        this.set(unsolicitedReceiveHandler, (BValue)v, null);
    }

    public boolean getAllowTimeSyncBroadcast() {
        return this.getBoolean(allowTimeSyncBroadcast);
    }

    public void setAllowTimeSyncBroadcast(boolean v) {
        this.setBoolean(allowTimeSyncBroadcast, v, null);
    }

    public BRelTime getTimeSyncFrequency() {
        return (BRelTime)this.get(timeSyncFrequency);
    }

    public void setTimeSyncFrequency(BRelTime v) {
        this.set(timeSyncFrequency, (BValue)v, null);
    }

    public BStatusBoolean getHoliday() {
        return (BStatusBoolean)this.get(holiday);
    }

    public void setHoliday(BStatusBoolean v) {
        this.set(holiday, (BValue)v, null);
    }

    public BOrd getDeviceTypesFile() {
        return (BOrd)this.get(deviceTypesFile);
    }

    public void setDeviceTypesFile(BOrd v) {
        this.set(deviceTypesFile, (BValue)v, null);
    }

    public BOrd submitDeviceDiscoveryJob(BPupDeviceDiscoveryConfig params) {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, (BValue)params, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public void expireToken() {
        this.invoke(expireToken, null, null);
    }

    public void recoverToken() {
        this.invoke(recoverToken, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "aapup");
    }

    public BPupNetwork() {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setFlags((Slot)ping, 4);
        this.setFlags((Slot)alarmSourceInfo, 4);
        this.setFlags((Slot)health, 4);
    }

    public void started() throws Exception {
        super.started();
        this.initializeTimerTickets();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.initializeTimerTickets();
            } else {
                this.cancelTimerTickets();
            }
        }
        if (property == allowTimeSyncBroadcast || property == timeSyncFrequency) {
            if (this.timeSyncTicket != null) {
                this.timeSyncTicket.cancel();
            }
            if (this.getAllowTimeSyncBroadcast()) {
                this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getTimeSyncFrequency(), (Action)syncTime, null);
            }
            return;
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.cancelTimerTickets();
    }

    public void initializeTimerTickets() {
        this.token = new PupToken();
        if (this.getAllowTimeSyncBroadcast()) {
            this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getTimeSyncFrequency(), (Action)syncTime, null);
        }
        if (this.getTokenPassConfig().getTokenPassingEnabled()) {
            this.initializeTokenTimer();
        } else {
            this.receivedToken(this.getUnitNumber());
        }
    }

    public void cancelTimerTickets() {
        if (this.timeSyncTicket != null) {
            this.timeSyncTicket.cancel();
        }
        this.timeSyncTicket = null;
        if (this.tokenTimerTicket != null) {
            this.tokenTimerTicket.cancel();
        }
        this.tokenTimerTicket = null;
    }

    public Type getDeviceType() {
        return BPupDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BPupDeviceFolder.TYPE;
    }

    protected Comm makeComm() {
        return new SerialComm((BSerialNetwork)this, (CommReceiver)new PupCommReceiver());
    }

    public Message sendSync(Message msg, BRelTime responseTimeout, int retryCount) {
        if (!this.isCommActive() || msg == null) {
            return null;
        }
        boolean responseExpected = msg.getResponseExpected();
        TokenManagedDispatchRequest req = new TokenManagedDispatchRequest((BBasicNetwork)this, msg, responseTimeout, retryCount);
        if (responseExpected) {
            this.dispatch(req);
            return req.getResponse(0);
        }
        this.dispatch(req);
        return null;
    }

    public BOrd doSubmitDeviceDiscoveryJob(BPupDeviceDiscoveryConfig params, Context cx) {
        return new BPupDiscoverDevicesJob(this, params).submit(cx);
    }

    public void doExpireToken() {
        this.token.setTimerExpired(true);
        this.sendSync(new PupPassTokenMessage(0, this.getUnitNumber()), BRelTime.DEFAULT, 0);
        this.initializeTokenRecoveryTimer();
    }

    public void doRecoverToken() {
        this.getTokenPassConfig().incrementTokenRecoveryCount();
        this.receivedToken(this.getUnitNumber());
        this.getPupLog().info("recovered token");
        if (this.getTokenPassConfig().getLogTokenSnoopOnTokenRecovery()) {
            this.getTokenPassConfig().doLogTokenSnoop();
        }
        this.getTokenPassConfig().appendTokenSnoop("\n*recover*");
        this.getPeerList().lastTokenFailed();
    }

    public void doPassToken() {
        if (this.getTokenPassConfig().getTokenPassingEnabled()) {
            int nextPeer = this.getNextPeer();
            if (nextPeer != -1) {
                this.getTokenPassConfig().appendTokenSnoop("[" + this.getUnitNumber() + ">" + nextPeer + "]");
                this.token.setHasToken(false);
                PupPassTokenMessage req = new PupPassTokenMessage(nextPeer, this.getUnitNumber());
                this.getComm().transmit((Message)req);
            } else {
                this.getTokenPassConfig().appendTokenSnoop("\n[no peers]");
                this.initializeTokenTimer();
                this.cancelTokenRecoveryTimer();
            }
        } else {
            this.token.setHasToken(true);
            this.cancelTokenRecoveryTimer();
        }
    }

    public void doSyncTime() {
        PupTimeSyncMessage req = new PupTimeSyncMessage(this.getHoliday().getBoolean());
        this.sendSync(req, BRelTime.make((long)0L), 0);
    }

    public String getControllerDescription(int manufacturer, int deviceCode) {
        this.populateControllerMap();
        String desc = (String)this.controllerMap.get(manufacturer << 16 | deviceCode);
        if (desc == null) {
            desc = "Unknown, manuf:" + manufacturer + " code:" + deviceCode;
        }
        return desc;
    }

    public void populateControllerMap() {
        try {
            BOrd fileOrd = this.getDeviceTypesFile();
            BIFile file = (BIFile)fileOrd.resolve().get();
            XElem root = XParser.make((InputStream)file.getInputStream()).parse();
            XElem[] deviceTypes = root.elems("device");
            for (int i = 0; i < deviceTypes.length; ++i) {
                int cm = deviceTypes[i].geti("cm", 0);
                int ct = deviceTypes[i].geti("ct", 0);
                String deviceType = deviceTypes[i].get("controllerType", "unknown");
                this.controllerMap.put((cm << 16) + ct, (Object)deviceType);
            }
        }
        catch (Exception e) {
            System.out.println("Error Loading PUP Device Types!");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedToken(int fromWho) {
        if (!this.getTokenPassConfig().getTokenPassingEnabled() && fromWho != this.getUnitNumber()) {
            this.getPupLog().severe("received token from " + fromWho + " while token passing is disabled");
        }
        Object object = this.tokenMonitor;
        synchronized (object) {
            this.token.setHasToken(true);
            this.initializeTokenTimer();
            this.cancelTokenRecoveryTimer();
            this.tokenMonitor.notifyAll();
            this.getPeerList().setLastTokenTime(fromWho);
        }
    }

    public void initializeTokenTimer() {
        if (this.getTokenPassConfig().getPassTokenOnTimeout() && this.getTokenPassConfig().getTokenPassingEnabled()) {
            if (this.tokenTimerTicket != null) {
                this.tokenTimerTicket.cancel();
            }
            if (this.getTokenPassConfig().getPassTokenOnTimeout()) {
                this.tokenTimerTicket = Clock.schedule((BComponent)this, (BRelTime)this.getTokenPassConfig().getTimePerToken(), (Action)expireToken, null);
            }
        }
    }

    public void cancelTokenTimer() {
        if (this.tokenTimerTicket != null) {
            this.tokenTimerTicket.cancel();
        }
        this.tokenTimerTicket = null;
    }

    public void initializeTokenRecoveryTimer() {
        if (this.getTokenPassConfig().getTokenRecovery() && this.getTokenPassConfig().getTokenPassingEnabled()) {
            if (this.tokenRecoveryTicket != null) {
                this.tokenRecoveryTicket.cancel();
            }
            this.tokenRecoveryTicket = Clock.schedule((BComponent)this, (BRelTime)this.getTokenPassConfig().getTokenRecoveryTimeout(), (Action)recoverToken, null);
        }
    }

    public void cancelTokenRecoveryTimer() {
        if (this.tokenRecoveryTicket != null) {
            this.tokenRecoveryTicket.cancel();
        }
        this.tokenRecoveryTicket = null;
    }

    public int getNextPeer() {
        return this.getPeerList().getOldest(this.getTokenPassConfig().getPassToDownDevices());
    }

    public Logger getPupLog() {
        return this.getNetwork().getLogger();
    }

    public boolean hasToken() {
        return this.token.hasToken();
    }

    private class PupToken {
        private boolean hasToken = true;
        private int sentMessageCount = 0;
        private boolean timerExpired;

        public boolean hasToken() {
            return this.hasToken;
        }

        public void setHasToken(boolean token) {
            this.hasToken = token;
            this.sentMessageCount = 0;
            this.timerExpired = false;
        }

        public void incrementSentMessageCount() {
            if (this.sentMessageCount == Short.MAX_VALUE) {
                this.sentMessageCount = 0;
            }
            ++this.sentMessageCount;
        }

        public int getSentMessageCount() {
            return this.sentMessageCount;
        }

        public boolean isExpired() {
            if (BPupNetwork.this.getTokenPassConfig().getPassTokenOnTransactionCount()) {
                return this.sentMessageCount >= BPupNetwork.this.getTokenPassConfig().getTransactionsPerToken() || this.timerExpired;
            }
            return this.timerExpired;
        }

        public void setTimerExpired(boolean b) {
            this.timerExpired = b;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" hasToken=" + this.hasToken).append(" sentCnt =" + this.sentMessageCount).append(" expired =" + this.timerExpired);
            return sb.toString();
        }
    }

    private class TokenManagedDispatchRequest
    implements Runnable {
        Message msg;
        Message response = null;
        boolean complete = false;
        BBasicNetwork basicNet;
        BRelTime responseTimeout;
        int retryCount;

        public TokenManagedDispatchRequest(BBasicNetwork basicNet, Message msg, BRelTime responseTimeout, int retryCount) {
            this.basicNet = basicNet;
            this.msg = msg;
            this.responseTimeout = responseTimeout;
            this.retryCount = retryCount;
        }

        @Override
        public void run() {
            this.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute() {
            Object object = BPupNetwork.this.tokenMonitor;
            synchronized (object) {
                if (BPupNetwork.this.token.isExpired()) {
                    BPupNetwork.this.doPassToken();
                }
                if (this.msg instanceof PupPassTokenMessage) {
                    return;
                }
                while (!BPupNetwork.this.token.hasToken()) {
                    try {
                        BPupNetwork.this.tokenMonitor.wait();
                    }
                    catch (InterruptedException e) {
                        System.out.println("interrupted while waiting for token");
                    }
                }
            }
            object = BPupNetwork.this.responseMonitor;
            synchronized (object) {
                this.response = null;
                try {
                    if (this.msg == null) {
                        return;
                    }
                    BPupNetwork.this.token.incrementSentMessageCount();
                    if (!this.msg.getResponseExpected()) {
                        this.basicNet.getComm().transmitNoResponse(this.msg);
                    } else {
                        this.response = this.basicNet.getComm().transmit(this.msg, this.responseTimeout, this.retryCount);
                    }
                }
                catch (Exception e) {
                    this.basicNet.getLog().error("DispatchRequest caught exception in execute(): ", (Throwable)e);
                }
                this.complete = true;
                BPupNetwork.this.responseMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Message getResponse(int timeout) {
            Object object = BPupNetwork.this.responseMonitor;
            synchronized (object) {
                while (!this.complete) {
                    try {
                        BPupNetwork.this.responseMonitor.wait(timeout);
                    }
                    catch (Exception e) {
                        this.basicNet.getLog().error("exception waiting in getResponse from TokenManagedDispatchRequest: ", (Throwable)e);
                    }
                }
            }
            return this.response;
        }
    }
}

