/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.user;

import com.tridium.authn.BAuthenticationService;
import com.tridium.ldap.BLdapAuthenticationScheme;
import com.tridium.ldap.v3.BKerberosAuthenticationScheme;
import com.tridium.migrator.MigrationUtils;
import com.tridium.nd.user.BNiagaraUserDeviceExt;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.workbench.shell.BDefaultWbWebProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.util.BTypeConfig;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.web.BWebProfileConfig;
import javax.baja.xml.XElem;

@NiagaraType
public class BUserConverter
extends BObject
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BUserConverter.class);
    public static final Logger log = Logger.getLogger("migration.baja.user");
    private BRoleService roleService = null;
    private BAuthenticationService authService = null;
    public List<Role> roles = new ArrayList<Role>();
    public boolean alreadyConvertedRoles = false;

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(BUser.TYPE.toString());
        return types;
    }

    public XElem convertXElem(XElem x, String typeSpecName, Version sourceVersion) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BUserConverter.convertXElem(): x=" + x + "; typeSpecName=" + typeSpecName);
        }
        return BUserConverter.convertPermsToRoles(this.roles, x);
    }

    private static XElem convertPermsToRoles(List<Role> roles, XElem user) throws IOException {
        String username = user.get("n");
        for (XElem c : user.elems()) {
            if (!c.get("n").equalsIgnoreCase("permissions")) continue;
            log.config("Converting BUser (" + username + ")'s permissions.");
            XElem oldPerms = c.copy();
            c.setAttr("n", "roles");
            c.setAttr("t", "b:String");
            c.setAttr("v", username);
            roles.add(new Role(username, oldPerms));
        }
        return user;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BUserConverter.convertComplex(): root=" + root + "; toConvert=" + toConvert);
        }
        if (!this.alreadyConvertedRoles) {
            this.convertRoles(root);
            this.alreadyConvertedRoles = true;
        }
        if (toConvert instanceof BUser) {
            this.convertPassword((BUser)toConvert, sourceVersion);
            this.detectNetworkUser((BUser)toConvert);
            this.detectLdapUser((BUser)toConvert, root);
            this.detectUserPrototype((BUser)toConvert);
        }
    }

    private void convertRoles(BComponent root) {
        BRoleService roleService = null;
        BServiceContainer[] services = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (services != null && services.length > 0) {
            BRoleService[] existingRoleServices = (BRoleService[])services[0].getChildren(BRoleService.class);
            if (existingRoleServices == null || existingRoleServices.length <= 0) {
                log.config("Creating a new RoleService.");
                roleService = new BRoleService();
                services[0].add("RoleService", (BValue)roleService);
            } else {
                roleService = existingRoleServices[0];
                log.config("Using the existing RoleService: " + roleService);
            }
        }
        this.roleService = roleService;
        if (this.roles != null) {
            log.config("Migrating " + this.roles.size() + " roles");
        }
        if (this.roles != null && roleService != null) {
            for (Role migratedRole : this.roles) {
                String roleName = migratedRole.getName();
                BRole role = new BRole();
                role.setPermissions(migratedRole.getPermissionsMap());
                if (roleService.get(roleName) == null) {
                    log.config("Creating a new role: " + migratedRole.getName());
                    roleService.add(migratedRole.getName(), (BValue)role);
                    continue;
                }
                log.config("Using existing role: " + migratedRole.getName());
            }
        }
    }

    private void detectLdapUser(BUser user, BComponent root) {
        BAuthenticationScheme scheme;
        BAuthenticationService[] authServices;
        BComplex parent;
        if (log.isLoggable(Level.FINE)) {
            log.fine("BUserConverter.detectLdapUser(): user=" + user);
        }
        if (!((parent = user.getParent()) instanceof BUserService)) {
            return;
        }
        BUserService userService = (BUserService)parent;
        boolean ldapUser = false;
        String schemeName = user.getAuthenticationSchemeName();
        BServiceContainer[] services = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (this.authService == null && services != null && services.length > 0 && (authServices = (BAuthenticationService[])services[0].getChildren(BAuthenticationService.class)) != null && authServices.length > 0) {
            this.authService = authServices[0];
        }
        if (this.authService == null) {
            this.authService = new BAuthenticationService();
            if (services != null && services.length > 0) {
                services[0].add(this.authService.getType().getTypeName(), (BValue)this.authService);
            }
        }
        if ((scheme = this.authService.getAuthenticationScheme(schemeName)) instanceof BLdapAuthenticationScheme || scheme instanceof BKerberosAuthenticationScheme) {
            ldapUser = true;
        }
        if (Flags.isUserDefined1((BComplex)user.getParent(), (Slot)user.getPropertyInParent())) {
            BLdapAuthenticationScheme[] ldapSchemes = (BLdapAuthenticationScheme[])userService.getChildren(BLdapAuthenticationScheme.class);
            BKerberosAuthenticationScheme[] kerbSchemes = (BKerberosAuthenticationScheme[])userService.getChildren(BKerberosAuthenticationScheme.class);
            if (ldapSchemes.length > 0 || kerbSchemes.length > 0) {
                ldapUser = true;
            }
        }
        if (ldapUser) {
            BValue proto;
            if (this.roleService.getProperty(user.getName()) != null) {
                this.roleService.remove(user.getName());
            }
            if ((proto = userService.getUserPrototypes().get(user.getPrototypeName())) instanceof BUser) {
                user.setRoles(((BUser)proto).getRoles());
            }
        }
    }

    private void convertPassword(BUser user, Version sourceVersion) {
        String PASSWORD = "password";
        BPassword pass = (BPassword)user.get(PASSWORD);
        String PASSWORD_CONFIG = "baja_UserPasswordConfiguration";
        BUserPasswordConfiguration passConfig = (BUserPasswordConfiguration)user.get(PASSWORD_CONFIG);
        String AUTHENTICATOR = "authenticator";
        BAbstractAuthenticator auth = (BAbstractAuthenticator)user.get(AUTHENTICATOR);
        if (auth == null) {
            auth = new BPasswordAuthenticator();
        }
        if (pass != null && auth instanceof BPasswordCache) {
            user.remove(PASSWORD);
            ((BPasswordCache)auth).setPassword(pass);
            log.info(String.format("BUser: removing %s from component %s [%s]", PASSWORD, user, user.getType()));
        } else if (auth instanceof BPasswordAuthenticator) {
            if (sourceVersion.major() < 4) {
                MigrationUtils.logInfo("userConverter.convertPassword.axDefaultToBlank", user.getName());
                ((BPasswordAuthenticator)auth).setPassword(BPassword.make((String)"", (String)BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE));
            } else {
                log.finest("Password property is null because N4 User does not have password; leaving this alone");
            }
        }
        if (passConfig != null) {
            user.remove(PASSWORD_CONFIG);
            if (auth instanceof BPasswordAuthenticator) {
                ((BPasswordAuthenticator)auth).setPasswordConfig(passConfig);
            }
            log.info(String.format("BUser: removing %s from component %s [%s]", PASSWORD_CONFIG, user, user.getType()));
        }
        log.info(String.format("BUser: adding %s to component %s [%s]", AUTHENTICATOR, user, user.getType()));
        user.setAuthenticator(auth);
    }

    private void detectUserPrototype(BUser user) {
        BComplex parent = user.getParent();
        if (parent instanceof BUserPrototypes) {
            BValue webProfileConfig;
            log.info(String.format("BUser: User %s is a user prototype.  Setting new property flags", user));
            user.setFlags((Slot)BUser.roles, 0x10000000 | user.getFlags((Slot)BUser.roles));
            user.setFlags((Slot)BUser.permissions, 0x10000000 | user.getFlags((Slot)BUser.permissions));
            Property userProp = user.getPropertyInParent();
            Property parentProp = parent.getPropertyInParent();
            if (userProp != null && parentProp != null && parent.getParent() instanceof BUserService && userProp.isFrozen() && parentProp.isFrozen() && (webProfileConfig = user.get("web_WebProfileConfig")) instanceof BTypeConfig && ((BTypeConfig)webProfileConfig).getTypeSpec().equals((Object)BDefaultWbWebProfile.TYPE.getTypeSpec())) {
                BTypeSpec newSpec = ((BWebProfileConfig)BWebProfileConfig.TYPE.getInstance()).getTypeSpec();
                log.info(String.format("BUser: User %s is the default user prototype of the UserService. Changing its default web profile from " + ((BTypeConfig)webProfileConfig).getTypeSpec() + " to " + newSpec, user));
                ((BTypeConfig)webProfileConfig).setTypeSpec(newSpec);
            }
        }
    }

    private void detectNetworkUser(BUser user) {
        if (user.getNetworkUser() && Flags.isReadonly((BComplex)user.getParent(), (Slot)user.getPropertyInParent())) {
            log.info(String.format("BUser: User %s is a network user.  Setting new user properties readonly", user));
            BNiagaraUserDeviceExt.setReadonly((BComplex)user);
        }
    }

    private static BPermissionsMap convert(XElem xElem) throws IOException {
        String value = xElem.get("v", null);
        if (value != null) {
            return (BPermissionsMap)BPermissionsMap.DEFAULT.decodeFromString(value);
        }
        return BPermissionsMap.DEFAULT;
    }

    private static class Role {
        private String name;
        private BPermissionsMap permissionsMap;

        public Role(String name, XElem permissionsMap) throws IOException {
            this.name = name;
            this.permissionsMap = BUserConverter.convert(permissionsMap);
        }

        public String getName() {
            return this.name;
        }

        public BPermissionsMap getPermissionsMap() {
            return this.permissionsMap;
        }
    }
}

