/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.program;

import com.tridium.migrator.program.BProgramConverter;
import com.tridium.program.BProgram;
import com.tridium.program.module.BProgramModule;
import java.util.ArrayList;
import java.util.List;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;

@NiagaraType
public class BProgramModuleConverter
extends BComponent
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BProgramModuleConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) {
        BNameMap newMap;
        BProgramModule progMod = (BProgramModule)toConvert;
        for (BProgram prog : progMod.listPrograms()) {
            BProgramConverter.fixProgram(prog);
        }
        BNameMap origMap = progMod.getDependencies();
        if (!origMap.equals((Object)(newMap = BProgramModule.rationalizeDependencies((BProgramModule)progMod)))) {
            progMod.setDependencies(newMap);
            log.info("modified " + toConvert.getDisplayName(null) + " dependencies to " + newMap.toString(null));
        }
    }

    public BValue newInstance(String moduleName, String typeName) {
        return (BValue)BTypeSpec.make((String)moduleName, (String)typeName).getInstance();
    }

    static {
        convertTypes.add("program:ProgramModule");
    }
}

