/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.program;

import com.tridium.migrator.MigReportUtil;
import com.tridium.program.BProgram;
import com.tridium.program.BProgramCode;
import com.tridium.program.ui.BProgramEditor;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.RecompileTool;
import com.tridium.program.ui.signing.BCodeSigningOptions;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import java.io.Console;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.migration.ConverterRegistry;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
public class BProgramConverter
extends BComponent
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BProgramConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    private static RecompileTool recompiler;
    protected static Lexicon lex;
    private static Exception failCause;

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) throws Exception {
        BProgram program = (BProgram)toConvert;
        BProgramConverter.fixProgram(program);
        if (recompiler == null) {
            if (failCause != null) {
                log.severe(failCause.getLocalizedMessage());
                throw failCause;
            }
            BCodeSigningOptions options = BCodeSigningOptions.make();
            String alias = options.getSigningCert();
            String tsaUrl = options.getTsaUrl();
            char[] password = null;
            if (alias != null && !alias.isEmpty()) {
                Console console = AccessController.doPrivileged(() -> System.console());
                password = console.readPassword("Enter private key password for " + alias + ": ", new Object[0]);
                if (alias == null || alias.isEmpty()) {
                    log.warning(lex.getText("program.willNotSign"));
                } else {
                    try {
                        Compiler.checkSigningKey((String)alias, (char[])password);
                    }
                    catch (LocalizableException e) {
                        failCause = e;
                        log.severe(e.getLocalizedMessage());
                        throw e;
                    }
                }
            }
            recompiler = new RecompileTool(alias, tsaUrl, password);
        }
        try {
            recompiler.recompile(program);
        }
        catch (Throwable e) {
            log.warning("unable to compile Program object " + MigReportUtil.getReportName((BComplex)program) + "\n" + e.getMessage());
        }
    }

    public static void fixProgram(BProgram program) {
        BProgramCode code = program.getCode();
        code.setUserDefinedImports(BProgramConverter.fixImports(code.getUserDefinedImports()));
        BProgramEditor editor = new BProgramEditor();
        try {
            editor.doLoadValue((BObject)program, null);
            editor.getImports().save(code);
        }
        catch (Throwable e) {
            log.warning("error in Program object " + MigReportUtil.getReportName((BComplex)program) + "\n" + e.getMessage());
        }
    }

    private static String fixImports(String im) {
        if (im.length() == 0) {
            return im;
        }
        String[] imports = im.split(";");
        StringBuilder sb = new StringBuilder();
        for (String imp : imports) {
            imp = ConverterRegistry.lookUpPackageConversion((String)imp);
            String[] sa = imp.split(":");
            String mod = sa[0];
            String importS = sa[1];
            try {
                Sys.getRegistry().moduleForDependency(mod);
            }
            catch (ModuleNotFoundException e) {
                String newMod = null;
                try {
                    for (NModule nmodule : Nre.getModuleManager().loadModuleParts(mod)) {
                        if (!nmodule.containsPackage(importS)) continue;
                        newMod = nmodule.getModulePartName();
                        break;
                    }
                }
                catch (ModuleNotFoundException moduleNotFoundException) {
                    // empty catch block
                }
                mod = newMod;
            }
            if (mod == null) continue;
            sb.append(mod).append(":").append(importS).append(";");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public BValue newInstance(String moduleName, String typeName) {
        return (BValue)BTypeSpec.make((String)moduleName, (String)typeName).getInstance();
    }

    static {
        convertTypes.add("program:Program");
        lex = Lexicon.make((String)"program");
        failCause = null;
    }
}

