/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.history;

import javax.baja.history.BHistoryRecord;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;

public final class HistoryMigrationUtil {
    private HistoryMigrationUtil() {
    }

    public static String isRecordCorrupt(BHistoryRecord rec, BAbsTime lastTimestamp) {
        StringBuilder sb = new StringBuilder();
        SlotCursor props = rec.getProperties();
        while (props.next()) {
            BValue v = props.get();
            if (!HistoryMigrationUtil.isCorrupt(v)) continue;
            sb.append(props.property().getName()).append(',');
        }
        if (rec.getTimestamp().isBefore(lastTimestamp)) {
            sb.append(String.format("ts out-of-order (%s),", rec.getTimestamp()));
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    public static boolean isRecordCorrupt(BHistoryRecord rec) {
        boolean corrupt = false;
        SlotCursor props = rec.getProperties();
        while (props.next()) {
            BValue v = props.get();
            corrupt |= HistoryMigrationUtil.isCorrupt(v);
        }
        return corrupt;
    }

    public static boolean isCorrupt(BAbsTime t) {
        if (t.isBefore(BAbsTime.DEFAULT)) {
            return true;
        }
        return t.isAfter(BAbsTime.now());
    }

    public static boolean isCorrupt(BStatus s) {
        return s.getBits() > 255;
    }

    public static boolean isCorrupt(Object o) {
        if (o instanceof BStatus) {
            return HistoryMigrationUtil.isCorrupt((BStatus)o);
        }
        if (o instanceof BAbsTime) {
            return HistoryMigrationUtil.isCorrupt((BAbsTime)o);
        }
        return false;
    }
}

