/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.history;

import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.db.LocalDbConnection;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.migrator.MigConst;
import com.tridium.migrator.MigrationUtils;
import com.tridium.migrator.history.HistoryMigrationUtil;
import com.tridium.util.CommandLineArguments;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Cursor;
import javax.baja.util.Lexicon;

public class HistoryDbTool {
    private static final String EXT_DIST = "dist";
    private static final Lexicon lex = Lexicon.make((String)"migrator");
    private static final String HDBT_LOG_NAME = "hdbt";
    private static final Pattern HDB_SEG_PATTERN = Pattern.compile("seg[0-9]");
    private final Logger log = Logger.getLogger("hdbt");
    private LogFileHandler logFileHandler;
    private String outFilename;
    private String source;
    private File sourceDist;
    private File sourceHdb;
    private String historyIdFilter;
    private String stationName;
    private long historyCount;
    private long totalRecordCount;
    private final Set<BIHistory> corruptHistories = new HashSet<BIHistory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] rawArgs) {
        CommandLineArguments args = new CommandLineArguments(rawArgs);
        HistoryDbTool hdbt = new HistoryDbTool();
        try {
            hdbt.processArgs(args);
            try (LogFileHandler ignored = hdbt.initLogFileHandler(hdbt.outFilename);){
                ignored.preventCompilerWarning();
                hdbt.log.setUseParentHandlers(false);
                hdbt.processDb();
            }
            catch (Exception e) {
                HistoryDbTool.err("hdbt.couldNotRun", e, e.getMessage());
            }
        }
        catch (Exception e) {
            HistoryDbTool.err("hdbt.couldNotProcess", e, e.getMessage());
        }
        finally {
            if (!args.hasOption("keepTemp")) {
                try {
                    MigrationUtils.cleanMigTempDirs();
                }
                catch (IOException e) {
                    Logger.getLogger(HDBT_LOG_NAME).info(lex.getText("hdbt.couldNotCleanTempDir"));
                }
            }
        }
    }

    private void processArgs(CommandLineArguments args) throws Exception {
        Level logLevel = Level.WARNING;
        if (args.hasOption("log")) {
            logLevel = Level.parse(args.getOption("log").toUpperCase());
        } else if (args.hasOption("l")) {
            logLevel = Level.parse(args.getOption("l").toUpperCase());
        }
        this.log.setLevel(logLevel);
        this.outFilename = args.hasOption("out") ? args.getOption("out") : "hdbtOut.txt";
        if (args.parameters.length < 1) {
            System.err.println("Must provide at least 1 source arg");
            HistoryDbTool.usage();
            throw new IllegalArgumentException();
        }
        if (args.parameters.length > 1) {
            this.historyIdFilter = args.parameters[1];
        }
        if (args.hasOption("s")) {
            this.stationName = args.getOption("s");
        }
        this.sourceHdb = this.getSource(args.parameters[0]);
        this.log.info("sourceHdb=" + this.sourceHdb);
    }

    private File getSource(String arg) throws Exception {
        this.source = arg;
        if (EXT_DIST.equals(FileUtil.getExtension((String)this.source))) {
            this.sourceDist = new File(this.source);
            this.sourceHdb = this.extractHistoryDB(this.sourceDist);
        }
        if (this.sourceHdb == null) {
            throw new IllegalArgumentException(lex.getText("hdbt.invalidSource"));
        }
        return this.sourceHdb;
    }

    private File extractHistoryDB(File backupDist) throws Exception {
        File zipRoot = MigrationUtils.createMigTempDir("hdbRoot_" + FileUtil.getBase((String)backupDist.getName()));
        try (ZipFile zin = new ZipFile(backupDist);){
            DistributionManifest mfest = MigrationUtils.getDistributionManifest(zin);
            BDependency bajaDependency = MigrationUtils.validateDist(mfest, MigConst.B_VERSION_3_8_38);
            List<String> dirsToExtract = HistoryDbTool.getDirsToExtract(bajaDependency.getVersion());
            MigrationUtils.extractZip(zin, zipRoot, dirsToExtract, (zipEntry, xDirs) -> {
                String zeName = zipEntry.getName();
                boolean include = false;
                for (String dir : xDirs) {
                    include |= zeName.startsWith(dir);
                    if (!this.log.isLoggable(Level.FINER)) continue;
                    this.log.finer("extractHistoryDB.include(" + zeName + "), dir=" + dir + ":, include->" + include);
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("extractHistoryDB.include(" + zeName + "):" + include);
                }
                return include;
            });
        }
        catch (Exception e) {
            String msg = String.format("Exception extracting history db from backup dist:%s", e);
            this.log.log(Level.SEVERE, msg, e);
            throw e;
        }
        File stationsDir = new File(zipRoot, "stations");
        File[] stations = stationsDir.listFiles();
        if (stations == null || stations.length < 1) {
            throw new IllegalArgumentException("stations folder is empty");
        }
        File hdbRoot = new File(stations[0], "history");
        return hdbRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDb() throws Exception {
        Objects.requireNonNull(this.sourceHdb);
        if (!this.sourceHdb.isDirectory()) {
            System.err.println(lex.getText("hdbt.invalidSrcHdb"));
            HistoryDbTool.usage();
            return;
        }
        String msg = String.format("Reading History DB: %s; filter: %s", this.source, this.historyIdFilter);
        this.log.info(msg);
        System.out.println(msg);
        File[] srcFiles = this.sourceHdb.listFiles();
        if (srcFiles == null) {
            this.log.warning("Empty history folder");
            return;
        }
        if (this.stationName == null) {
            this.stationName = HistoryDbTool.getStationName(this.sourceHdb);
        }
        this.log.config(String.format("History Station Name: %s", this.stationName));
        for (File srcFile : srcFiles) {
            String srcName = srcFile.getName();
            if ("station".equals(FileUtil.getBase((String)srcName))) {
                this.log.info("Reading station history db: " + srcFile);
                this.readHistoryDb(this.sourceHdb, this.historyIdFilter, this.stationName);
                continue;
            }
            if ("zip".equals(FileUtil.getExtension((String)srcName))) {
                File tempSrc = MigrationUtils.createMigTempDir("histSrc");
                this.log.info("Reading zipped history db: " + srcFile);
                this.log.fine("Extracting zip to temp file " + tempSrc);
                try (ZipFile zSrc = new ZipFile(srcFile);){
                    MigrationUtils.extractZip(zSrc, tempSrc, ze -> true);
                    this.readHistoryDb(tempSrc, this.historyIdFilter, this.stationName);
                    continue;
                }
                finally {
                    FileUtil.delete((File)tempSrc);
                }
            }
            if (HDB_SEG_PATTERN.matcher(srcFile.getName()).matches()) continue;
            this.log.warning("Unexpected file in history db folder:" + srcFile);
        }
        String stats = String.format("\n\nTotal History Count: %d\nTotal Record Count: %d", this.historyCount, this.totalRecordCount);
        this.log.info(stats);
        System.out.println(stats);
        if (this.corruptHistories.isEmpty()) {
            System.out.println("\nNo Corrupt Histories Found in history database " + this.sourceHdb);
        } else {
            System.out.println("\nCorrupt History List:");
            this.corruptHistories.forEach(history -> {
                String histStr = String.format("%s [%s]", history.getDisplayName(null), history.getId());
                System.out.println(histStr);
                this.log.info(histStr);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistoryDb(File src, String historyIdFilter, String srcStationName) throws Exception {
        this.log.info(String.format("readHistoryDb()  src=%s; historyIdFilter=%s; srcStationName=%s", src, historyIdFilter, srcStationName));
        try (BLocalHistoryDatabase srcDb = new BLocalHistoryDatabase(src, srcStationName);
             LocalDbConnection srcConn = (LocalDbConnection)srcDb.getDbConnection(null);){
            srcDb.open();
            this.log.config("HistoryDbReader: source db open: " + src);
            BIHistory[] srcDbHistories = srcDb.getHistories();
            int historyIndex = 0;
            this.historyCount = srcDbHistories.length;
            for (BIHistory srcHistory : srcDbHistories) {
                block23: {
                    int recordIndex = 0;
                    boolean isCorrupt = false;
                    try {
                        BHistorySummary hSumm = srcConn.getSummary(srcHistory);
                        long historyRecordCount = hSumm.getRecordCount();
                        this.totalRecordCount += historyRecordCount;
                        if (historyIdFilter != null && !historyIdFilter.equals(srcHistory.getId().toString())) {
                            this.log.info(String.format("Skipping source history - does not match filter: %s [%s]", srcHistory.getDisplayName(null), srcHistory.getId()));
                            continue;
                        }
                        this.log.info(String.format("History: %s [%s]\n  Record count: %d\n  First TS: %s\n  Last TS: %s", srcHistory.getDisplayName(null), hSumm.getId(), hSumm.getRecordCount(), hSumm.getFirstTimestamp(), hSumm.getLastTimestamp()));
                        Cursor c = srcConn.scan(srcHistory);
                        BAbsTime lastTimestamp = BAbsTime.DEFAULT;
                        while (c.next()) {
                            BHistoryRecord readRec = (BHistoryRecord)c.get();
                            String corruption = HistoryMigrationUtil.isRecordCorrupt(readRec, lastTimestamp);
                            if (corruption != null) {
                                this.warning("hist.corruptedRecord", srcHistory.getId(), recordIndex, corruption);
                                isCorrupt = true;
                                this.corruptHistories.add(srcHistory);
                                break;
                            }
                            if (this.log.isLoggable(Level.FINER)) {
                                this.log.finer(String.format("Record %d;%s    r=%s", recordIndex, srcHistory.getId(), readRec));
                            }
                            ++recordIndex;
                            lastTimestamp = readRec.getTimestamp();
                        }
                        if (!isCorrupt && (long)recordIndex != historyRecordCount) {
                            this.warning("hist.recordCountMismatch", hSumm.getId(), historyRecordCount, recordIndex);
                            this.corruptHistories.add(srcHistory);
                        }
                    }
                    catch (Exception e) {
                        this.warning("hist.corruptedRecord", srcHistory.getId(), recordIndex, e);
                        this.corruptHistories.add(srcHistory);
                        if (!this.log.isLoggable(Level.CONFIG)) break block23;
                        e.printStackTrace();
                    }
                }
                MigrationUtils.showProgress(historyIndex++, (int)this.historyCount, "hdbt.checkHistory", srcHistory.getId().toString());
            }
            MigrationUtils.showProgress((int)this.historyCount, (int)this.historyCount, "hdbt.checkHistory", lex.getText("finished"));
        }
    }

    private static String getStationName(File hdbFile) {
        File parent = hdbFile.getParentFile();
        return parent.getName();
    }

    private static List<String> getDirsToExtract(BVersion bVersion) {
        ArrayList<String> xDirs = new ArrayList<String>();
        int major = bVersion.getVendorVersion().major();
        switch (major) {
            case 4: {
                Collections.addAll(xDirs, "niagara_user_home/stations/", "stations/");
                break;
            }
            case 3: {
                Collections.addAll(xDirs, "niagara/stations/", "stations/");
            }
        }
        return xDirs;
    }

    private void warning(String lexKey, Object ... args) {
        this.log.warning(String.format(lex.getText(lexKey), args));
    }

    private static void err(String lexKey, Throwable t, Object ... params) {
        System.err.println(String.format(lex.getText(lexKey) + MigrationUtils.formatThrowable(t, Logger.getLogger(HDBT_LOG_NAME)), params));
    }

    private LogFileHandler initLogFileHandler(String name) {
        try {
            this.logFileHandler = new LogFileHandler(name);
            this.logFileHandler.setFormatter(new LogFormatter());
            this.log.addHandler(this.logFileHandler);
            this.log.finest("Log handler created for file at " + name);
        }
        catch (Exception e) {
            MigrationUtils.logWarning("migrate.couldNotCreateLog", e, new Object[0]);
        }
        return this.logFileHandler;
    }

    public static void usage() {
        System.err.println("Usage:\nhdbt <src> [historyId]\n\nsrc is required; must be history folder or backup dist\nhistoryId can be used to filter for a specific history\nOptions:\n  -log:<logLevel>\t\tlogLevel := off|severe|warning|info|config|fine|finer|finest|all\n  -out:<filename>\t\toutput filename, default is 'hdbtOut.txt'\n  -keepTemp      \t\tdo not remove temporary files upon finishing\n");
    }

    static class LogFileHandler
    extends FileHandler
    implements Closeable {
        public LogFileHandler(String filename) throws IOException {
            super(filename);
        }

        void preventCompilerWarning() {
        }
    }

    private static class LogFormatter
    extends SimpleFormatter {
        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String f = "%2$s\n";
            if (record.getLevel() != Level.INFO) {
                f = "%1$s %2$s\n";
            }
            if (record.getLevel() == Level.SEVERE) {
                f = "!!" + f;
            }
            String thrown = "";
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                thrown = sw.toString();
                if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                    f = f + ":\n%3$s";
                }
            }
            return String.format(f, record.getLevel().getLocalizedName(), this.formatMessage(record), thrown);
        }
    }
}

