/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import java.io.File;
import java.util.Optional;
import javax.baja.file.BajaFileUtil;
import javax.baja.migration.BFileMigrator;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BProvisioningNiagaraMigrator
extends BFileMigrator {
    public static final Type TYPE = Sys.loadType(BProvisioningNiagaraMigrator.class);

    public Type getType() {
        return TYPE;
    }

    public String[] getMigrateDirs() {
        return new String[]{"provisioningNiagara"};
    }

    public Optional<String> migrate() throws Exception {
        try {
            this.log.info("Found provisioningNiagara folder containing Niagara distribution files; these files will be copied instead of migrated");
            File[] files = this.source.listFiles();
            if (files != null) {
                for (File file : files) {
                    BajaFileUtil.copy((File)file, (File)new File(this.target, file.getName()));
                }
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of("Error migrating " + this.source + " to " + this.target + ":" + e.toString());
        }
    }
}

