/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.migrator.MigConst;
import com.tridium.migrator.Migrate;
import com.tridium.migrator.MigrationUtils;
import com.tridium.migrator.baja.MigrationEncoding;
import com.tridium.nre.SupplierWithException;
import com.tridium.nre.security.AESDecryptFunction;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.SecretBytes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.baja.migration.BFileMigrator;
import javax.baja.migration.MigrationException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BBackupDistMigrator
extends BFileMigrator {
    public static final Type TYPE = Sys.loadType(BBackupDistMigrator.class);
    private boolean needTargetName;
    private static final Lexicon lex = Lexicon.make((String)"migrator");
    private final List<String> completionMessages = new ArrayList<String>();
    private Supplier<BPassword> passPhraseSupplier;
    private static final Pattern CONFIG_BACKUP_PATTERN = Pattern.compile("config_backup_[0-9]*_[0-9]*(_[0-9]*)*");

    public Type getType() {
        return TYPE;
    }

    public String[] getMigrateTypes() {
        return new String[]{"dist"};
    }

    public void initialize(File source, File target, Supplier<BPassword> passPhraseSupplier, DistributionManifest distManifest) {
        this.passPhraseSupplier = passPhraseSupplier;
        if ("dist".equals(FileUtil.getExtension((String)target.getName()))) {
            MigrationUtils.logInfo("backupDistMigrator.targetIsDist", new Object[0]);
            this.needTargetName = true;
        }
        super.initialize(source, target, passPhraseSupplier, distManifest);
    }

    public Optional<String> migrate() throws Exception {
        File[] stationFiles;
        File[] stations;
        BDependency bajaDependency;
        File srcRoot = MigrationUtils.createMigTempDir("src");
        boolean logFine = this.log.isLoggable(Level.FINE);
        try (ZipFile zin = new ZipFile(this.source);){
            this.distManifest = MigrationUtils.getDistributionManifest(zin);
            bajaDependency = MigrationUtils.validateDist(this.distManifest, MigConst.B_VERSION_3_8_38);
            List<String> dirsToExtract = BBackupDistMigrator.getDirsToExtract(bajaDependency.getVersion());
            MigrationUtils.extractZip(zin, srcRoot, dirsToExtract, (zipEntry, xDirs) -> {
                String zeName = zipEntry.getName();
                if (CONFIG_BACKUP_PATTERN.matcher(Paths.get(FileUtil.getBase((String)zeName), new String[0]).getFileName().toString()).matches()) {
                    MigrationUtils.logInfo("backupDistMigrator.skipConfigBackupBog", zeName);
                    return false;
                }
                boolean include = false;
                for (String dir : xDirs) {
                    include |= zeName.startsWith(dir);
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("BackupDistMigrator.include(" + zeName + "):" + include);
                }
                return include;
            });
        }
        catch (MigrationException e) {
            return MigrationUtils.errorResult(this.log, MessageFormat.format(lex.getText("backupDistMigrator.cannotValidate"), e.getMessage()));
        }
        catch (IOException e) {
            return MigrationUtils.errorResult(this.log, String.format(lex.getText("backupDistMigrator.unzipIOError"), e, Sys.getNiagaraUserHome()));
        }
        catch (Exception e) {
            return MigrationUtils.errorResult(this.log, lex.getText("backupDistMigrator.unzipError"), e);
        }
        File[] files = srcRoot.listFiles((dir, name) -> name.startsWith("niagara"));
        boolean isRemoteBackup = files.length > 0;
        File stationsDir = BBackupDistMigrator.getStationsDir(srcRoot, bajaDependency, isRemoteBackup);
        this.initializePasswordDecryptFunction(srcRoot, bajaDependency, isRemoteBackup);
        if (logFine) {
            this.log.fine((isRemoteBackup ? "Remote Backup Dist: stationsDir = " : "Local Backup Dist: stationsDir = ") + stationsDir);
        }
        if ((stations = stationsDir.listFiles()) == null) {
            return MigrationUtils.errorResult(this.log, "Could not get stations list");
        }
        File stationDir = BBackupDistMigrator.getStationDir(stations);
        if (this.needTargetName) {
            this.target = new File(this.target.getParentFile(), stationDir.getName());
            Optional<String> validationFailure = MigrationUtils.validateTarget(this.target, this.log, this.args.hasOption("o"));
            if (validationFailure.isPresent()) {
                return MigrationUtils.errorResult(this.log, validationFailure.get());
            }
            this.log.info("Updating migration target to station folder " + this.target);
        }
        if ((stationFiles = stationDir.listFiles()) == null) {
            return MigrationUtils.errorResult(this.log, "Station has no files");
        }
        File srcMig = MigrationUtils.createMigTempDir(stationDir.getName());
        int totalFileCount = stationFiles.length;
        int filesCopied = 0;
        for (File file : stationFiles) {
            MigrationUtils.showProgress(filesCopied++, totalFileCount, "backupDistMigrator.copyTemp.progress", file.getName());
            FileUtil.copy((File)file, (File)new File(srcMig, file.getName()));
        }
        MigrationUtils.showProgress(totalFileCount, totalFileCount, "backupDistMigrator.copyTemp.progress", null);
        System.out.println();
        Migrate migrateTemp = new Migrate(this.args, srcMig, this.target, this.distManifest, this.passPhraseSupplier);
        migrateTemp.initialize();
        ArrayList<String> failures = migrateTemp.migrate();
        if (!failures.isEmpty()) {
            return Optional.of("Migration failed for backup dist " + this.source + ":\n" + BBackupDistMigrator.toString(failures));
        }
        this.completionMessages.addAll(migrateTemp.getCompletionMessages());
        return Optional.empty();
    }

    public void addCompletionMessage(List<String> messages) {
        messages.addAll(this.completionMessages);
    }

    private static String toString(List<String> list) {
        if (list == null) {
            return "null";
        }
        if (list.isEmpty()) {
            return "[]";
        }
        return String.join((CharSequence)"\n", list);
    }

    private static List<String> getDirsToExtract(BVersion bVersion) {
        ArrayList<String> xDirs = new ArrayList<String>();
        int major = bVersion.getVendorVersion().major();
        switch (major) {
            case 4: {
                Collections.addAll(xDirs, "niagara_user_home/stations/", "niagara_user_home/security/.kr", "stations/", "security/.kr");
                break;
            }
            case 3: {
                Collections.addAll(xDirs, "niagara/stations/", "niagara/security/.kr", "stations/", "security/.kr");
            }
        }
        return xDirs;
    }

    private static File getStationsDir(File root, BDependency bajaDep, boolean isRemote) {
        File stationsDir = isRemote ? (bajaDep.getVersion().getVendorVersion().major() == 4 ? Paths.get(root.getAbsolutePath(), "niagara_user_home", "stations").toFile() : Paths.get(root.getAbsolutePath(), "niagara", "stations").toFile()) : Paths.get(root.getAbsolutePath(), "stations").toFile();
        return stationsDir;
    }

    private static File getStationDir(File[] stationsList) {
        File stationDir;
        if (stationsList.length == 1) {
            stationDir = stationsList[0];
        } else {
            System.out.println(lex.getText("backupDistMigrator.listStations"));
            for (int i = 0; i < stationsList.length; ++i) {
                System.out.println("  " + (i + 1) + '\t' + stationsList[i].getName());
            }
            while (true) {
                System.out.println(lex.getText("backupDistMigrator.selectStation") + ' ');
                try {
                    String stationSel = MigrationUtils.getUserInput();
                    int selBase1 = Integer.parseInt(stationSel);
                    stationDir = stationsList[selBase1 - 1];
                }
                catch (Exception ignored) {
                    System.out.println(MessageFormat.format(lex.getText("backupDistMigrator.invalidStationSelection"), stationsList.length));
                    System.out.println();
                    continue;
                }
                break;
            }
        }
        System.out.println(MessageFormat.format(lex.getText("backupDistMigrator.stationSelected"), stationDir.getName()));
        return stationDir;
    }

    private void initializePasswordDecryptFunction(File root, BDependency bajaDep, boolean isRemote) throws Exception {
        if (this.distManifest.getPBEEncodingInfo() == null) {
            File niagaraSecurityDir = isRemote ? (bajaDep.getVersion().getVendorVersion().major() == 4 ? Paths.get(root.getAbsolutePath(), "niagara_user_home", "security").toFile() : Paths.get(root.getAbsolutePath(), "niagara", "security").toFile()) : (bajaDep.getVersion().getVendorVersion().major() == 4 ? Paths.get(root.getAbsolutePath(), "niagara_user_home", "security").toFile() : Paths.get(root.getAbsolutePath(), "security").toFile());
            Logger.getLogger("migration").config("BackupDistMigrator: Configuring password manager from security directory " + niagaraSecurityDir);
            Migrate.setPasswordDecryptFunction(new LazyDecryptFunction((SupplierWithException<AESDecryptFunction, Exception>)((SupplierWithException)() -> MigrationEncoding.makeMigrationDecryptFunction(niagaraSecurityDir))));
        } else {
            Migrate.setPasswordDecryptFunction(new LazyDecryptFunction((SupplierWithException<AESDecryptFunction, Exception>)((SupplierWithException)() -> MigrationEncoding.makeMigrationDecryptFunction((ISecretBytesSupplier)this.distManifest.getPBEEncodingInfo().makePBEKey(this.passPhraseSupplier.get().getSecretChars())))));
        }
    }

    public File getTarget() {
        return this.target;
    }

    private static final class LazyDecryptFunction
    implements AESDecryptFunction {
        private AESDecryptFunction inner;
        private final SupplierWithException<AESDecryptFunction, Exception> supplier;

        public LazyDecryptFunction(SupplierWithException<AESDecryptFunction, Exception> supplier) {
            this.supplier = supplier;
        }

        public SecretBytes decrypt(byte[] cipher, byte[] iv, String aesTransformation) throws Exception {
            if (this.inner == null) {
                this.inner = (AESDecryptFunction)this.supplier.get();
            }
            return this.inner.decrypt(cipher, iv, aesTransformation);
        }
    }
}

