/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import com.tridiumx.analytics.ui.chart.BTimeOfDayAxis;
import java.util.HashMap;
import java.util.Map;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

public class BAverageProfileChart
extends BChart {
    public static final Type TYPE = Sys.loadType(BAverageProfileChart.class);
    HashMap<String, HashMap<String, HashMap<BRelTime, BDouble>>> seriesHashmap;
    Array<BRelTime> timeofdayArray;
    double colWidth;
    double maxValue;
    double minValue;
    long intervalsPerDay;
    long interval;
    double rowHeight;
    private BPen defaultPen = BPen.make((double)1.0);
    BTimeOfDayAxis xaxis = new BTimeOfDayAxis();

    public Type getType() {
        return TYPE;
    }

    public BAverageProfileChart() {
        this.setModel((ChartModel)new Model());
    }

    public void doLayout(BWidget[] children) {
        super.doLayout(children);
        if (this.getModel().getSpecCount() == 0) {
            return;
        }
        ChartModel model = this.getModel();
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.MIN_VALUE;
        this.seriesHashmap = new HashMap();
        for (int i = 0; i < model.getSpecCount(); ++i) {
            ChartSpec spec = model.getSpec(i);
            HashMap<String, HashMap<BRelTime, BDouble>> seriesmap = new HashMap<String, HashMap<BRelTime, BDouble>>();
            this.processSeries(spec.getSeries(), seriesmap);
            this.seriesHashmap.put("series" + i, seriesmap);
            spec.getYAxis().setAxisMax((Object)BDouble.make((double)this.maxValue));
            spec.getYAxis().setAxisMin((Object)BDouble.make((double)this.minValue));
            spec.getYAxis().setMaxAuto(false);
            spec.getYAxis().setMinAuto(false);
            spec.getYAxis().setShowSwatches(false);
        }
    }

    public void doPaint(Graphics g) {
        if (this.getModel().getSpecCount() == 0) {
            return;
        }
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        for (int i = 0; i < specCount; ++i) {
            ChartSpec spec = model.getSpec(i);
            Series series = spec.getSeries();
            g.setBrush(series.getBrush());
            double lastX = Double.NaN;
            double lastY = Double.NaN;
            BPen pen = series.getPen();
            if (pen == null) {
                pen = this.defaultPen;
            }
            g.setPen(pen);
            HashMap<String, HashMap<BRelTime, BDouble>> seriesmap = this.seriesHashmap.get("series" + i);
            HashMap<BRelTime, BDouble> valueForTime = seriesmap.get("value");
            BAxis yaxis = spec.getYAxis();
            double zerolocy = yaxis.toDisplaySpace(yaxis.getAxisMin());
            double maxlocy = yaxis.toDisplaySpace(yaxis.getAxisMax());
            double height = zerolocy - maxlocy;
            BAxis xaxis = spec.getXAxis();
            double zerolocx = xaxis.toDisplaySpace(xaxis.getAxisMin());
            double maxlocx = xaxis.toDisplaySpace(xaxis.getAxisMax());
            double width = maxlocx - zerolocx;
            this.colWidth = width / (double)this.intervalsPerDay;
            for (int row = 0; row < this.timeofdayArray.size(); ++row) {
                BRelTime xval = (BRelTime)this.timeofdayArray.get(row);
                BDouble yval = valueForTime.get(xval);
                if (xval == null || yval == null) continue;
                long dayMillis = xval.getMillis();
                long intervalStart = dayMillis - dayMillis % this.interval + 1L;
                long col = intervalStart / this.interval;
                double x = this.colWidth * (double)col + zerolocx;
                double max = Math.ceil(((BDouble)spec.getYAxis().getAxisMax()).getDouble());
                double min = Math.ceil(((BDouble)spec.getYAxis().getAxisMin()).getDouble());
                double y = height * ((max - yval.getDouble()) / (max - min)) + maxlocy;
                g.strokeLine(lastX, lastY, x, y);
                lastX = x;
                lastY = y;
            }
        }
    }

    private void processSeries(Series series, HashMap<String, HashMap<BRelTime, BDouble>> seriesmap) {
        int i;
        HashMap<BRelTime, BDouble> valueForTime = new HashMap<BRelTime, BDouble>();
        HashMap<BRelTime, BInteger> indexForTime = new HashMap<BRelTime, BInteger>();
        this.interval = -1L;
        int lastValidIndex = Integer.MIN_VALUE;
        for (i = 0; i < series.getRowCount(); ++i) {
            BRelTime timeofDay;
            BAbsTime time = (BAbsTime)series.getValue(i, 0);
            BDouble value = (BDouble)series.getValue(i, 1);
            if (time == null || value == null) continue;
            if (i == 0) {
                lastValidIndex = 0;
            }
            if (i == 1) {
                BAbsTime lastTime = (BAbsTime)series.getValue(lastValidIndex, 0);
                this.interval = Math.abs(time.getMillis() - lastTime.getMillis());
            }
            if (valueForTime.get(timeofDay = BRelTime.make((long)time.getTimeOfDayMillis())) != null) {
                BDouble value1 = valueForTime.get(timeofDay);
                valueForTime.put(timeofDay, BDouble.make((double)(value.getDouble() + value1.getDouble())));
                int nIndex = indexForTime.get(timeofDay).getInt();
                indexForTime.put(timeofDay, BInteger.make((int)(nIndex + 1)));
                continue;
            }
            valueForTime.put(timeofDay, value);
            indexForTime.put(timeofDay, BInteger.make((int)1));
        }
        this.calculateAverage(seriesmap, valueForTime, indexForTime);
        this.intervalsPerDay = 86400000L / this.interval;
        this.timeofdayArray = new Array(BRelTime.class);
        i = 0;
        while ((long)i < this.intervalsPerDay) {
            this.timeofdayArray.add((Object)BRelTime.make((long)(this.interval * (long)i)));
            ++i;
        }
        seriesmap.put("value", valueForTime);
    }

    private void calculateAverage(HashMap<String, HashMap<BRelTime, BDouble>> seriesmap, HashMap<BRelTime, BDouble> valueForTime, HashMap<BRelTime, BInteger> indexForTime) {
        for (Map.Entry<BRelTime, BDouble> entry : valueForTime.entrySet()) {
            BRelTime time = entry.getKey();
            BDouble value = entry.getValue();
            int nIndex = indexForTime.get(time).getInt();
            BDouble avg = BDouble.make((double)(value.getDouble() / (double)nIndex));
            valueForTime.put(time, avg);
            if (avg.getDouble() > this.maxValue) {
                this.maxValue = avg.getDouble();
            }
            if (!(avg.getDouble() < this.minValue)) continue;
            this.minValue = avg.getDouble();
        }
        this.maxValue = Math.ceil(this.maxValue);
        this.minValue = Math.floor(this.minValue);
    }

    class Model
    extends BoundChartModel {
        Model() {
        }

        public BAxis findAxis(BAxis axis) {
            if (axis.getDimension().equals((Object)BAxisDimension.x)) {
                return BAverageProfileChart.this.xaxis;
            }
            return super.findAxis(axis);
        }
    }
}

