/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.util.Utils;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;

class Ui {
    static final BImage add = BImage.make((BIcon)BIcon.std((String)"add.png"));
    static final BImage arrowDown = BImage.make((BIcon)BIcon.std((String)"arrowDown.png"));
    static final BImage arrowRight = BImage.make((BIcon)BIcon.std((String)"arrowRight.png"));
    static final BImage arrowUp = BImage.make((BIcon)BIcon.std((String)"arrowUp.png"));
    static final BImage back = BImage.make((BIcon)BIcon.std((String)"arrowLeft.png"));
    static final BImage close = BImage.make((BIcon)BIcon.std((String)"close.png"));
    static final BImage delete = BImage.make((BIcon)BIcon.std((String)"delete.png"));
    static final BImage duplicate = BImage.make((BIcon)BIcon.std((String)"duplicate.png"));
    static final BImage details = BImage.make((BIcon)BIcon.std((String)"detailsView.png"));
    static final BImage edit = BImage.make((BIcon)BIcon.std((String)"edit.png"));
    static final BImage find = BImage.make((BIcon)BIcon.std((String)"find.png"));
    static final BIcon iconPropSheet = BIcon.std((String)"views/propertySheet.png");
    static final BImage propSheet = BImage.make((BIcon)iconPropSheet);
    static final BImage refresh = BImage.make((BIcon)BIcon.std((String)"refresh.png"));
    static final BImage remove = BImage.make((BIcon)BIcon.std((String)"clear.png"));
    static final BImage wireSheet = BImage.make((BIcon)BIcon.std((String)"views/wireSheet.png"));
    private static Lexicon lex = Lexicon.make(Ui.class);

    Ui() {
    }

    static BBorderPane border(BWidget widget, BBorder border) {
        BBorderPane pane = new BBorderPane(widget);
        pane.setBorder(border);
        return pane;
    }

    static Command hyperlink(BWidget owner, String label, BIcon icon, BOrd o) {
        return new HyperlinkCommand(owner, label, BImage.make((BIcon)icon), o);
    }

    public static String lex(String key) {
        return Utils.lex((String)key);
    }

    static BBorderPane pad(BBorderPane pane, int pixels) {
        pane.setPadding(BInsets.make((double)5.0));
        return pane;
    }

    static BBorderPane pad(BBorderPane pane, double top, double right, double bottom, double left) {
        pane.setPadding(BInsets.make((double)top, (double)right, (double)bottom, (double)left));
        return pane;
    }

    static void showError(BWidget owner, Throwable err) {
        String msg = err.getMessage();
        if (msg == null) {
            msg = err.toString();
        }
        BDialog.error((BWidget)owner, (String)BDialog.TITLE_ERROR, (Object)msg, (Throwable)err);
    }

    static BBorderPane solid(BWidget widget, int top, int right, int bottom, int left) {
        BBorderPane pane = new BBorderPane(widget);
        int styled = 1;
        int unstyled = 0;
        BBrush brush = BBrush.DEFAULT;
        BBrush nobrush = BBrush.NULL;
        boolean tw = top != 0;
        boolean rw = right != 0;
        boolean bw = bottom != 0;
        boolean lw = left != 0;
        int ts = top != 0 ? styled : unstyled;
        int rs = right != 0 ? styled : unstyled;
        int bs = bottom != 0 ? styled : unstyled;
        int ls = left != 0 ? styled : unstyled;
        BBrush tb = top != 0 ? brush : nobrush;
        BBrush rb = right != 0 ? brush : nobrush;
        BBrush bb = bottom != 0 ? brush : nobrush;
        BBrush lb = left != 0 ? brush : nobrush;
        BBorder border = BBorder.make((double)((double)tw), (int)ts, (BBrush)tb, (double)((double)rw), (int)rs, (BBrush)rb, (double)((double)bw), (int)bs, (BBrush)bb, (double)((double)lw), (int)ls, (BBrush)lb);
        pane.setBorder(border);
        return pane;
    }

    static BButton newToolButton(Command cmd) {
        return Ui.toolButton(new BButton(cmd));
    }

    static BObject resolveOrd(BWbPlugin plugin, String ord) {
        try {
            if (plugin.getWbShell() == null) {
                return null;
            }
            BOrd cur = BOrd.make((BOrd)plugin.getWbShell().getActiveOrd(), (String)ord);
            BObject ret = cur.get();
            if (ret instanceof BComponent) {
                ret.asComponent().loadSlots();
            }
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static BButton toolButton(BButton button) {
        button.setButtonStyle(BButtonStyle.toolBar);
        button.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        return button;
    }

    private static class HyperlinkCommand
    extends Command {
        BOrd ord;

        HyperlinkCommand(BWidget owner, String label, BImage icon, BOrd ord) {
            super(owner, label, icon, null, null);
            this.ord = ord;
        }

        public CommandArtifact doInvoke() {
            BWbShell shell = (BWbShell)this.getOwner().getShell();
            shell.hyperlink(BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)this.ord));
            return null;
        }
    }
}

