/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.ui.Ui;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.gx.BImage;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BNodeSelectionFe
extends BWbFieldEditor {
    public static final Action findNode = BNodeSelectionFe.newAction((int)0, null);
    public static final Action textModified = BNodeSelectionFe.newAction((int)0, null);
    public static final Action treeSelection = BNodeSelectionFe.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNodeSelectionFe.class);
    private static ArrayList<String> history = new ArrayList();
    private MyTreeModel model;
    private BTextDropDown text;
    private BTree tree;
    private static boolean useHier = false;

    public void findNode() {
        this.invoke(findNode, null, null);
    }

    public void textModified() {
        this.invoke(textModified, null, null);
    }

    public void treeSelection() {
        this.invoke(treeSelection, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNodeSelectionFe() {
        BEdgePane content = new BEdgePane();
        this.model = new MyTreeModel((BWbPlugin)this);
        this.tree = new BTree((TreeModel)this.model);
        this.tree.setMultipleSelection(false);
        content.setCenter((BWidget)new BScrollPane((BWidget)this.tree));
        this.text = new BTextDropDown(true);
        content.setBottom((BWidget)Ui.pad(Ui.solid((BWidget)this.text, 0, 1, 1, 1), 2.0, 2.0, 2.0, 2.0));
        BConstrainedPane cp = new BConstrainedPane((BWidget)content);
        cp.setMinWidth(300.0);
        cp.setMinHeight(400.0);
        this.setContent((BWidget)cp);
    }

    public void doFindNode() {
        String value = this.text.getText();
        int i = this.model.getRootCount();
        while (--i >= 0) {
            this.expand(value, this.model.getRoot(i));
        }
    }

    public void doTextModified() {
        this.doFindNode();
        this.setModified();
    }

    public void doTreeSelection() {
        TreeNode node = this.tree.getSelection().getNode();
        if (node == null) {
            return;
        }
        this.updateText(node.getSubject().toString());
    }

    static BTree makeTree(BWbPlugin owner) {
        BTree ret = new BTree((TreeModel)new MyTreeModel(owner));
        ret.setMultipleSelection(false);
        return ret;
    }

    public void started() throws Exception {
        super.started();
        this.text.getEditor().requestFocus();
        this.text.getEditor().getSelection().selectAll();
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        try {
            BAnalyticService svc = (BAnalyticService)Ui.resolveOrd((BWbPlugin)this, "service:analytics:AnalyticService");
            svc.lease();
            useHier = svc.getUseHierarchyCache();
        }
        catch (Exception x) {
            Utils.log().log(Level.WARNING, Utils.lex((String)"analyticServiceNotAvaiable"), x);
        }
        this.updateText(value.toString(null));
        this.linkTo((BComponent)this.tree, (Slot)BTree.actionPerformed, (Slot)treeSelection);
        this.linkTo((BComponent)this.text.getEditor(), (Slot)BTextEditor.textModified, (Slot)textModified);
        this.findNode();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return BString.make((String)this.text.getText());
    }

    protected void doSetReadonly(boolean readonly) {
        this.text.setEnabled(!readonly);
    }

    private void expand(String value, TreeNode node) {
        if (node == null) {
            return;
        }
        String s = node.getSubject().toString();
        if (!value.startsWith(s)) {
            return;
        }
        node.setExpanded(true);
        if (value.equals(s)) {
            node.getTree().getSelection().select(node);
            this.relayout();
            return;
        }
        int i = node.getChildCount();
        while (--i >= 0) {
            this.expand(value, node.getChild(i));
        }
    }

    private void updateText(String value) {
        if (value.length() > 0) {
            history.remove(value);
            history.add(0, value);
            int i = history.size();
            while (--i >= 25) {
                history.remove(i);
            }
            BList list = this.text.getList();
            list.removeAllItems();
            int len = history.size();
            for (int i2 = 0; i2 < len; ++i2) {
                list.addItem((Object)history.get(i2));
            }
        }
        this.text.setText(value);
    }

    static class MyTreeNode
    extends TreeNode {
        BImage icon;
        MyTreeNode[] kids;
        BINavNode node;

        MyTreeNode(TreeModel model, BINavNode node) {
            super(model);
            this.node = node;
        }

        MyTreeNode(TreeModel model, TreeNode parent, BINavNode node) {
            super(model, parent);
            this.node = node;
        }

        public TreeNode getChild(int idx) {
            if (this.kids == null) {
                this.getChildCount();
            }
            return this.kids[idx];
        }

        public int getChildCount() {
            if (this.kids == null) {
                BINavNode[] tmp = this.node.getNavChildren();
                this.kids = new MyTreeNode[tmp.length];
                int i = tmp.length;
                while (--i >= 0) {
                    this.kids[i] = new MyTreeNode(this.getModel(), this, tmp[i]);
                }
            }
            return this.kids.length;
        }

        public BImage getIcon() {
            if (this.icon == null) {
                this.icon = BImage.make((BIcon)this.node.getNavIcon());
            }
            return this.icon;
        }

        public Object getSubject() {
            BOrd ord = Utils.getNodeOrd((BINavNode)this.node);
            String s = ord.toString(null);
            if (useHier) {
                s = s.replace("hierarchy:", "hier:");
                if (this.node instanceof BLevelElem) {
                    BLevelElem temp = (BLevelElem)this.node;
                    BComponent tgt = temp.getTargetComponent();
                    while (temp != null && s.indexOf("/station$3a$7c") > -1) {
                        if (tgt != null) {
                            String handleOrd = SlotPath.escape((String)temp.getEntityOrd().toString());
                            String navName = tgt.getNavName();
                            s = s.replace(handleOrd, navName);
                        }
                        tgt = (temp = (BLevelElem)temp.getNavParent()) == null ? null : temp.getTargetComponent();
                    }
                }
            }
            if (s.startsWith("station:|")) {
                s = s.substring(9);
            }
            return s;
        }

        public boolean hasChildren() {
            if (this.kids != null) {
                return this.kids.length > 0;
            }
            return this.node.hasNavChildren();
        }

        public String getText() {
            return this.node.getNavDisplayName(null);
        }
    }

    static class MyTreeModel
    extends TreeModel {
        BWbPlugin owner;
        ArrayList<MyTreeNode> roots = new ArrayList();

        MyTreeModel(BWbPlugin owner) {
            this.owner = owner;
        }

        public TreeNode getRoot(int idx) {
            return this.roots.get(idx);
        }

        public int getRootCount() {
            if (this.roots.size() == 0) {
                BINavNode root = (BINavNode)Ui.resolveOrd(this.owner, "station:|slot:/");
                if (root != null) {
                    this.roots.add(new MyTreeNode(this, root));
                }
                if ((root = (BINavNode)Ui.resolveOrd(this.owner, "station:|hierarchy:")) != null) {
                    this.roots.add(new MyTreeNode(this, root));
                }
            }
            return this.roots.size();
        }
    }
}

