/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.gx;

import java.io.PrintWriter;
import java.util.Stack;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XWriter;

public class SvgGraphics
implements Graphics {
    private PrintWriter writer;
    private Writer out;
    private Stack<GxState> stack = new Stack();
    private int clipCount = 0;
    private double tx = 0.0;
    private double ty = 0.0;
    private int width;
    private int height;
    private BBrush brush;
    private BPen pen;
    private BFont font;
    private IGeom clip;

    public SvgGraphics(PrintWriter writer, int width, int height) {
        this.writer = writer;
        this.out = new Writer();
        this.brush = BBrush.DEFAULT;
        this.font = BFont.DEFAULT;
        this.pen = BPen.DEFAULT;
        this.width = width;
        this.height = height;
        this.out.w("<?xml version='1.0' standalone='no'?>").nl();
        this.out.w("<!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.1//EN'");
        this.out.w(" 'http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd'>").nl();
        this.out.w("<svg width='100%' height='100%'");
        this.out.w(" viewBox='0 0 ").w(width).w(" ").w(height).w("'");
        this.out.w(" version='1.1' xmlns='http://www.w3.org/2000/svg'>").nl();
        this.clip(0.0, 0.0, width, height);
    }

    public void useAntiAliasing(boolean b) {
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush b) {
        BBrush.Paint paint = b.getPaint();
        if (paint instanceof BBrush.Solid) {
            this.brush = b;
        } else if (paint instanceof BBrush.Gradient) {
            BBrush.Stop stop = ((BBrush.Gradient)paint).getStops()[0];
            this.brush = stop.getColor().toBrush();
        } else {
            this.brush = BColor.white.toBrush();
        }
    }

    public void setBrush(BColor c) {
        this.setBrush(c.toBrush());
    }

    public BPen getPen() {
        return this.pen;
    }

    public void setPen(BPen p) {
        this.pen = p;
    }

    public BFont getFont() {
        return this.font;
    }

    public void setFont(BFont font) {
        this.font = font;
    }

    public void transform(BTransform transform) {
    }

    public void translate(double x, double y) {
        this.tx += x;
        this.ty += y;
    }

    public IGeom getClip() {
        return this.clip;
    }

    public IRectGeom getClipBounds() {
        return this.clip.bounds();
    }

    public void clip(IGeom geom) {
        this.clip = geom;
        ++this.clipCount;
        IRectGeom rect = geom.bounds();
        double x = rect.x();
        double y = rect.y();
        double w = rect.width();
        double h = rect.height();
        this.out.w("<clipPath id='clip" + this.clipCount + "'>");
        this.out.w("<path d='M").w(x).w(",").w(y).w(" ");
        this.out.w(" h ").w(w);
        this.out.w(" v ").w(h);
        this.out.w(" h ").w(-w);
        this.out.w(" z' />");
        this.out.w("</clipPath>").nl();
    }

    public void clip(double x, double y, double w, double h) {
        this.clip((IGeom)new RectGeom(x, y, w, h));
    }

    public void stroke(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                ILineGeom l = (ILineGeom)geom;
                this.strokeLine(l.x1(), l.y1(), l.x2(), l.y2());
                break;
            }
            case 2: {
                IRectGeom r = (IRectGeom)geom;
                this.strokeRect(r.x(), r.y(), r.width(), r.height());
                break;
            }
            case 3: {
                this.strokeEllipse((IEllipseGeom)geom);
                break;
            }
            case 4: {
                this.strokePolygon((IPolygonGeom)geom);
                break;
            }
            case 5: {
                this.strokePath((IPathGeom)geom);
            }
        }
    }

    public void fill(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 2: {
                IRectGeom r = (IRectGeom)geom;
                this.fillRect(r.x(), r.y(), r.width(), r.height());
                break;
            }
            case 3: {
                this.fillEllipse((IEllipseGeom)geom);
                break;
            }
            case 4: {
                this.fillPolygon((IPolygonGeom)geom);
                break;
            }
            case 5: {
                this.fillPath((IPathGeom)geom);
            }
        }
    }

    public void strokeLine(double x1, double y1, double x2, double y2) {
        this.out.w("<line clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='").w(this.brush).w("'");
        this.out.w(" x1='").w(this.tx + x1).w("' y1='").w(this.ty + y1).w("'");
        this.out.w(" x2='").w(this.tx + x2).w("' y2='").w(this.ty + y2).w("'");
        this.out.w("/>").nl();
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.out.w("<rect clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" fill='none' stroke='").w(this.brush).w("'");
        this.out.w(" x='").w(this.tx + x).w("' y='").w(this.ty + y).w("'");
        this.out.w(" width='").w(width).w("' height='").w(height).w("'");
        this.out.w("/>").nl();
    }

    public void fillRect(double x, double y, double width, double height) {
        this.out.w("<rect clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='none' fill='").w(this.brush).w("'");
        this.out.w(" x='").w(this.tx + x).w("' y='").w(this.ty + y).w("'");
        this.out.w(" width='").w(width).w("' height='").w(height).w("'");
        this.out.w("/>").nl();
    }

    public void drawString(String str, double x, double y) {
        this.drawString(str.toCharArray(), 0, str.length(), x, y);
    }

    public void drawString(char[] data, int offset, int length, double x, double y) {
        try {
            this.out.w("<text clip-path='url(#clip" + this.clipCount + ")'");
            this.out.w(" x='").w(this.tx + x).w("' y='").w(this.ty + y).w("'");
            this.out.w(" fill='").w(this.brush).w("'");
            this.out.w(" font-family='").w(this.font.getName()).w("'");
            this.out.w(" font-size='").w(this.font.getSize()).w("'");
            if (this.font.isBold()) {
                this.out.w(" font-weight='bold'");
            }
            this.out.w(">");
            for (int i = offset; i < length; ++i) {
                XWriter.safe((java.io.Writer)this.writer, (int)data[i], (boolean)false);
            }
            this.out.w("</text>").nl();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void drawImage(BImage img, double x, double y) {
    }

    private void strokeEllipse(IEllipseGeom e) {
        double rx = e.width() / 2.0;
        double ry = e.height() / 2.0;
        double cx = e.x() + rx;
        double cy = e.y() + ry;
        this.out.w("<ellipse clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" fill='none' stroke='").w(this.brush).w("'");
        this.out.w(" cx='").w(this.tx + cx).w("' cy='").w(this.ty + cy).w("'");
        this.out.w(" rx='").w(rx).w("' ry='").w(ry).w("' />");
    }

    private void fillEllipse(IEllipseGeom e) {
        double rx = e.width() / 2.0;
        double ry = e.height() / 2.0;
        double cx = e.x() + rx;
        double cy = e.y() + ry;
        this.out.w("<ellipse clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='none' fill='").w(this.brush).w("'");
        this.out.w(" cx='").w(this.tx + cx).w("' cy='").w(this.ty + cy).w("'");
        this.out.w(" rx='").w(rx).w("' ry='").w(ry).w("' />");
    }

    private void strokePolygon(IPolygonGeom p) {
        this.out.w("<polygon clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" fill='none' stroke='").w(this.brush).w("' points='");
        for (int i = 0; i < p.size(); ++i) {
            if (i > 0) {
                this.out.w(" ");
            }
            this.out.w(this.tx + p.x(i)).w(",").w(this.ty + p.y(i));
        }
        this.out.w("' />");
    }

    private void fillPolygon(IPolygonGeom p) {
        this.out.w("<polygon clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='none' fill='").w(this.brush).w("' points='");
        for (int i = 0; i < p.size(); ++i) {
            if (i > 0) {
                this.out.w(" ");
            }
            this.out.w(this.tx + p.x(i)).w(",").w(this.ty + p.y(i));
        }
        this.out.w("' />");
    }

    private void strokePath(IPathGeom p) {
        this.out.w("<path clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" fill='none' stroke='").w(this.brush).w("'");
        this.out.w(" transform='translate(").w(this.tx).w(",").w(this.ty).w(")'");
        this.out.w(" d='");
        for (int i = 0; i < p.size(); ++i) {
            if (i > 0) {
                this.out.w(" ");
            }
            this.out.w(p.segment(i).toString());
        }
        this.out.w("' />");
    }

    private void fillPath(IPathGeom p) {
        this.out.w("<path clip-path='url(#clip" + this.clipCount + ")'");
        this.out.w(" stroke='none' fill='").w(this.brush).w("'");
        this.out.w(" transform='translate(").w(this.tx).w(",").w(this.ty).w(")'");
        this.out.w(" d='");
        for (int i = 0; i < p.size(); ++i) {
            if (i > 0) {
                this.out.w(" ");
            }
            this.out.w(p.segment(i).toString());
        }
        this.out.w("' />");
    }

    public void push() {
        GxState s = new GxState();
        s.tx = this.tx;
        s.ty = this.ty;
        s.brush = this.brush;
        s.pen = this.pen;
        s.font = this.font;
        this.stack.push(s);
    }

    public void pop() {
        GxState s = this.stack.pop();
        this.tx = s.tx;
        this.ty = s.ty;
        this.brush = s.brush;
        this.pen = s.pen;
        this.font = s.font;
        this.clip(0.0, 0.0, this.width, this.height);
    }

    public void dispose() {
        this.out.w("</svg>");
    }

    class Writer {
        Writer() {
        }

        public Writer w(double d) {
            return this.w(Double.toString(d));
        }

        public Writer w(Object obj) {
            return this.w(String.valueOf(obj));
        }

        public Writer w(String s) {
            try {
                SvgGraphics.this.writer.print(s);
                return this;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public Writer w(char ch) {
            try {
                SvgGraphics.this.writer.print(ch);
                return this;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public Writer nl() {
            return this.w("\n");
        }
    }

    class GxState {
        public double tx;
        public double ty;
        public BBrush brush;
        public BPen pen;
        public BFont font;

        GxState() {
        }
    }
}

