/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_IO.ui;

import com.gc5.iSMA_IO.enums.BLinearConversion;
import javax.baja.gx.BSize;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"iSMA_IO:LinearConversion"})})
public class BLinearConversionFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BLinearConversionFE.class);
    private BGridPane editPane;
    private BTextField factorA = new BTextField();
    private BTextField factorB = new BTextField();
    private BLinearConversion linearConv;
    private Property propInParent;
    private BComplex parent;

    public Type getType() {
        return TYPE;
    }

    public BLinearConversionFE() {
        BLabel firstLabel = new BLabel("Scale");
        BLabel secondLabel = new BLabel("        Offset");
        this.factorA.setLayout(BLayout.makeAbs((double)0.0, (double)0.0, (double)100.0, (double)20.0));
        this.factorB.setLayout(BLayout.makeAbs((double)0.0, (double)0.0, (double)100.0, (double)20.0));
        BCanvasPane cp1 = new BCanvasPane();
        cp1.setViewSize(BSize.make((double)this.factorA.getLayout().getWidth(), (double)20.0));
        cp1.add("ed1", (BValue)this.factorA);
        BCanvasPane cp2 = new BCanvasPane();
        cp2.setViewSize(BSize.make((double)this.factorB.getLayout().getWidth(), (double)20.0));
        cp2.add("ed2", (BValue)this.factorB);
        this.editPane = new BGridPane(4);
        this.editPane.setColumnGap(10.0);
        this.editPane.add("firstLabel", (BValue)firstLabel);
        this.editPane.add("cp1", (BValue)cp1);
        this.editPane.add("secondLabel", (BValue)secondLabel);
        this.editPane.add("cp2", (BValue)cp2);
        this.editPane.setValign(BValign.center);
        this.setContent((BWidget)this.editPane);
        this.linkTo("lk0", (BComponent)this.factorA, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.factorA, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.factorB, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.factorB, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.propInParent = value.asComponent().getPropertyInParent();
        this.parent = value.asComponent().getParent();
        this.linearConv = (BLinearConversion)value;
        this.factorA.setText(Double.toString(this.linearConv.getScale()).replace('.', ','));
        this.factorB.setText(Double.toString(this.linearConv.getOffset()).replace('.', ','));
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String factorAStr = this.factorA.getText();
        String factorBStr = this.factorB.getText();
        ((BLinearConversion)value).setScale(Double.parseDouble(factorAStr.replace(',', '.')));
        ((BLinearConversion)value).setOffset(Double.parseDouble(factorBStr.replace(',', '.')));
        return value;
    }
}

