/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.authn.NiagaraLoginConfiguration;
import com.tridium.ldap.v3.BKerberosConfig;
import com.tridium.ldap.v3.KerberosLoginModule;
import com.tridium.web.Template;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import javax.baja.agent.AgentList;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BBlankAuthenticator;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@NiagaraType(agent={@AgentOn(types={"baja:AuthenticationScheme"})})
@NiagaraProperty(name="config", type="BKerberosConfig", defaultValue="new BKerberosConfig()")
public class BKerberosAuthenticationScheme
extends BSSOAuthenticationScheme {
    public static final Property config = BKerberosAuthenticationScheme.newProperty((int)0, (BValue)new BKerberosConfig(), null);
    public static final Type TYPE = Sys.loadType(BKerberosAuthenticationScheme.class);
    public static final String SCHEME_NAME = "n4Kerberos";
    private Configuration configuration;
    private static final BOrd helpTemplate = BOrd.make((String)"module://ldap/com/tridium/ldap/rc/kerberosHelp.vm");

    public BKerberosConfig getConfig() {
        return (BKerberosConfig)this.get(config);
    }

    public void setConfig(BKerberosConfig v) {
        this.set(config, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("webEditors:MultiSheet");
        list.toTop("workbench:PropertySheet");
        return list;
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public Configuration getLoginConfiguration() {
        HashMap<String, BKerberosConfig> options = new HashMap<String, BKerberosConfig>();
        options.put("config", this.getConfig());
        if (this.configuration == null) {
            this.configuration = new NiagaraLoginConfiguration(KerberosLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        }
        return this.configuration;
    }

    public boolean supportsRemoteUsers() {
        return true;
    }

    public BAbstractAuthenticator getDefaultAuthenticator() {
        return new BBlankAuthenticator();
    }

    public String getLoginRedirectURL() {
        return "/login-kerb";
    }

    public Optional<String> getHelpHTML() {
        try {
            return Optional.of(Template.process((BOrd)helpTemplate));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

