/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v2;

import com.tridium.ldap.BConfigurableLdapConfig;
import com.tridium.util.ArrayUtil;
import java.security.AccessController;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.naming.directory.DirContext;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connectionUser", type="String", defaultValue=""), @NiagaraProperty(name="connectionPwd", type="BPassword", defaultValue="BPassword.make(\"\")")})
public class BLdapV2Config
extends BConfigurableLdapConfig {
    public static final Property connectionUser = BLdapV2Config.newProperty((int)0, (String)"", null);
    public static final Property connectionPwd = BLdapV2Config.newProperty((int)0, (BValue)BPassword.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BLdapV2Config.class);

    public String getConnectionUser() {
        return this.getString(connectionUser);
    }

    public void setConnectionUser(String v) {
        this.setString(connectionUser, v, null);
    }

    public BPassword getConnectionPwd() {
        return (BPassword)this.get(connectionPwd);
    }

    public void setConnectionPwd(BPassword v) {
        this.set(connectionPwd, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void rebind(DirContext dir, BICredentials credentials, String principal) throws Exception {
        if (!(credentials instanceof BUsernameAndPassword)) {
            throw new AuthenticationException("Invalid Credential Type");
        }
        logger.fine(lex.getText("ldap.login.rebind", new Object[]{principal}));
        BUsernameAndPassword creds = (BUsernameAndPassword)credentials;
        dir.addToEnvironment("java.naming.security.principal", principal);
        dir.addToEnvironment("java.naming.security.credentials", AccessController.doPrivileged(() -> ((BPassword)creds.getPassword()).getValue()));
    }

    @Override
    protected String getConnectionUser(String username) {
        String user = this.getConnectionUser();
        if (user.isEmpty()) {
            return null;
        }
        return this.getConnectionUser();
    }

    @Override
    protected String getConnectionPwd(String password) {
        return AccessController.doPrivileged(() -> ((BPassword)this.getConnectionPwd()).getValue());
    }

    @Override
    public String[] listConfig() {
        return (String[])ArrayUtil.add((Object[])super.listConfig(), (Object[])new String[]{"connectionUser", "connectionPwd"});
    }
}

