/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.dashboard;

import com.tridium.authn.BAuthenticationService;
import com.tridium.ldap.v3.BKerberosAuthenticationScheme;
import com.tridium.ldap.v3.BKerberosConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardItemProvider;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:AuthenticationServiceSecurityDashboardProviderAgent"})})
public final class BKerberosSchemeSecurityItemProvider
extends BObject
implements BISecurityDashboardItemProvider,
BIAgent {
    public static final Type TYPE = Sys.loadType(BKerberosSchemeSecurityItemProvider.class);
    private BAuthenticationService authService;
    private SecurityDashboardItemBuilder builder;
    private static final String KERB_TLS_DESCRIPTION = "securityDashboard.kerberosSchemeTLS.description";
    private static final String KERB_TLS_DISABLED_SUMMARY = "securityDashboard.kerberosSchemeTLS.disabled.summary";
    private static final String KERB_TLS_ENABLED_SUMMARY = "securityDashboard.kerberosSchemeTLS.enabled.summary";

    public Type getType() {
        return TYPE;
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.authService = (BAuthenticationService)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        return Collections.unmodifiableList(this.getTlsItems());
    }

    private List<SecurityDashboardItem> getTlsItems() {
        String schemeNames;
        ArrayList<String> tlsEnabledSchemes = new ArrayList<String>();
        ArrayList<String> tlsDisabledSchemes = new ArrayList<String>();
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        for (BKerberosAuthenticationScheme kerbScheme : BKerberosSchemeSecurityItemProvider.getKerberosSchemes(this.authService)) {
            if (BKerberosSchemeSecurityItemProvider.isTlsEnabled(kerbScheme)) {
                tlsEnabledSchemes.add(kerbScheme.getName());
                continue;
            }
            tlsDisabledSchemes.add(kerbScheme.getName());
        }
        if (!tlsEnabledSchemes.isEmpty()) {
            schemeNames = String.join((CharSequence)", ", tlsEnabledSchemes);
            items.add(this.builder.makeOk().withSummary(KERB_TLS_ENABLED_SUMMARY, new Object[]{schemeNames}).withDescription(KERB_TLS_DESCRIPTION, new Object[0]));
        }
        if (!tlsDisabledSchemes.isEmpty()) {
            schemeNames = String.join((CharSequence)", ", tlsDisabledSchemes);
            items.add(this.builder.makeAlert().withSummary(KERB_TLS_DISABLED_SUMMARY, new Object[]{schemeNames}).withDescription(KERB_TLS_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private static boolean isTlsEnabled(BKerberosAuthenticationScheme scheme) {
        BKerberosConfig config = scheme.getConfig();
        return BBoolean.TRUE.equals((Object)config.get("SSL"));
    }

    private static List<BKerberosAuthenticationScheme> getKerberosSchemes(BAuthenticationService authService) {
        return authService.getSupportedSchemes().stream().filter(scheme -> scheme instanceof BKerberosAuthenticationScheme).map(scheme -> (BKerberosAuthenticationScheme)((Object)scheme)).collect(Collectors.toList());
    }
}

