/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BDelVarHistoryRecord;
import com.tridium.tls.datatypes.BDeliveryVarianceEntry;
import com.tridium.tls.datatypes.BDeliveryVarianceTable;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350DeliveryVarianceReport;
import com.tridium.tls.messages.Tls350DeliveryVarianceReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350DvDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTls350DelVarProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    public static final Property minimumPollInterval = BTls350DelVarProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property deliveryVarianceTable = BTls350DelVarProxyExt.newProperty((int)0, (BValue)new BDeliveryVarianceTable(), null);
    public static final Property maxOldEntriesSaved = BTls350DelVarProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Action purgeHashtable = BTls350DelVarProxyExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BTls350DelVarProxyExt.class);
    private Vector<BDeliveryVarianceEntry> dVEntriesVector;
    private Hashtable<Long, BDeliveryVarianceEntry> dVHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;

    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    public BDeliveryVarianceTable getDeliveryVarianceTable() {
        return (BDeliveryVarianceTable)this.get(deliveryVarianceTable);
    }

    public void setDeliveryVarianceTable(BDeliveryVarianceTable v) {
        this.set(deliveryVarianceTable, (BValue)v, null);
    }

    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    public void setMaxOldEntriesSaved(int v) {
        this.setInt(maxOldEntriesSaved, v, null);
    }

    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BDeliveryVarianceEntry[] saved = this.getDeliveryVarianceTable().getEntries();
            this.dVHashtable = new Hashtable(saved.length * 2);
            for (int i = 0; i < saved.length; ++i) {
                Long key = saved[i].getHTKey();
                this.dVHashtable.put(key, saved[i]);
            }
            TlsHistoryHelper.initHistory(BDelVarHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.dVHashtable = null;
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        int tankNumber = ((BTls350FuelTankDevice)this.device()).getTankNumber();
        Tls350DeliveryVarianceReport req = new Tls350DeliveryVarianceReport(tankNumber, this);
        Tls350DeliveryVarianceReportResponse rsp = (Tls350DeliveryVarianceReportResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                Tls350DeliveryVarianceReportResponse.DeliveryVariance[] entries = rsp.getDeliveryVariances();
                if (entries == null || entries.length <= 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + entries.length + " entries");
                }
                if (tankNumber == 0) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! proxy point's tank number not initialized... initialize tank number to valid tank\n\n");
                    return;
                }
                if (tankNumber != entries[0].getTankNumber()) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + entries[0].getTankNumber() + " may be lost\n\n");
                    }
                    return;
                }
                this.dVEntriesVector = new Vector();
                boolean newEntryDetected = false;
                for (int i = entries.length - 1; i > -1; --i) {
                    BDeliveryVarianceEntry newDVntry = new BDeliveryVarianceEntry();
                    newDVntry.setStore(Sys.getStation().getStationName());
                    newDVntry.setTank(tankNumber);
                    newDVntry.setProduct(entries[i].getProduct());
                    newDVntry.setProbe(entries[i].getProbe());
                    newDVntry.setDeliveryTime(entries[i].getDeliveryTime());
                    newDVntry.setTicketVolume(entries[i].getTicketVolume());
                    newDVntry.setGuagedVolume(entries[i].getGuagedVolume());
                    newDVntry.setDeliveryVariance(entries[i].getDeliveryVarance());
                    BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (newDVntry.getDeliveryTime().isBefore(previousTime)) {
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newDVntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    Long newHtKey = newDVntry.getHTKey();
                    if (this.dVHashtable == null || this.dVHashtable.get(newHtKey) == null || newEntryDetected) {
                        this.dVHashtable.put(newHtKey, newDVntry);
                        this.dVEntriesVector.addElement(newDVntry);
                        newEntryDetected = true;
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + newDVntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    if (!pollDebug) continue;
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newDVntry.createCommaDelimitedString() + " for " + this.getName());
                }
                if (this.dVEntriesVector.size() > 0) {
                    this.setValue(this.dVEntriesVector);
                    return;
                }
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)sv);
                this.updateDemuxedProxyPoints();
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector<BDeliveryVarianceEntry> values) {
        BDeliveryVarianceEntry[] valuesCopy = new BDeliveryVarianceEntry[values.size()];
        values.copyInto((Object[])valuesCopy);
        BDeliveryVarianceTable sendToCsMgrCopy = new BDeliveryVarianceTable();
        for (int i = 0; i < valuesCopy.length; ++i) {
            try {
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                String newValue = valuesCopy[i].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + newValue);
                }
                sv.setValue(newValue);
                this.readOk((BStatusValue)sv);
                this.getDeliveryVarianceTable().add("deliveryVarianceEntry?", (BValue)valuesCopy[i]);
                sendToCsMgrCopy.add("deliveryVarianceEntry?", (BValue)((BDeliveryVarianceEntry)valuesCopy[i].newCopy()));
                BDelVarHistoryRecord newrec = new BDelVarHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), valuesCopy[i]);
                TlsHistoryHelper.appendTlsHistory((BStruct)newrec);
                continue;
            }
            catch (Exception e) {
                this.readFail(e.toString());
            }
        }
        this.updateDemuxedProxyPoints();
        BDeliveryVarianceEntry[] sortedValues = this.getDeliveryVarianceTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        int numRemoveEntries = sortedValues.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350DelVarProxyExt setValue sortedValues.length=" + sortedValues.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (numRemoveEntries > 0) {
            Vector<BDeliveryVarianceEntry> removeEntries = new Vector<BDeliveryVarianceEntry>();
            for (int i = 0; i < numRemoveEntries; ++i) {
                removeEntries.addElement(sortedValues[i]);
            }
            Enumeration re = removeEntries.elements();
            while (re.hasMoreElements()) {
                BDeliveryVarianceEntry oldestEntryCopy = (BDeliveryVarianceEntry)((Object)re.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350DelVarProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + oldestEntryCopy.createCommaDelimitedString());
                }
                this.getDeliveryVarianceTable().remove((BComplex)oldestEntryCopy);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, sendToCsMgrCopy));
    }

    private void updateDemuxedProxyPoints() {
        BDeliveryVarianceEntry[] sortedValues = this.getDeliveryVarianceTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        BDeliveryVarianceEntry mostRecentValue = sortedValues[sortedValues.length - 1];
        String[] demuxedValueStrings = CsMgrBaseUtil.createStringArrayOfAllNames((String)mostRecentValue.createCommaDelimitedString());
        if (demuxedValueStrings != null && demuxedValueStrings.length > 0) {
            BControlPoint[] dCPA;
            BTls350DvDemuxedPointDeviceExt dvdExt = null;
            BDeviceExt[] exts = this.getDevice().getDeviceExts();
            for (int k = 0; k < exts.length; ++k) {
                if (!(exts[k] instanceof BTls350DvDemuxedPointDeviceExt)) continue;
                dvdExt = (BTls350DvDemuxedPointDeviceExt)exts[k];
                break;
            }
            if (dvdExt != null && (dCPA = dvdExt.getPoints()) != null && dCPA.length > 0) {
                for (int k = 0; k < dCPA.length; ++k) {
                    if (dCPA[k].getProxyExt().getType() != BTls350DemuxedProxyExt.TYPE) continue;
                    ((BTls350DemuxedProxyExt)dCPA[k].getProxyExt()).updateValueFrom(demuxedValueStrings);
                }
            }
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }

    @Override
    public void clearDataNow() {
        this.getDeliveryVarianceTable().lease(2);
        BDeliveryVarianceEntry[] dve = (BDeliveryVarianceEntry[])this.getDeliveryVarianceTable().getChildren(BDeliveryVarianceEntry.class);
        if (dve != null && dve.length > 0) {
            for (int i = 0; i < dve.length; ++i) {
                this.getDeliveryVarianceTable().remove((BComplex)dve[i]);
            }
        }
        this.dVHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context cx) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration<Long> dVkeys = this.dVHashtable.keys();
        while (dVkeys.hasMoreElements()) {
            Long nextKey = dVkeys.nextElement();
            BDeliveryVarianceEntry nextEntry = this.dVHashtable.get(nextKey);
            BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!nextEntry.getDeliveryTime().isBefore(previousTime)) continue;
            this.dVHashtable.remove(nextKey);
        }
        this.reschedPurgeHashtable();
    }

    private void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime nextChangeOfDay = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)nextChangeOfDay, (Action)purgeHashtable, null);
    }
}

