/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls350Message;
import com.tridium.tls.messages.Tls350StatusReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsReceivedMessage;
import com.tridium.tls.point.BTls350InTankStaProxyExt;
import javax.baja.nre.util.ByteArrayUtil;

public class Tls350StatusReport
extends Tls350Message
implements TlsMessageConst {
    private BTls350InTankStaProxyExt ext;
    private boolean debug;

    public Tls350StatusReport() {
    }

    public Tls350StatusReport(int tank) {
        super("205", tank);
    }

    public Tls350StatusReport(int tank, BTls350InTankStaProxyExt ext) {
        super("205", tank);
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    @Override
    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        if (this.debug) {
            this.ext.getLog().trace("TlsStaReport :toResponse []=" + ByteArrayUtil.toHexString((byte[])rmBytes, (int)0, (int)rmBytes.length));
        }
        Tls350StatusReportResponse rsp = new Tls350StatusReportResponse(this.ext);
        rsp.readResponse(rmBytes);
        return rsp;
    }
}

