/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350LiqSenStaProxyExt;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;

public class Tls350LiqSenDiagReportResponse
extends Tls350Response {
    public BAbsTime readTime;
    private int sensorNumber;
    private BTls350LiqSenStaProxyExt ext;
    private boolean debug;
    private boolean debug_negative;
    private int numberFieldsToFollowInt;
    private float sampleCounter;
    private float highRefCount;
    private float lowRefCount;
    private float liqChanLastRead;
    private float liqChanAvgRead;

    public Tls350LiqSenDiagReportResponse() {
    }

    public Tls350LiqSenDiagReportResponse(BTls350LiqSenStaProxyExt ext) {
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public int getSensorNumber() {
        return this.sensorNumber;
    }

    public float getSampleCounter() {
        return this.sampleCounter;
    }

    public float getHighRefCount() {
        return this.highRefCount;
    }

    public float getLowRefCount() {
        return this.lowRefCount;
    }

    public float getLiqChanLastRead() {
        return this.liqChanLastRead;
    }

    public float getLiqChanAvgRead() {
        return this.liqChanAvgRead;
    }

    @Override
    public TlsInputStream readResponse(byte[] message) {
        TlsInputStream inStream = super.readResponse(message);
        if (this.debug) {
            this.ext.getLog().trace("TlsLSDRResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (inStream.available() < 16) {
            return inStream;
        }
        this.readTime = inStream.readDateTime(true);
        boolean readResponseDone = false;
        while (!readResponseDone) {
            inStream.mark(0);
            String dataTerminationTest = inStream.readString(2);
            if (dataTerminationTest.equals("&&")) break;
            inStream.reset();
            if (inStream.available() < 8 || this.tank <= 0) break;
            this.sensorNumber = inStream.readAsciiInt(2);
            this.numberFieldsToFollowInt = inStream.readAsciiHex(2);
            if (this.debug) {
                this.ext.getLog().trace("TlsLSDRResponse :readResponse numberFieldsToFollowInt=" + this.numberFieldsToFollowInt);
            }
            block8: for (int j = 0; j < this.numberFieldsToFollowInt; ++j) {
                float flTemp = inStream.readAsciiFloat();
                if (this.debug) {
                    this.ext.getLog().trace("TlsLSDRResponse :readResponse j=" + j + " flTemp=" + flTemp);
                }
                if (flTemp < 0.0f && this.debug_negative) {
                    System.out.println("ADRR (-) value=" + flTemp + " j=" + j);
                    System.out.println("ADRR - ba=" + ByteArrayUtil.toHexString((byte[])message, (int)0, (int)message.length));
                }
                switch (j) {
                    case 0: {
                        this.sampleCounter = j < this.numberFieldsToFollowInt ? flTemp : Float.NaN;
                        continue block8;
                    }
                    case 1: {
                        this.highRefCount = j < this.numberFieldsToFollowInt ? flTemp : Float.NaN;
                        continue block8;
                    }
                    case 2: {
                        this.lowRefCount = j < this.numberFieldsToFollowInt ? flTemp : Float.NaN;
                        continue block8;
                    }
                    case 3: {
                        this.liqChanLastRead = j < this.numberFieldsToFollowInt ? flTemp : Float.NaN;
                        continue block8;
                    }
                    case 4: {
                        this.liqChanAvgRead = j < this.numberFieldsToFollowInt ? flTemp : Float.NaN;
                    }
                }
            }
            if (!this.debug) continue;
            this.ext.getLog().trace("TlsIRRResponse :readResponse values = " + this.sampleCounter + "|" + this.highRefCount + "|" + this.lowRefCount + "|" + this.liqChanLastRead + "|" + this.liqChanAvgRead);
        }
        return inStream;
    }
}

