/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.datatypes;

import com.tridium.tls.datatypes.BInTankStatusEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInTankStaHistoryRecord
extends BHistoryRecord {
    public static final Property store = BInTankStaHistoryRecord.newProperty((int)0, (String)"", null);
    public static final Property tank = BInTankStaHistoryRecord.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property readTime = BInTankStaHistoryRecord.newProperty((int)0, (BValue)BAbsTime.make(), null);
    public static final Property inTankAlarmType = BInTankStaHistoryRecord.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BInTankStaHistoryRecord.class);

    public String getStore() {
        return this.getString(store);
    }

    public void setStore(String v) {
        this.setString(store, v, null);
    }

    public int getTank() {
        return this.getInt(tank);
    }

    public void setTank(int v) {
        this.setInt(tank, v, null);
    }

    public BAbsTime getReadTime() {
        return (BAbsTime)this.get(readTime);
    }

    public void setReadTime(BAbsTime v) {
        this.set(readTime, (BValue)v, null);
    }

    public String getInTankAlarmType() {
        return this.getString(inTankAlarmType);
    }

    public void setInTankAlarmType(String v) {
        this.setString(inTankAlarmType, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BInTankStaHistoryRecord() {
    }

    public BInTankStaHistoryRecord(BAbsTime timestamp, String store, int tank, BAbsTime readTime, String inTankAlarmType) {
        super(timestamp);
        this.setStore(store);
        this.setTank(tank);
        this.setReadTime(readTime);
        this.setInTankAlarmType(inTankAlarmType);
    }

    public BInTankStaHistoryRecord(BAbsTime timestamp, BInTankStatusEntry entry) {
        super(timestamp);
        this.setStore(entry.getStore());
        this.setTank(entry.getTank());
        this.setReadTime((BAbsTime)entry.getReadTime().newCopy());
        this.setInTankAlarmType(entry.getInTankAlarmType());
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput in) throws IOException {
        this.setStore(in.readUTF());
        this.setTank(in.readInt());
        this.setReadTime(BAbsTime.make((long)in.readLong()));
        this.setInTankAlarmType(in.readUTF());
    }

    protected void doWrite(DataOutput out) throws IOException {
        out.writeUTF(this.getStore());
        out.writeInt(this.getTank());
        out.writeLong(this.getReadTime().getMillis());
        out.writeUTF(this.getInTankAlarmType());
    }

    public String toString(Context ctx) {
        StringBuffer s = new StringBuffer(32);
        s.append(super.toString(ctx));
        return s.toString();
    }
}

