/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.datatypes;

import com.tridium.tls.datatypes.BDeliveryVarianceEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDelVarHistoryRecord
extends BHistoryRecord {
    public static final Property store = BDelVarHistoryRecord.newProperty((int)0, (String)"", null);
    public static final Property tank = BDelVarHistoryRecord.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property product = BDelVarHistoryRecord.newProperty((int)0, (String)"XX", null);
    public static final Property probe = BDelVarHistoryRecord.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property deliveryTime = BDelVarHistoryRecord.newProperty((int)0, (BValue)BAbsTime.make(), null);
    public static final Property ticketVolume = BDelVarHistoryRecord.newProperty((int)0, (float)0.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property guagedVolume = BDelVarHistoryRecord.newProperty((int)0, (float)0.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property deliveryVariance = BDelVarHistoryRecord.newProperty((int)0, (float)0.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Type TYPE = Sys.loadType(BDelVarHistoryRecord.class);

    public String getStore() {
        return this.getString(store);
    }

    public void setStore(String v) {
        this.setString(store, v, null);
    }

    public int getTank() {
        return this.getInt(tank);
    }

    public void setTank(int v) {
        this.setInt(tank, v, null);
    }

    public String getProduct() {
        return this.getString(product);
    }

    public void setProduct(String v) {
        this.setString(product, v, null);
    }

    public int getProbe() {
        return this.getInt(probe);
    }

    public void setProbe(int v) {
        this.setInt(probe, v, null);
    }

    public BAbsTime getDeliveryTime() {
        return (BAbsTime)this.get(deliveryTime);
    }

    public void setDeliveryTime(BAbsTime v) {
        this.set(deliveryTime, (BValue)v, null);
    }

    public float getTicketVolume() {
        return this.getFloat(ticketVolume);
    }

    public void setTicketVolume(float v) {
        this.setFloat(ticketVolume, v, null);
    }

    public float getGuagedVolume() {
        return this.getFloat(guagedVolume);
    }

    public void setGuagedVolume(float v) {
        this.setFloat(guagedVolume, v, null);
    }

    public float getDeliveryVariance() {
        return this.getFloat(deliveryVariance);
    }

    public void setDeliveryVariance(float v) {
        this.setFloat(deliveryVariance, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDelVarHistoryRecord() {
    }

    public BDelVarHistoryRecord(BAbsTime timestamp, String store, int tank, String product, int probe, BAbsTime deliveryTime, float ticketVolume, float guagedVolume, float deliveryVariance) {
        super(timestamp);
        this.setStore(store);
        this.setTank(tank);
        this.setProduct(product);
        this.setProbe(probe);
        this.setDeliveryTime(deliveryTime);
        this.setTicketVolume(ticketVolume);
        this.setGuagedVolume(guagedVolume);
        this.setDeliveryVariance(deliveryVariance);
    }

    public BDelVarHistoryRecord(BAbsTime timestamp, BDeliveryVarianceEntry entry) {
        super(timestamp);
        this.setStore(entry.getStore());
        this.setTank(entry.getTank());
        this.setProduct(entry.getProduct());
        this.setProbe(entry.getProbe());
        this.setDeliveryTime((BAbsTime)entry.getDeliveryTime().newCopy());
        this.setTicketVolume(entry.getTicketVolume());
        this.setGuagedVolume(entry.getGuagedVolume());
        this.setDeliveryVariance(entry.getDeliveryVariance());
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput in) throws IOException {
        this.setStore(in.readUTF());
        this.setTank(in.readInt());
        this.setProduct(in.readUTF());
        this.setProbe(in.readInt());
        this.setDeliveryTime(BAbsTime.make((long)in.readLong()));
        this.setTicketVolume(in.readFloat());
        this.setGuagedVolume(in.readFloat());
        this.setDeliveryVariance(in.readFloat());
    }

    protected void doWrite(DataOutput out) throws IOException {
        out.writeUTF(this.getStore());
        out.writeInt(this.getTank());
        out.writeUTF(this.getProduct());
        out.writeInt(this.getProbe());
        out.writeLong(this.getDeliveryTime().getMillis());
        out.writeFloat(this.getTicketVolume());
        out.writeFloat(this.getGuagedVolume());
        out.writeFloat(this.getDeliveryVariance());
    }

    public String toString(Context ctx) {
        StringBuffer s = new StringBuffer(32);
        s.append(super.toString(ctx));
        return s.toString();
    }
}

