/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.consoles;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.tls.BTlsConsole;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.BTlsDeviceFolder;
import com.tridium.tls.comm.TlsTcpIpComm;
import com.tridium.tls.comm.TlsTcpIpCommReceiver;
import com.tridium.tls.comm.TlsTcpIpCommTransmitter;
import com.tridium.tls.devices.BTls250FuelTankDevice;
import com.tridium.tls.devices.BTls350ConsoleDevice;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.enums.BTlsCommTypeEnum;
import com.tridium.tls.enums.BTlsSocketStateEnum;
import com.tridium.tls.messages.TlsMessageConst;
import java.net.InetAddress;
import javax.baja.driver.BDevice;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTlsTcpIpConsole
extends BTlsConsole
implements TlsMessageConst {
    public static final Property commType = BComplex.newProperty((int)0, (BValue)BTlsCommTypeEnum.tcpip, null);
    public static final Property maxFailsUntilDeviceDown = BComplex.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property ipAddress = BComplex.newProperty((int)16, (String)"###.###.###.###", null);
    public static final Property port = BComplex.newProperty((int)16, (int)10001, (BFacets)BFacets.makeInt(null, (int)0, (int)99999));
    public static final Property shareTcpipConnection = BComplex.newProperty((int)0, (boolean)false, null);
    public static final Property statusTcpipConnection = BComplex.newProperty((int)1, (BValue)BTlsSocketStateEnum.Closed, null);
    public static final Type TYPE = Sys.loadType(BTlsTcpIpConsole.class);
    protected Subscriber subscriber;
    protected boolean commActive = false;
    protected boolean networkInitialized = false;
    private long totalCrcErrors = 0L;
    private long totalLrcErrors = 0L;

    public BTlsCommTypeEnum getCommType() {
        return (BTlsCommTypeEnum)this.get(commType);
    }

    public void setCommType(BTlsCommTypeEnum v) {
        this.set(commType, (BValue)v, null);
    }

    public int getMaxFailsUntilDeviceDown() {
        return this.getInt(maxFailsUntilDeviceDown);
    }

    public void setMaxFailsUntilDeviceDown(int v) {
        this.setInt(maxFailsUntilDeviceDown, v, null);
    }

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public boolean getShareTcpipConnection() {
        return this.getBoolean(shareTcpipConnection);
    }

    public void setShareTcpipConnection(boolean v) {
        this.setBoolean(shareTcpipConnection, v, null);
    }

    public BTlsSocketStateEnum getStatusTcpipConnection() {
        return (BTlsSocketStateEnum)this.get(statusTcpipConnection);
    }

    public void setStatusTcpipConnection(BTlsSocketStateEnum v) {
        this.set(statusTcpipConnection, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.subscriber = new NameSubscriber(this);
        this.subscriber.subscribe((BComponent)this.getParent());
    }

    public void serviceStopped() throws Exception {
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
        super.serviceStopped();
    }

    @Override
    public Type getDeviceType() {
        return BTlsDevice.TYPE;
    }

    @Override
    public Type getDeviceFolderType() {
        return BTlsDeviceFolder.TYPE;
    }

    public BTlsTcpIpConsole() {
        this.setFlags((Slot)BLoadableNetwork.upload, 4);
        this.setFlags((Slot)BLoadableNetwork.download, 4);
        this.setResponseTimeout(BRelTime.make((long)5000L));
    }

    protected Comm makeComm() {
        return new TlsTcpIpComm(this, new TlsTcpIpCommReceiver(), new TlsTcpIpCommTransmitter());
    }

    public void startComm() throws Exception {
        super.startComm();
        if (!(this.isDisabled() || this.isFatalFault() || this.isDown() || this.initializeNetwork())) {
            this.getLog().warning("Unable to initialize network " + this.getName() + "!!");
        }
    }

    public void stopComm() throws Exception {
        super.stopComm();
        this.commActive = false;
        this.networkInitialized = false;
    }

    protected boolean initializeNetwork() {
        if (this.networkInitialized) {
            return true;
        }
        this.commActive = true;
        if (!this.getComm().isCommStarted()) {
            if (this.getLog().isTraceOn()) {
                this.getLog().warning("Unable to start Tcp/Ip Comm for " + this);
            }
            this.commActive = false;
            return false;
        }
        this.networkInitialized = true;
        return true;
    }

    protected BTlsDevice findDeviceInNetwork(int address) {
        BDevice[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BTlsDevice)) continue;
            if (devices[i] instanceof BTls350ConsoleDevice && address == 0) {
                return (BTls350ConsoleDevice)devices[i];
            }
            if (devices[i] instanceof BTls350FuelTankDevice) {
                if (((BTls350FuelTankDevice)devices[i]).getTankNumber() != address) continue;
                return (BTls350FuelTankDevice)devices[i];
            }
            if (!(devices[i] instanceof BTls250FuelTankDevice) || ((BTls250FuelTankDevice)devices[i]).getTankNumber() != address) continue;
            return (BTls250FuelTankDevice)devices[i];
        }
        return null;
    }

    public boolean isCommActive() {
        return this.commActive && !this.isDisabled() && !this.isDown() && !this.isFatalFault();
    }

    public InetAddress getInetAddr() {
        InetAddress newINet;
        try {
            String url = this.getIpAddress().trim();
            newINet = url.equalsIgnoreCase("###.###.###.###") || url.length() == 0 ? null : InetAddress.getByName(url);
        }
        catch (Exception e) {
            newINet = null;
        }
        return newINet;
    }

    public void changed(Property prop, Context context) {
        block4: {
            super.changed(prop, context);
            try {
                if ((prop.equals(ipAddress) || prop.equals(port)) && this.getComm() != null && this.getComm().isCommStarted()) {
                    this.getComm().stop();
                    InetAddress ipaddr = this.getInetAddr();
                    if (ipaddr == null && this.getLog() != null) {
                        this.getLog().error("\nCould not resolve IP address [" + this.getIpAddress() + "].");
                    }
                    this.getComm().start();
                }
            }
            catch (Exception e) {
                if (this.getLog() == null) break block4;
                this.getLog().error("Caught exception in BTlsTcpIpConsole.changed()", (Throwable)e);
            }
        }
    }

    protected void processNameSubscriberEvent(BComponentEvent event) {
    }

    protected Subscriber getNameSubscriber() {
        return this.subscriber;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"TlsNetwork", 2);
        out.prop((Object)"Total CRC Errors", (Object)new Long(this.totalCrcErrors));
        out.prop((Object)"Total LRC Errors", (Object)new Long(this.totalLrcErrors));
        out.endProps();
    }

    public final void incrementCrcErrors() {
        ++this.totalCrcErrors;
    }

    public final void incrementLrcErrors() {
        ++this.totalLrcErrors;
    }

    private class NameSubscriber
    extends Subscriber {
        private BTlsTcpIpConsole net;

        public NameSubscriber(BTlsTcpIpConsole net) {
            this.net = net;
        }

        public void event(BComponentEvent event) {
            this.net.processNameSubscriberEvent(event);
        }
    }
}

