/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransaction;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.tls.TlsException;
import com.tridium.tls.comm.TlsTcpIpCommReceiver;
import com.tridium.tls.comm.TlsTcpIpCommTransmitter;
import com.tridium.tls.consoles.BTlsTcpIpConsole;
import com.tridium.tls.enums.BTlsSocketStateEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;

public class TlsTcpIpComm
extends Comm {
    protected Thread tcpRxThread;
    private Socket commSocket;
    private BTlsTcpIpConsole network;
    private int socketConnectionAttemptCount;
    private boolean socketConnectionAttemptAlarmLastSent;

    public TlsTcpIpComm(BTlsTcpIpConsole tcpNetwork, TlsTcpIpCommReceiver rDriver, TlsTcpIpCommTransmitter tDriver) {
        super((BBasicNetwork)tcpNetwork, (CommReceiver)rDriver, (CommTransmitter)tDriver);
        this.network = tcpNetwork;
    }

    protected boolean started() throws Exception {
        this.getCommReceiver().setAlive(true);
        this.tcpRxThread = new Thread((Runnable)this.getCommReceiver(), " " + this.network.getName());
        this.tcpRxThread.start();
        this.tcpRxThread.setPriority(5);
        return true;
    }

    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.tcpRxThread != null) {
            int rspTimeoutValue = (int)this.network.getResponseTimeout().getMillis();
            try {
                ((Object)((Object)this)).wait(rspTimeoutValue + 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closeSocket();
            this.tcpRxThread.interrupt();
            this.closeSocket();
        }
    }

    public void closeSocket() {
        if (this.commSocket != null) {
            try {
                this.commSocket.close();
                if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm1") != -1) {
                    this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- closeSocket()... SOCKET connection closed !!!!!!");
                }
            }
            catch (Exception e) {
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- closeSocket()... SOCKET connection close failed !!!!!!");
            }
            this.commSocket = null;
            this.network.setStatusTcpipConnection(BTlsSocketStateEnum.Closed);
        }
    }

    private void connectSocket() throws Exception {
        if (this.network == null) {
            throw new TlsException(102);
        }
        InetAddress ip = this.network.getInetAddr();
        if (ip == null) {
            throw new TlsException(103);
        }
        this.commSocket = new Socket(ip, this.network.getPort());
        this.network.setStatusTcpipConnection(BTlsSocketStateEnum.Connected);
    }

    protected synchronized boolean initSocketConnection() {
        try {
            this.closeSocket();
            this.connectSocket();
            this.getCommReceiver().setInputStream((InputStream)new BufferedInputStream(this.commSocket.getInputStream()));
            this.getCommTransmitter().setOutputStream((OutputStream)new BufferedOutputStream(this.commSocket.getOutputStream()));
        }
        catch (SocketException e) {
            if (this.network.getLog().isTraceOn()) {
                BAbsTime curTime = BAbsTime.make();
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- initSocketConnection()... SocketException e=" + e + "!!!!!! time=" + curTime);
                this.network.getLog().trace(" Ip: " + this.network.getInetAddr() + ": " + this.network.getPort());
            }
            ++this.socketConnectionAttemptCount;
            if (this.socketConnectionAttemptCount > 10 && !this.socketConnectionAttemptAlarmLastSent) {
                this.socketConnectionAttemptAlarmLastSent = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception curTime) {
                // empty catch block
            }
            return false;
        }
        catch (Exception e) {
            if (this.network.getLog().isTraceOn()) {
                BAbsTime curTime = BAbsTime.make();
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- initSocketConnection()... Exception e=" + e + "!!!!!! time=" + curTime);
                this.network.getLog().trace(" Ip: " + this.network.getInetAddr() + ": " + this.network.getPort());
            }
            if (this.socketConnectionAttemptCount > 10 && !this.socketConnectionAttemptAlarmLastSent) {
                this.socketConnectionAttemptAlarmLastSent = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        this.socketConnectionAttemptCount = 0;
        if (this.socketConnectionAttemptAlarmLastSent) {
            this.socketConnectionAttemptAlarmLastSent = false;
        }
        return true;
    }

    public void transmitNoResponse(Message msg) throws TlsException {
        if (msg == null) {
            this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- transmitNoResponse(.)... msg==null!!!!!!");
            return;
        }
        if (!this.isCommStarted()) {
            throw new TlsException("Communication handler service not started.");
        }
        if (this.network.isCommActive()) {
            if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm1") != -1) {
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- transmitNoResponse(.)... init socket connection if sharing!!!!!!");
            }
            if (!((TlsTcpIpComm)this.network.getComm()).initSocketConnection()) {
                return;
            }
        }
        this.getCommTransmitter().writeMessage(msg);
        this.network.incrementSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message processTransmit(Message msg, BRelTime responseTimeout) throws TlsException {
        CommTransaction transaction;
        if (!this.isCommStarted()) {
            throw new TlsException("Communication handler service not started.");
        }
        if (this.network.isCommActive()) {
            if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm1") != -1) {
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- processTransmit(..)... init socket connection if sharing!!!!!!");
            }
            if (!((TlsTcpIpComm)this.network.getComm()).initSocketConnection()) {
                return null;
            }
        }
        CommTransaction commTransaction = transaction = this.getCommTransactionManager().getCommTransaction(msg);
        synchronized (commTransaction) {
            block20: {
                if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm1") != -1) {
                    this.network.getLog().trace(this.network.getName() + " TlsTcpIpComm - processTransmit(..)... getting xmtr and passing outgoing message");
                }
                this.getCommTransmitter().writeMessage(msg);
                this.network.incrementSent();
                try {
                    if (transaction.isComplete()) break block20;
                    if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm1") != -1) {
                        this.network.getLog().trace(this.network.getName() + " TlsTcpIpComm - processTransmit(..)... waiting responseTimeout for response");
                    }
                    transaction.wait(responseTimeout.getMillis());
                    if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm1") != -1) {
                        this.network.getLog().trace(this.network.getName() + " TlsTcpIpComm - processTransmit(..)... wake from waiting responseTimeout for response");
                    }
                    if (!transaction.isComplete()) {
                        if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm1") != -1) {
                            Object reqTag = transaction.getRequestMessage().getTag();
                            this.network.getLog().trace(this.network.getName() + "TlsTcpIpComm - processTransmit(..)... CommTransaction timed out (tag: " + reqTag + ")");
                            if (reqTag != Message.DEFAULT_TAG) {
                                try {
                                    Message req = transaction.getRequestMessage();
                                    if (req != null) {
                                        this.network.getLog().trace(this.network.getName() + "TlsTcpIpComm - processTransmit(..)... Failure to get response for sent message: " + req.toDebugString());
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm1") != -1) {
                            this.network.getLog().trace(this.network.getName() + " TlsTcpIpComm - TlsTcpIpComm - processTransmit(..)... response was null... <" + (Object)((Object)this) + ">");
                        }
                        transaction.setResponseMessage(null);
                        this.network.incrementTimeouts();
                    }
                    transaction.setComplete(true);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Message resp = transaction.getResponseMessage();
        if (this.network.getShareTcpipConnection()) {
            this.closeSocket();
            this.network.setStatusTcpipConnection(BTlsSocketStateEnum.Closed);
        }
        this.getCommTransactionManager().freeCommTransaction(transaction);
        return resp;
    }
}

